/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.event;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.event.AbstractEventSupport;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.ChangeSet;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.agent.KnowledgeAgent;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.definition.KnowledgeDefinition;
import org.kie.internal.event.knowledgeagent.AfterChangeSetAppliedEvent;
import org.kie.internal.event.knowledgeagent.AfterChangeSetProcessedEvent;
import org.kie.internal.event.knowledgeagent.AfterResourceProcessedEvent;
import org.kie.internal.event.knowledgeagent.BeforeChangeSetAppliedEvent;
import org.kie.internal.event.knowledgeagent.BeforeChangeSetProcessedEvent;
import org.kie.internal.event.knowledgeagent.BeforeResourceProcessedEvent;
import org.kie.internal.event.knowledgeagent.KnowledgeAgentEventListener;
import org.kie.internal.event.knowledgeagent.KnowledgeBaseUpdatedEvent;
import org.kie.internal.event.knowledgeagent.ResourceCompilationFailedEvent;

public class KnowledgeAgentEventSupport
extends AbstractEventSupport<KnowledgeAgentEventListener> {
    public void fireBeforeChangeSetApplied(ChangeSet changeSet) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            BeforeChangeSetAppliedEvent event = new BeforeChangeSetAppliedEvent(changeSet);
            do {
                ((KnowledgeAgentEventListener)iter.next()).beforeChangeSetApplied(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterChangeSetApplied(ChangeSet changeSet) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            AfterChangeSetAppliedEvent event = new AfterChangeSetAppliedEvent(changeSet);
            do {
                ((KnowledgeAgentEventListener)iter.next()).afterChangeSetApplied(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeChangeSetProcessed(ChangeSet changeSet) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            do {
                BeforeChangeSetProcessedEvent event = new BeforeChangeSetProcessedEvent(changeSet);
                ((KnowledgeAgentEventListener)iter.next()).beforeChangeSetProcessed(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterChangeSetProcessed(ChangeSet changeSet, List<Resource> addedResources, Map<Resource, Set<KnowledgeDefinition>> modifiedResourceMappings, Map<Resource, Set<KnowledgeDefinition>> removedResourceMappings) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            do {
                AfterChangeSetProcessedEvent event = new AfterChangeSetProcessedEvent(changeSet, addedResources, modifiedResourceMappings, removedResourceMappings);
                ((KnowledgeAgentEventListener)iter.next()).afterChangeSetProcessed(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeResourceProcessed(ChangeSet changeSet, Resource resource, ResourceType type, KnowledgeAgent.ResourceStatus status) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            do {
                BeforeResourceProcessedEvent event = new BeforeResourceProcessedEvent(changeSet, resource, type, status);
                ((KnowledgeAgentEventListener)iter.next()).beforeResourceProcessed(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterResourceProcessed(ChangeSet changeSet, Resource resource, ResourceType type, KnowledgeAgent.ResourceStatus status) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            do {
                AfterResourceProcessedEvent event = new AfterResourceProcessedEvent(changeSet, resource, type, status);
                ((KnowledgeAgentEventListener)iter.next()).afterResourceProcessed(event);
            } while (iter.hasNext());
        }
    }

    public void fireKnowledgeBaseUpdated(KnowledgeBase kbase) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            do {
                KnowledgeBaseUpdatedEvent event = new KnowledgeBaseUpdatedEvent(kbase);
                ((KnowledgeAgentEventListener)iter.next()).knowledgeBaseUpdated(event);
            } while (iter.hasNext());
        }
    }

    public void fireResourceCompilationFailed(KnowledgeBuilder kbuilder, Resource resource, ResourceType type) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            do {
                ResourceCompilationFailedEvent event = new ResourceCompilationFailedEvent(kbuilder, resource, type);
                ((KnowledgeAgentEventListener)iter.next()).resourceCompilationFailed(event);
            } while (iter.hasNext());
        }
    }

    public void reset() {
        this.clear();
    }
}

