/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Comparator;
import org.drools.core.base.SalienceInteger;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.EventSupport;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.conflict.PhreakConflictResolver;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.spi.Activation;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.index.LeftTupleList;
import org.kie.api.event.rule.MatchCancelledCause;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleExecutor {
    protected static final transient Logger log = LoggerFactory.getLogger(RuleExecutor.class);
    private static final RuleNetworkEvaluator NETWORK_EVALUATOR = new RuleNetworkEvaluator();
    private final PathMemory pmem;
    private final RuleAgendaItem ruleAgendaItem;
    private final LeftTupleList tupleList;
    private BinaryHeapQueue queue;
    private volatile boolean dirty;
    private final boolean declarativeAgendaEnabled;
    private boolean fireExitedEarly;

    public RuleExecutor(PathMemory pmem, RuleAgendaItem ruleAgendaItem, boolean declarativeAgendaEnabled) {
        this.pmem = pmem;
        this.ruleAgendaItem = ruleAgendaItem;
        this.tupleList = new LeftTupleList();
        this.declarativeAgendaEnabled = declarativeAgendaEnabled;
        if (ruleAgendaItem.getRule().getSalience().isDynamic()) {
            this.queue = new BinaryHeapQueue(SalienceComparator.INSTANCE);
        }
    }

    public void evaluateNetwork(InternalWorkingMemory wm) {
        NETWORK_EVALUATOR.evaluateNetwork(this.pmem, this, wm);
        this.setDirty(false);
    }

    public int evaluateNetworkAndFire(InternalWorkingMemory wm, AgendaFilter filter, int fireCount, int fireLimit) {
        this.reEvaluateNetwork(wm);
        return this.fire(wm, filter, fireCount, fireLimit, wm.getAgenda());
    }

    public void fire(InternalWorkingMemory wm) {
        this.fire(wm, null, 0, Integer.MAX_VALUE, wm.getAgenda());
    }

    private int fire(InternalWorkingMemory wm, AgendaFilter filter, int fireCount, int fireLimit, InternalAgenda agenda) {
        int localFireCount = 0;
        if (!this.tupleList.isEmpty()) {
            RuleAgendaItem nextRule;
            if (!this.fireExitedEarly && this.isDeclarativeAgendaEnabled() && !this.isHigherSalience(nextRule = agenda.peekNextRule())) {
                this.fireExitedEarly = true;
                return localFireCount;
            }
            RuleTerminalNode rtn = (RuleTerminalNode)this.pmem.getNetworkNode();
            RuleImpl rule = rtn.getRule();
            LeftTuple leftTuple = this.getNextLeftTuple();
            if (rule.isAllMatches()) {
                agenda.fireConsequenceEvent((AgendaItem)((Object)leftTuple), "$onBeforeAllFire$");
            }
            LeftTuple lastLeftTuple = null;
            while (leftTuple != null) {
                if (!this.cancelAndContinue(wm, rtn, rule, leftTuple, filter)) {
                    AgendaItem item = (AgendaItem)((Object)leftTuple);
                    if (agenda.getActivationsFilter() == null || agenda.getActivationsFilter().accept(item, wm, rtn)) {
                        agenda.fireActivation(item);
                        ++localFireCount;
                        if (rtn.getLeftTupleSource() == null) break;
                        wm.flushPropagations();
                        int salience = this.ruleAgendaItem.getSalience();
                        if (this.queue != null && !this.queue.isEmpty() && salience != this.queue.peek().getSalience()) {
                            this.ruleAgendaItem.dequeue();
                            this.ruleAgendaItem.setSalience(this.queue.peek().getSalience());
                            this.ruleAgendaItem.getAgendaGroup().add(this.ruleAgendaItem);
                        }
                        if (!rule.isAllMatches()) {
                            if (this.haltRuleFiring(fireCount, fireLimit, localFireCount, agenda)) break;
                            if (!wm.isSequential()) {
                                this.reEvaluateNetwork(wm);
                            }
                        }
                    }
                }
                lastLeftTuple = leftTuple;
                leftTuple = this.getNextLeftTuple();
            }
            if (rule.isAllMatches()) {
                agenda.fireConsequenceEvent((AgendaItem)((Object)lastLeftTuple), "$onAfterAllFire$");
            }
        }
        this.removeRuleAgendaItemWhenEmpty(wm);
        this.fireExitedEarly = false;
        return localFireCount;
    }

    private LeftTuple getNextLeftTuple() {
        LeftTuple leftTuple;
        if (this.tupleList.isEmpty()) {
            return null;
        }
        if (this.queue != null) {
            leftTuple = (LeftTuple)((Object)this.queue.dequeue());
            this.tupleList.remove(leftTuple);
        } else {
            leftTuple = this.tupleList.removeFirst();
            ((Activation)((Object)leftTuple)).setQueued(false);
        }
        return leftTuple;
    }

    public PathMemory getPathMemory() {
        return this.pmem;
    }

    public void removeRuleAgendaItemWhenEmpty(InternalWorkingMemory wm) {
        if (!this.dirty && this.tupleList.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("Removing RuleAgendaItem " + this.ruleAgendaItem);
            }
            this.ruleAgendaItem.remove();
            if (this.ruleAgendaItem.getRule().isQuery()) {
                wm.getAgenda().removeQueryAgendaItem(this.ruleAgendaItem);
            } else if (this.ruleAgendaItem.getRule().isEager()) {
                wm.getAgenda().removeEagerRuleAgendaItem(this.ruleAgendaItem);
            }
        }
    }

    public void reEvaluateNetwork(InternalWorkingMemory wm) {
        if (this.isDirty()) {
            this.setDirty(false);
            NETWORK_EVALUATOR.evaluateNetwork(this.pmem, this, wm);
        }
    }

    public RuleAgendaItem getRuleAgendaItem() {
        return this.ruleAgendaItem;
    }

    private boolean cancelAndContinue(InternalWorkingMemory wm, RuleTerminalNode rtn, RuleImpl rule, LeftTuple leftTuple, AgendaFilter filter) {
        if (!rule.isEffective(leftTuple, rtn, wm)) {
            return true;
        }
        if (rule.getCalendars() != null) {
            long timestamp = wm.getSessionClock().getCurrentTime();
            for (String cal : rule.getCalendars()) {
                if (wm.getCalendars().get(cal).isTimeIncluded(timestamp)) continue;
                return true;
            }
        }
        return filter != null && !filter.accept((Match)((Activation)((Object)leftTuple)));
    }

    private boolean haltRuleFiring(int fireCount, int fireLimit, int localFireCount, InternalAgenda agenda) {
        if (!agenda.isFiring() || fireLimit >= 0 && localFireCount + fireCount >= fireLimit) {
            return true;
        }
        agenda.evaluateEagerList();
        RuleAgendaItem nextRule = agenda.peekNextRule();
        return nextRule != null && (!this.ruleAgendaItem.getAgendaGroup().equals(nextRule.getAgendaGroup()) || !this.isHigherSalience(nextRule));
    }

    private boolean isHigherSalience(RuleAgendaItem nextRule) {
        return PhreakConflictResolver.doCompare(this.ruleAgendaItem, nextRule) >= 0;
    }

    public LeftTupleList getLeftTupleList() {
        return this.tupleList;
    }

    public void addLeftTuple(LeftTuple leftTuple) {
        ((AgendaItem)((Object)leftTuple)).setQueued(true);
        this.tupleList.add(leftTuple);
        if (this.queue != null) {
            this.addQueuedLeftTuple(leftTuple);
        }
    }

    public void addQueuedLeftTuple(LeftTuple leftTuple) {
        int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
        this.queue.enqueue((Activation)((Object)leftTuple));
        this.updateSalience(currentSalience);
    }

    public void removeLeftTuple(LeftTuple leftTuple) {
        ((AgendaItem)((Object)leftTuple)).setQueued(false);
        this.tupleList.remove(leftTuple);
        if (this.queue != null) {
            this.removeQueuedLeftTuple(leftTuple);
        }
    }

    private void removeQueuedLeftTuple(LeftTuple leftTuple) {
        int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
        this.queue.dequeue((Activation)((Object)leftTuple));
        this.updateSalience(currentSalience);
    }

    private void updateSalience(int currentSalience) {
        int newSalience;
        int n = newSalience = this.queue.isEmpty() ? SalienceInteger.DEFAULT_SALIENCE.getValue() : this.queue.peek().getSalience();
        if (currentSalience != newSalience) {
            this.ruleAgendaItem.remove();
        }
        if (!this.ruleAgendaItem.isQueued()) {
            this.ruleAgendaItem.setSalience(newSalience);
            this.ruleAgendaItem.getAgendaGroup().add(this.ruleAgendaItem);
        }
    }

    public void cancel(InternalWorkingMemory wm, EventSupport es) {
        while (!this.tupleList.isEmpty()) {
            RuleTerminalNodeLeftTuple rtnLt = (RuleTerminalNodeLeftTuple)this.tupleList.removeFirst();
            if (this.queue != null) {
                this.queue.dequeue(rtnLt);
            }
            es.getAgendaEventSupport().fireActivationCancelled(rtnLt, wm, MatchCancelledCause.CLEAR);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDeclarativeAgendaEnabled() {
        return this.declarativeAgendaEnabled;
    }

    public static class SalienceComparator
    implements Comparator {
        public static final SalienceComparator INSTANCE = new SalienceComparator();

        public int compare(Object existing, Object adding) {
            int l2;
            int s2;
            RuleTerminalNodeLeftTuple rtnLt1 = (RuleTerminalNodeLeftTuple)existing;
            RuleTerminalNodeLeftTuple rtnLt2 = (RuleTerminalNodeLeftTuple)adding;
            int s1 = rtnLt1.getSalience();
            if (s1 > (s2 = rtnLt2.getSalience())) {
                return 1;
            }
            if (s1 < s2) {
                return -1;
            }
            int l1 = rtnLt1.getRule().getLoadOrder();
            if (l1 < (l2 = rtnLt2.getRule().getLoadOrder())) {
                return 1;
            }
            if (l1 > l2) {
                return -1;
            }
            return 0;
        }
    }
}

