/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.drools.core.command.IdentifiableResult;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.Variable;
import org.kie.internal.command.Context;

@XmlAccessorType(value=XmlAccessType.NONE)
public class QueryCommand
implements GenericCommand<QueryResults>,
IdentifiableResult {
    private static final long serialVersionUID = 510L;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;
    @XmlAttribute(required=true)
    private String name;
    @XmlElement
    private List<Object> arguments;

    public QueryCommand() {
    }

    public QueryCommand(String outIdentifier, String name, Object ... arguments) {
        this.outIdentifier = outIdentifier;
        this.name = name;
        this.arguments = arguments != null ? Arrays.asList(arguments) : Collections.EMPTY_LIST;
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Object> getArguments() {
        if (this.arguments == null) {
            this.arguments = Collections.emptyList();
        }
        return this.arguments;
    }

    public void setArguments(List<Object> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            this.arguments = Collections.emptyList();
        }
        this.arguments = arguments;
    }

    @Override
    public QueryResults execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        if (this.arguments == null || this.arguments.isEmpty()) {
            this.arguments = Collections.emptyList();
        }
        for (int j = 0; j < this.arguments.size(); ++j) {
            if (!(this.arguments.get(j) instanceof Variable)) continue;
            this.arguments.set(j, Variable.v);
        }
        QueryResults results = ksession.getQueryResults(this.name, this.arguments.toArray());
        if (this.outIdentifier != null && ((StatefulKnowledgeSessionImpl)ksession).getExecutionResult() != null) {
            ((StatefulKnowledgeSessionImpl)ksession).getExecutionResult().getResults().put(this.outIdentifier, results);
        }
        return results;
    }

    public String toString() {
        return "QueryCommand{outIdentifier='" + this.outIdentifier + '\'' + ", name='" + this.name + '\'' + ", arguments=" + this.arguments + '}';
    }
}

