/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kie.api.runtime.rule.AccumulateFunction;

public class CollectListAccumulateFunction
implements AccumulateFunction {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public Serializable createContext() {
        return new CollectListData();
    }

    public void init(Serializable context) throws Exception {
        CollectListData data = (CollectListData)context;
        data.list.clear();
    }

    public void accumulate(Serializable context, Object value) {
        CollectListData data = (CollectListData)context;
        data.list.add(value);
    }

    public void reverse(Serializable context, Object value) throws Exception {
        CollectListData data = (CollectListData)context;
        data.list.remove(value);
    }

    public Object getResult(Serializable context) throws Exception {
        CollectListData data = (CollectListData)context;
        return Collections.unmodifiableList(data.list);
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        return List.class;
    }

    public static class CollectListData
    implements Externalizable {
        public List<Object> list = new ArrayList<Object>();

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.list = (List)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.list);
        }
    }
}

