/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Map;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.util.HierarchyEncoderImpl;
import org.drools.core.util.Triple;
import org.drools.core.util.TripleFactory;
import org.kie.api.runtime.rule.Variable;

public abstract class TraitProxy
implements Externalizable,
TraitType,
Comparable<TraitProxy> {
    protected TripleFactory tripleFactory;
    private BitSet typeCode;
    private BitSet typeFilter;
    protected Map<String, Object> fields;

    @Override
    public boolean isVirtual() {
        return false;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    protected void setFields(Map<String, Object> m) {
        this.fields = m;
    }

    @Override
    public abstract String getTraitName();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fields);
        out.writeObject(this.tripleFactory);
        out.writeObject(this.typeCode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fields = (Map)in.readObject();
        this.tripleFactory = (TripleFactory)in.readObject();
        this.typeCode = (BitSet)in.readObject();
    }

    public static Map.Entry<String, Object> buildEntry(final String k, final Object v) {
        return new Map.Entry<String, Object>(){
            private String key;
            private Object obj;
            {
                this.key = k;
                this.obj = v;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public Object getValue() {
                return this.obj;
            }

            @Override
            public Object setValue(Object value) {
                this.obj = value;
                return value;
            }

            public String toString() {
                return "<<" + this.key + "=" + this.obj + ">>";
            }
        };
    }

    public abstract TraitableBean getObject();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getObject().equals(((TraitProxy)o).getObject());
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getObject().hashCode();
    }

    protected Triple propertyKey(String property) {
        return this.getTripleFactory().newTriple((Object)this.getObject(), property, (Object)Variable.v);
    }

    protected Triple property(String property, Object value) {
        return this.getTripleFactory().newTriple((Object)this.getObject(), property, value);
    }

    protected Triple propertyKey(Object property) {
        return this.getTripleFactory().newTriple((Object)this.getObject(), property.toString(), (Object)Variable.v);
    }

    public TripleFactory getTripleFactory() {
        return this.tripleFactory;
    }

    public void setTripleFactory(TripleFactory tripleFactory) {
        this.tripleFactory = tripleFactory;
    }

    @Override
    public BitSet getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(BitSet typeCode) {
        this.typeCode = typeCode;
    }

    public BitSet getTypeFilter() {
        return this.typeFilter;
    }

    public void setTypeFilter(BitSet typeFilter) {
        this.typeFilter = typeFilter;
    }

    public void shed() {
    }

    @Override
    public int compareTo(TraitProxy o) {
        if (HierarchyEncoderImpl.supersetOrEqualset(this.typeCode, o.typeCode)) {
            return -1;
        }
        return 1;
    }
}

