/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.common.InternalFactHandle;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.Context;

public class GetFactHandlesCommand
implements GenericCommand<Collection<FactHandle>> {
    private ObjectFilter filter = null;
    private boolean disconnected = false;

    public GetFactHandlesCommand() {
    }

    public GetFactHandlesCommand(ObjectFilter filter) {
        this.filter = filter;
    }

    public GetFactHandlesCommand(ObjectFilter filter, boolean disconnected) {
        this.filter = filter;
        this.disconnected = disconnected;
    }

    public GetFactHandlesCommand(boolean disconnected) {
        this.disconnected = disconnected;
    }

    @Override
    public Collection<FactHandle> execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        ArrayList<FactHandle> disconnectedFactHandles = new ArrayList<FactHandle>();
        if (this.filter != null) {
            Collection factHandles = ksession.getFactHandles(this.filter);
            if (factHandles != null && this.disconnected) {
                for (InternalFactHandle factHandle : factHandles) {
                    InternalFactHandle handle = factHandle.clone();
                    handle.disconnect();
                    disconnectedFactHandles.add(handle);
                }
                return disconnectedFactHandles;
            }
            return ksession.getFactHandles(this.filter);
        }
        Collection factHandles = ksession.getFactHandles();
        if (factHandles != null && this.disconnected) {
            for (InternalFactHandle factHandle : factHandles) {
                InternalFactHandle handle = factHandle.clone();
                handle.disconnect();
                disconnectedFactHandles.add(handle);
            }
            return disconnectedFactHandles;
        }
        return ksession.getFactHandles();
    }

    public String toString() {
        if (this.filter != null) {
            return "new ObjectStoreWrapper( reteooStatefulSession.getObjectStore(), null, ObjectStoreWrapper.FACT_HANDLE )";
        }
        return "new ObjectStoreWrapper( reteooStatefulSession.getObjectStore(), filter, ObjectStoreWrapper.FACT_HANDLE )";
    }
}

