/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.constraint;

import java.util.Map;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.Declaration;
import org.drools.rule.constraint.ConditionAnalyzer;
import org.drools.rule.constraint.ConditionEvaluator;
import org.drools.rule.constraint.EvaluatorHelper;
import org.drools.rule.constraint.MapConditionEvaluator;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.And;
import org.mvel2.ast.BinaryOperation;
import org.mvel2.ast.BooleanNode;
import org.mvel2.ast.Contains;
import org.mvel2.ast.LineLabel;
import org.mvel2.ast.Negation;
import org.mvel2.ast.Or;
import org.mvel2.ast.Substatement;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableAccessor;
import org.mvel2.compiler.ExecutableLiteral;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ASTLinkedList;

public class MvelConditionEvaluator
implements ConditionEvaluator,
MapConditionEvaluator {
    protected final Declaration[] declarations;
    private final ParserConfiguration parserConfiguration;
    protected ExecutableStatement executableStatement;
    protected MVELCompilationUnit compilationUnit;
    private boolean evaluated = false;

    public MvelConditionEvaluator(ParserConfiguration configuration, String expression, Declaration[] declarations) {
        this.declarations = declarations;
        this.parserConfiguration = configuration;
        this.executableStatement = (ExecutableStatement)MVEL.compileExpression((String)expression, (ParserContext)new ParserContext(this.parserConfiguration));
    }

    public MvelConditionEvaluator(MVELCompilationUnit compilationUnit, ParserConfiguration parserConfiguration, ExecutableStatement executableStatement, Declaration[] declarations) {
        this.declarations = declarations;
        this.compilationUnit = compilationUnit;
        this.parserConfiguration = parserConfiguration;
        this.executableStatement = executableStatement;
    }

    @Override
    public boolean evaluate(Object object, Map<String, Object> vars) {
        return this.evaluate(this.executableStatement, object, vars);
    }

    @Override
    public boolean evaluate(Object object, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        return this.evaluate(this.executableStatement, object, workingMemory, leftTuple);
    }

    public boolean evaluate(ExecutableStatement statement, Object object, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        if (this.compilationUnit == null) {
            Map<String, Object> vars = EvaluatorHelper.valuesAsMap(object, workingMemory, leftTuple, this.declarations);
            return this.evaluate(statement, object, vars);
        }
        VariableResolverFactory factory = this.compilationUnit.createFactory();
        this.compilationUnit.updateFactory(null, null, object, leftTuple, null, workingMemory, workingMemory.getGlobalResolver(), factory);
        return (Boolean)MVEL.executeExpression((Object)statement, (Object)object, (VariableResolverFactory)factory);
    }

    private boolean evaluate(ExecutableStatement statement, Object object, Map<String, Object> vars) {
        return vars == null ? (Boolean)MVEL.executeExpression((Object)statement, (Object)object) : (Boolean)MVEL.executeExpression((Object)statement, (Object)object, vars);
    }

    ConditionAnalyzer.Condition getAnalyzedCondition() {
        return new ConditionAnalyzer(this.executableStatement, this.declarations).analyzeCondition();
    }

    ConditionAnalyzer.Condition getAnalyzedCondition(Object object, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        this.ensureCompleteEvaluation(object, workingMemory, leftTuple);
        return new ConditionAnalyzer(this.executableStatement, this.declarations).analyzeCondition();
    }

    private void ensureCompleteEvaluation(Object object, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        if (!this.evaluated) {
            ASTNode rootNode = this.getRootNode();
            if (rootNode != null) {
                this.ensureCompleteEvaluation(rootNode, object, workingMemory, leftTuple);
            }
            this.evaluated = true;
        }
    }

    private void ensureCompleteEvaluation(ASTNode node, Object object, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        if (!((node = this.unwrap(node)) instanceof And) && !(node instanceof Or)) {
            return;
        }
        this.ensureBranchEvaluation(object, workingMemory, leftTuple, ((BooleanNode)node).getLeft());
        this.ensureBranchEvaluation(object, workingMemory, leftTuple, ((BooleanNode)node).getRight());
    }

    private ASTNode unwrap(ASTNode node) {
        while (node instanceof Negation || node instanceof LineLabel || node instanceof Substatement) {
            node = this.unwrapNegation(node);
            node = this.unwrapSubstatement(node);
        }
        return node;
    }

    private void ensureBranchEvaluation(Object object, InternalWorkingMemory workingMemory, LeftTuple leftTuple, ASTNode node) {
        if (!this.isEvaluated(node)) {
            ASTNode next = node.nextASTNode;
            node.nextASTNode = null;
            this.evaluate((ExecutableStatement)this.asCompiledExpression(node), object, workingMemory, leftTuple);
            node.nextASTNode = next;
        }
        this.ensureCompleteEvaluation(node, object, workingMemory, leftTuple);
    }

    private ASTNode unwrapNegation(ASTNode node) {
        if (node instanceof Negation) {
            ExecutableStatement statement = ((Negation)node).getStatement();
            return statement instanceof ExecutableAccessor ? ((ExecutableAccessor)statement).getNode() : null;
        }
        return node;
    }

    private ASTNode unwrapSubstatement(ASTNode node) {
        if (node instanceof LineLabel) {
            return node.nextASTNode;
        }
        return node instanceof Substatement ? ((ExecutableAccessor)((Substatement)node).getStatement()).getNode() : node;
    }

    private boolean isEvaluated(ASTNode node) {
        if ((node = this.unwrapSubstatement(node)) instanceof Contains) {
            return ((Contains)node).getFirstStatement().getAccessor() != null;
        }
        return node instanceof BinaryOperation ? ((BooleanNode)node).getLeft().getAccessor() != null : node.getAccessor() != null;
    }

    private CompiledExpression asCompiledExpression(ASTNode node) {
        return new CompiledExpression(new ASTLinkedList(node), null, Object.class, this.parserConfiguration, false);
    }

    private ASTNode getRootNode() {
        if (this.executableStatement instanceof ExecutableLiteral) {
            return null;
        }
        return this.executableStatement instanceof CompiledExpression ? ((CompiledExpression)this.executableStatement).getFirstNode() : ((ExecutableAccessor)this.executableStatement).getNode();
    }
}

