/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.base.ClassObjectType;
import org.drools.core.util.ClassUtils;
import org.drools.factmodel.ClassDefinition;
import org.drools.facttemplates.FactTemplate;
import org.drools.facttemplates.FactTemplateObjectType;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.kie.definition.KieDefinition;
import org.kie.definition.KnowledgeDefinition;
import org.kie.io.Resource;

public class TypeDeclaration
implements KnowledgeDefinition,
Externalizable {
    public static final int ROLE_BIT = 1;
    public static final int TYPESAFE_BIT = 2;
    public static final int FORMAT_BIT = 4;
    public static final int KIND_BIT = 8;
    public static final int NATURE_BIT = 16;
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_TYPESAFE = "typesafe";
    public static final String ATTR_DURATION = "duration";
    public static final String ATTR_TIMESTAMP = "timestamp";
    public static final String ATTR_EXPIRE = "expires";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_FIELD_POSITION = "position";
    public static final String ATTR_PROP_CHANGE_SUPPORT = "propertyChangeSupport";
    public static final String ATTR_PROP_SPECIFIC = "propertyReactive";
    public static final String ATTR_NOT_PROP_SPECIFIC = "classReactive";
    public int setMask = 0;
    private String typeName;
    private Role role;
    private Format format;
    private Kind kind;
    private Nature nature;
    private String timestampAttribute;
    private String durationAttribute;
    private InternalReadAccessor durationExtractor;
    private InternalReadAccessor timestampExtractor;
    private transient Class<?> typeClass;
    private String typeClassName;
    private FactTemplate typeTemplate;
    private ClassDefinition typeClassDef;
    private Resource resource;
    private boolean dynamic;
    private boolean typesafe;
    private boolean novel;
    private boolean valid;
    private boolean propertyReactive;
    private transient List<String> settableProprties;
    private transient ObjectType objectType;
    private long expirationOffset = -1L;
    private List<TypeDeclaration> redeclarations;

    public TypeDeclaration() {
        this.role = Role.FACT;
        this.format = Format.POJO;
        this.kind = Kind.CLASS;
        this.nature = Nature.DECLARATION;
        this.valid = true;
        this.addRedeclaration(this);
    }

    public TypeDeclaration(String typeName) {
        this.typeName = typeName;
        this.role = Role.FACT;
        this.format = Format.POJO;
        this.kind = Kind.CLASS;
        this.nature = Nature.DECLARATION;
        this.durationAttribute = null;
        this.timestampAttribute = null;
        this.typeTemplate = null;
        this.typesafe = true;
        this.valid = true;
        this.addRedeclaration(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.typeName = (String)in.readObject();
        this.role = (Role)((Object)in.readObject());
        this.format = (Format)((Object)in.readObject());
        this.kind = (Kind)((Object)in.readObject());
        this.nature = (Nature)((Object)in.readObject());
        this.durationAttribute = (String)in.readObject();
        this.timestampAttribute = (String)in.readObject();
        this.typeClassName = (String)in.readObject();
        this.typeTemplate = (FactTemplate)in.readObject();
        this.typeClassDef = (ClassDefinition)in.readObject();
        this.durationExtractor = (InternalReadAccessor)in.readObject();
        this.timestampExtractor = (InternalReadAccessor)in.readObject();
        this.resource = (Resource)in.readObject();
        this.expirationOffset = in.readLong();
        this.dynamic = in.readBoolean();
        this.typesafe = in.readBoolean();
        this.propertyReactive = in.readBoolean();
        this.valid = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.typeName);
        out.writeObject((Object)this.role);
        out.writeObject((Object)this.format);
        out.writeObject((Object)this.kind);
        out.writeObject((Object)this.nature);
        out.writeObject(this.durationAttribute);
        out.writeObject(this.timestampAttribute);
        out.writeObject(this.typeClassName);
        out.writeObject(this.typeTemplate);
        out.writeObject(this.typeClassDef);
        out.writeObject(this.durationExtractor);
        out.writeObject(this.timestampExtractor);
        out.writeObject(this.resource);
        out.writeLong(this.expirationOffset);
        out.writeBoolean(this.dynamic);
        out.writeBoolean(this.typesafe);
        out.writeBoolean(this.propertyReactive);
        out.writeBoolean(this.valid);
    }

    public int getSetMask() {
        return this.setMask;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.setMask |= 1;
        this.role = role;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.setMask |= 4;
        this.format = format;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.setMask |= 8;
        this.kind = kind;
    }

    public Nature getNature() {
        return this.nature;
    }

    public void setNature(Nature nature) {
        this.setMask |= 0x10;
        this.nature = nature;
    }

    public String getTimestampAttribute() {
        return this.timestampAttribute;
    }

    public void setTimestampAttribute(String timestampAttribute) {
        this.timestampAttribute = timestampAttribute;
    }

    public String getDurationAttribute() {
        return this.durationAttribute;
    }

    public void setDurationAttribute(String durationAttribute) {
        this.durationAttribute = durationAttribute;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(Class<?> typeClass) {
        this.typeClass = typeClass;
        if (this.typeClassDef != null) {
            this.typeClassDef.setDefinedClass(this.typeClass);
        }
        if (this.typeClass != null) {
            this.typeClassName = this.typeClass.getName();
        }
    }

    public FactTemplate getTypeTemplate() {
        return this.typeTemplate;
    }

    public void setTypeTemplate(FactTemplate typeTemplate) {
        this.typeTemplate = typeTemplate;
    }

    public boolean matches(Object clazz) {
        boolean matches = false;
        matches = clazz instanceof FactTemplate ? this.typeTemplate.equals(clazz) : this.typeClass.isAssignableFrom((Class)clazz);
        return matches;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeDeclaration other = (TypeDeclaration)obj;
        return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
    }

    public InternalReadAccessor getDurationExtractor() {
        return this.durationExtractor;
    }

    public void setDurationExtractor(InternalReadAccessor durationExtractor) {
        this.durationExtractor = durationExtractor;
    }

    public ClassDefinition getTypeClassDef() {
        return this.typeClassDef;
    }

    public void setTypeClassDef(ClassDefinition typeClassDef) {
        this.typeClassDef = typeClassDef;
    }

    public InternalReadAccessor getTimestampExtractor() {
        return this.timestampExtractor;
    }

    public void setTimestampExtractor(InternalReadAccessor timestampExtractor) {
        this.timestampExtractor = timestampExtractor;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public ObjectType getObjectType() {
        if (this.objectType == null) {
            this.objectType = this.getFormat() == Format.POJO ? new ClassObjectType(this.getTypeClass()) : new FactTemplateObjectType(this.getTypeTemplate());
        }
        return this.objectType;
    }

    public long getExpirationOffset() {
        return this.expirationOffset;
    }

    public void setExpirationOffset(long expirationOffset) {
        this.expirationOffset = expirationOffset;
    }

    public String getTypeClassName() {
        return this.typeClassName;
    }

    public void setTypeClassName(String typeClassName) {
        this.typeClassName = typeClassName;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isTypesafe() {
        return this.typesafe;
    }

    public void setTypesafe(boolean typesafe) {
        this.setMask |= 2;
        this.typesafe = typesafe;
    }

    public boolean isPropertyReactive() {
        return this.propertyReactive;
    }

    public void setPropertyReactive(boolean propertyReactive) {
        this.propertyReactive = propertyReactive;
    }

    public boolean isNovel() {
        return this.novel;
    }

    public void setNovel(boolean novel) {
        this.novel = novel;
    }

    public List<String> getSettableProperties() {
        if (this.settableProprties == null) {
            this.settableProprties = ClassUtils.getSettableProperties(this.getTypeClass());
        }
        return this.settableProprties;
    }

    public void addRedeclaration(TypeDeclaration typeDeclaration) {
        if (this.redeclarations == null) {
            this.redeclarations = new ArrayList<TypeDeclaration>();
        }
        this.redeclarations.add(typeDeclaration);
    }

    private List<TypeDeclaration> getRedeclarations() {
        return Collections.unmodifiableList(this.redeclarations);
    }

    public boolean removeRedeclaration(TypeDeclaration decl) {
        if (!this.redeclarations.contains(decl)) {
            return false;
        }
        this.redeclarations.remove(decl);
        return true;
    }

    public String toString() {
        return "TypeDeclaration{typeName='" + this.typeName + '\'' + ", role=" + (Object)((Object)this.role) + ", format=" + (Object)((Object)this.format) + ", kind=" + (Object)((Object)this.kind) + ", nature=" + (Object)((Object)this.nature) + '}';
    }

    public KieDefinition.KnowledgeType getKnowledgeType() {
        return KieDefinition.KnowledgeType.TYPE;
    }

    public String getNamespace() {
        return this.typeClass != null ? this.typeClass.getPackage().getName() : "";
    }

    public String getId() {
        return this.getTypeName();
    }

    public class TimestampAccessorSetter
    implements AcceptsReadAccessor,
    Serializable {
        private static final long serialVersionUID = 510L;

        @Override
        public void setReadAccessor(InternalReadAccessor readAccessor) {
            TypeDeclaration.this.setTimestampExtractor(readAccessor);
        }
    }

    public class DurationAccessorSetter
    implements AcceptsReadAccessor,
    Serializable {
        private static final long serialVersionUID = 510L;

        @Override
        public void setReadAccessor(InternalReadAccessor readAccessor) {
            TypeDeclaration.this.setDurationExtractor(readAccessor);
        }
    }

    public static enum Nature {
        DECLARATION,
        DEFINITION;

        public static final String ID = "nature";

        public static Nature parseNature(String nature) {
            if ("declaration".equalsIgnoreCase(nature)) {
                return DECLARATION;
            }
            if ("definition".equalsIgnoreCase(nature)) {
                return DEFINITION;
            }
            return null;
        }
    }

    public static enum Format {
        POJO,
        TEMPLATE;

        public static final String ID = "format";

        public static Format parseFormat(String format) {
            if ("pojo".equalsIgnoreCase(format)) {
                return POJO;
            }
            if ("template".equalsIgnoreCase(format)) {
                return TEMPLATE;
            }
            return null;
        }
    }

    public static enum Role {
        FACT,
        EVENT;

        public static final String ID = "role";

        public static Role parseRole(String role) {
            if ("event".equalsIgnoreCase(role)) {
                return EVENT;
            }
            if ("fact".equalsIgnoreCase(role)) {
                return FACT;
            }
            return null;
        }
    }

    public static enum Kind {
        CLASS,
        TRAIT,
        ENUM;

        public static final String ID = "kind";

        public static Kind parseKind(String kind) {
            if (TypeDeclaration.ATTR_CLASS.equalsIgnoreCase(kind)) {
                return CLASS;
            }
            if ("trait".equalsIgnoreCase(kind)) {
                return TRAIT;
            }
            if ("enum".equalsIgnoreCase(kind)) {
                return ENUM;
            }
            return null;
        }
    }
}

