/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.drools.base.ClassObjectType;
import org.drools.base.extractors.ArrayElementReader;
import org.drools.base.extractors.SelfReferenceClassFieldReader;
import org.drools.core.util.ArrayUtils;
import org.drools.rule.Accumulate;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.From;
import org.drools.rule.GroupElement;
import org.drools.rule.GroupElementFactory;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Pattern;
import org.drools.rule.QueryElement;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.constraint.MvelConstraint;
import org.drools.spi.Constraint;
import org.drools.spi.DataProvider;
import org.drools.spi.DeclarationScopeResolver;

public class LogicTransformer {
    private final Map orTransformations = new HashMap();
    private static LogicTransformer INSTANCE = new LogicTransformer();

    public static LogicTransformer getInstance() {
        return INSTANCE;
    }

    protected LogicTransformer() {
        this.initialize();
    }

    private void initialize() {
        this.addTransformationPair(GroupElement.NOT, new NotOrTransformation());
        this.addTransformationPair(GroupElement.EXISTS, new ExistOrTransformation());
        this.addTransformationPair(GroupElement.AND, new AndOrTransformation());
    }

    private void addTransformationPair(GroupElement.Type parent, Transformation method) {
        this.orTransformations.put(parent, method);
    }

    public GroupElement[] transform(GroupElement cloned) throws InvalidPatternException {
        GroupElement[] ands;
        this.processTree(cloned);
        cloned.pack();
        if (cloned.isAnd()) {
            ands = new GroupElement[]{cloned};
        } else if (cloned.isOr()) {
            ands = this.splitOr(cloned);
        } else {
            GroupElement wrapper = GroupElementFactory.newAndInstance();
            wrapper.addChild(cloned);
            ands = new GroupElement[]{wrapper};
        }
        for (int i = 0; i < ands.length; ++i) {
            this.fixClonedDeclarations(ands[i]);
            ands[i].setRoot(true);
        }
        return ands;
    }

    protected GroupElement[] splitOr(GroupElement cloned) {
        GroupElement[] ands = new GroupElement[cloned.getChildren().size()];
        int i = 0;
        for (RuleConditionElement branch : cloned.getChildren()) {
            if (branch instanceof GroupElement && ((GroupElement)branch).isAnd()) {
                ands[i++] = (GroupElement)branch;
                continue;
            }
            ands[i] = GroupElementFactory.newAndInstance();
            ands[i].addChild(branch);
            ++i;
        }
        return ands;
    }

    protected void fixClonedDeclarations(GroupElement and) {
        Stack<RuleConditionElement> contextStack = new Stack<RuleConditionElement>();
        DeclarationScopeResolver resolver = new DeclarationScopeResolver(Collections.<String, Class<?>>emptyMap(), contextStack);
        contextStack.push(and);
        this.processElement(resolver, contextStack, and);
        contextStack.pop();
    }

    private void processElement(DeclarationScopeResolver resolver, Stack contextStack, RuleConditionElement element) {
        if (element instanceof Pattern) {
            Pattern pattern = (Pattern)element;
            Iterator it = pattern.getNestedElements().iterator();
            while (it.hasNext()) {
                this.processElement(resolver, contextStack, (RuleConditionElement)it.next());
            }
            for (Constraint next : pattern.getConstraints()) {
                if (next instanceof Declaration) continue;
                Constraint constraint = next;
                Declaration[] decl = constraint.getRequiredDeclarations();
                for (int i = 0; i < decl.length; ++i) {
                    Pattern old;
                    Pattern current;
                    Declaration resolved = resolver.getDeclaration(null, decl[i].getIdentifier());
                    if (constraint instanceof MvelConstraint && ((MvelConstraint)constraint).isUnification()) {
                        if (ClassObjectType.DroolsQuery_ObjectType.isAssignableFrom(resolved.getPattern().getObjectType())) {
                            Declaration redeclaredDeclr = new Declaration(resolved.getIdentifier(), ((MvelConstraint)constraint).getFieldExtractor(), pattern, false);
                            pattern.addDeclaration(redeclaredDeclr);
                        } else if (resolved.getPattern() != pattern) {
                            ((MvelConstraint)constraint).unsetUnification();
                        }
                    }
                    if (resolved != null && resolved != decl[i] && resolved.getPattern() != pattern) {
                        constraint.replaceDeclaration(decl[i], resolved);
                        continue;
                    }
                    if (resolved != null || (current = resolver.findPatternByIndex((old = decl[i].getPattern()).getIndex())) == null || old == current) continue;
                    resolved = new Declaration(decl[i].getIdentifier(), decl[i].getExtractor(), current);
                    constraint.replaceDeclaration(decl[i], resolved);
                }
            }
        } else if (element instanceof EvalCondition) {
            Declaration[] decl;
            for (Declaration aDecl : decl = ((EvalCondition)element).getRequiredDeclarations()) {
                Declaration resolved = resolver.getDeclaration(null, aDecl.getIdentifier());
                if (resolved == null || resolved == aDecl) continue;
                ((EvalCondition)element).replaceDeclaration(aDecl, resolved);
            }
        } else if (element instanceof Accumulate) {
            for (RuleConditionElement rce : element.getNestedElements()) {
                this.processElement(resolver, contextStack, rce);
            }
            ((Accumulate)element).resetInnerDeclarationCache();
        } else if (element instanceof From) {
            Declaration[] decl;
            DataProvider provider = ((From)element).getDataProvider();
            for (Declaration aDecl : decl = provider.getRequiredDeclarations()) {
                Pattern old;
                Pattern current;
                Declaration resolved = resolver.getDeclaration(null, aDecl.getIdentifier());
                if (resolved != null && resolved != aDecl) {
                    provider.replaceDeclaration(aDecl, resolved);
                    continue;
                }
                if (resolved != null || (current = resolver.findPatternByIndex((old = aDecl.getPattern()).getIndex())) == null || old == current) continue;
                resolved = new Declaration(aDecl.getIdentifier(), aDecl.getExtractor(), current);
                provider.replaceDeclaration(aDecl, resolved);
            }
        } else if (element instanceof QueryElement) {
            QueryElement qe = (QueryElement)element;
            Pattern pattern = qe.getResultPattern();
            for (Map.Entry<String, Declaration> entry : pattern.getInnerDeclarations().entrySet()) {
                Declaration resolved = resolver.getDeclaration(null, entry.getValue().getIdentifier());
                if (resolved == null || resolved == entry.getValue() || resolved.getPattern() == pattern) continue;
                entry.setValue(resolved);
            }
            List<Integer> varIndexes = ArrayUtils.asList(qe.getVariableIndexes());
            for (int i = 0; i < qe.getDeclIndexes().length; ++i) {
                Declaration declr = (Declaration)qe.getArgTemplate()[qe.getDeclIndexes()[i]];
                Declaration resolved = resolver.getDeclaration(null, declr.getIdentifier());
                if (resolved != null && resolved != declr && resolved.getPattern() != pattern) {
                    qe.getArgTemplate()[qe.getDeclIndexes()[i]] = resolved;
                }
                if (!ClassObjectType.DroolsQuery_ObjectType.isAssignableFrom(resolved.getPattern().getObjectType())) continue;
                declr = pattern.addDeclaration(declr.getIdentifier());
                ArrayElementReader reader = new ArrayElementReader(new SelfReferenceClassFieldReader(Object[].class, "this"), qe.getDeclIndexes()[i], resolved.getExtractor().getExtractToClass());
                declr.setReadAccessor(reader);
                varIndexes.add(qe.getDeclIndexes()[i]);
            }
            qe.setVariableIndexes(ArrayUtils.toIntArray(varIndexes));
        } else {
            contextStack.push(element);
            for (RuleConditionElement ruleConditionElement : element.getNestedElements()) {
                this.processElement(resolver, contextStack, ruleConditionElement);
            }
            contextStack.pop();
        }
    }

    protected void processTree(GroupElement ce) throws InvalidPatternException {
        Object[] children;
        boolean hasChildOr = false;
        ce.pack();
        for (Object aChildren : children = ce.getChildren().toArray()) {
            if (!(aChildren instanceof GroupElement)) continue;
            GroupElement child = (GroupElement)aChildren;
            this.processTree(child);
            if ((child.isOr() || child.isAnd()) && child.getType() == ce.getType()) {
                child.pack(ce);
                continue;
            }
            if (!child.isOr()) continue;
            hasChildOr = true;
        }
        if (hasChildOr) {
            this.applyOrTransformation(ce);
        }
    }

    void applyOrTransformation(GroupElement parent) throws InvalidPatternException {
        Transformation transformation = (Transformation)this.orTransformations.get((Object)parent.getType());
        if (transformation == null) {
            throw new RuntimeException("applyOrTransformation could not find transformation for parent '" + (Object)((Object)parent.getType()) + "' and child 'OR'");
        }
        transformation.transform(parent);
    }

    public class NotOrTransformation
    implements Transformation {
        @Override
        public void transform(GroupElement parent) throws InvalidPatternException {
            if (!(parent.getChildren().get(0) instanceof GroupElement) || !((GroupElement)parent.getChildren().get(0)).isOr()) {
                throw new RuntimeException("NotOrTransformation expected 'OR' but instead found '" + parent.getChildren().get(0).getClass().getName() + "'");
            }
            GroupElement or = (GroupElement)parent.getChildren().get(0);
            parent.setType(GroupElement.AND);
            parent.getChildren().clear();
            for (RuleConditionElement ruleConditionElement : or.getChildren()) {
                GroupElement newNot = GroupElementFactory.newNotInstance();
                newNot.addChild(ruleConditionElement);
                parent.addChild(newNot);
            }
            parent.pack();
        }
    }

    class ExistOrTransformation
    implements Transformation {
        ExistOrTransformation() {
        }

        @Override
        public void transform(GroupElement parent) throws InvalidPatternException {
            if (!(parent.getChildren().get(0) instanceof GroupElement) || !((GroupElement)parent.getChildren().get(0)).isOr()) {
                throw new RuntimeException("ExistOrTransformation expected 'OR' but instead found '" + parent.getChildren().get(0).getClass().getName() + "'");
            }
            GroupElement or = (GroupElement)parent.getChildren().get(0);
            parent.setType(GroupElement.OR);
            parent.getChildren().clear();
            for (RuleConditionElement ruleConditionElement : or.getChildren()) {
                GroupElement newExists = GroupElementFactory.newExistsInstance();
                newExists.addChild(ruleConditionElement);
                parent.addChild(newExists);
            }
            parent.pack();
        }
    }

    class AndOrTransformation
    implements Transformation {
        AndOrTransformation() {
        }

        @Override
        public void transform(GroupElement parent) throws InvalidPatternException {
            ArrayList<RuleConditionElement> orsList = new ArrayList<RuleConditionElement>();
            Object[] others = new Object[parent.getChildren().size()];
            int permutations = 1;
            int index = 0;
            for (RuleConditionElement child : parent.getChildren()) {
                if (child instanceof GroupElement && ((GroupElement)child).isOr()) {
                    permutations *= ((GroupElement)child).getChildren().size();
                    orsList.add(child);
                } else {
                    others[index] = child;
                }
                ++index;
            }
            parent.setType(GroupElement.OR);
            parent.getChildren().clear();
            GroupElement[] ors = orsList.toArray(new GroupElement[orsList.size()]);
            int[] indexes = new int[ors.length];
            for (int i = 1; i <= permutations; ++i) {
                int j;
                GroupElement and = GroupElementFactory.newAndInstance();
                int mod = 1;
                for (j = ors.length - 1; j >= 0; --j) {
                    and.getChildren().add(0, ors[j].getChildren().get(indexes[j]).clone());
                    if (i % mod == 0) {
                        indexes[j] = (indexes[j] + 1) % ors[j].getChildren().size();
                    }
                    mod *= ors[j].getChildren().size();
                }
                for (j = 0; j < others.length; ++j) {
                    if (others[j] == null) continue;
                    and.getChildren().add(j, ((RuleConditionElement)others[j]).clone());
                }
                parent.addChild(and);
            }
            parent.pack();
        }
    }

    static interface Transformation {
        public void transform(GroupElement var1) throws InvalidPatternException;
    }
}

