/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.compiled;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.drools.base.ClassFieldReader;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.Sink;
import org.drools.reteoo.compiled.AbstractCompilerHandler;
import org.drools.reteoo.compiled.HashedAlphasDeclaration;
import org.drools.rule.ContextEntry;

class DeclarationsHandler
extends AbstractCompilerHandler {
    private static final String PRIVATE_MODIFIER = "private";
    private HashedAlphasDeclaration currentHashedAlpha;
    private final StringBuilder builder;
    private final Collection<HashedAlphasDeclaration> hashedAlphaDeclarations;

    DeclarationsHandler(StringBuilder builder) {
        this.builder = builder;
        this.hashedAlphaDeclarations = new LinkedList<HashedAlphasDeclaration>();
    }

    private String getVariableDeclaration(AlphaNode alphaNode) {
        Class<?> variableType = this.getVariableType(alphaNode);
        String variableName = this.getVariableName(alphaNode);
        String comment = alphaNode.toString();
        return "private " + variableType.getName() + " " + variableName + "; // " + comment;
    }

    private String getContextVariableDeclaration(AlphaNode alphaNode) {
        Class<ContextEntry> variableType = ContextEntry.class;
        String variableName = this.getContextVariableName(alphaNode);
        return "private " + variableType.getName() + " " + variableName + ";";
    }

    private String getVariableDeclaration(Sink sink) {
        Class<?> declarationType = this.getVariableType(sink);
        String variableName = this.getVariableName(sink);
        String comment = sink.toString();
        return "private " + declarationType.getName() + " " + variableName + "; // " + comment;
    }

    private String getVariableDeclaration(ClassFieldReader fieldReader) {
        Class<Map> declarationType = Map.class;
        Class<HashMap> createType = HashMap.class;
        String variableName = this.getVariableName(fieldReader);
        return "private " + declarationType.getName() + " " + variableName + " = new " + createType.getName() + "();";
    }

    Collection<HashedAlphasDeclaration> getHashedAlphaDeclarations() {
        return Collections.unmodifiableCollection(this.hashedAlphaDeclarations);
    }

    @Override
    public void startNonHashedAlphaNode(AlphaNode alphaNode) {
        this.builder.append(this.getVariableDeclaration(alphaNode)).append("\n");
        this.builder.append(this.getContextVariableDeclaration(alphaNode)).append("\n");
    }

    @Override
    public void startBetaNode(BetaNode betaNode) {
        this.builder.append(this.getVariableDeclaration(betaNode)).append("\n");
    }

    @Override
    public void startLeftInputAdapterNode(LeftInputAdapterNode leftInputAdapterNode) {
        this.builder.append(this.getVariableDeclaration(leftInputAdapterNode)).append("\n");
    }

    @Override
    public void startHashedAlphaNodes(ClassFieldReader hashedFieldReader) {
        this.currentHashedAlpha = new HashedAlphasDeclaration(this.getVariableName(hashedFieldReader), hashedFieldReader.getValueType());
        this.hashedAlphaDeclarations.add(this.currentHashedAlpha);
        this.builder.append(this.getVariableDeclaration(hashedFieldReader)).append("\n");
    }

    @Override
    public void startHashedAlphaNode(AlphaNode hashedAlpha, Object hashedValue) {
        this.currentHashedAlpha.add(hashedValue, String.valueOf(hashedAlpha.getId()));
    }
}

