/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.io.Externalizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.core.util.StringUtils;
import org.drools.io.impl.BaseResource;
import org.drools.io.impl.FileSystemResource;
import org.drools.io.internal.InternalResource;
import org.kie.internal.utils.ClassLoaderUtil;
import org.kie.io.Resource;
import org.kie.io.ResourceType;

public class ClassPathResource
extends BaseResource
implements InternalResource,
Externalizable {
    private String path;
    private String encoding;
    private ClassLoader classLoader;
    private Class<?> clazz;
    private long lastRead;

    public ClassPathResource() {
    }

    public ClassPathResource(String path) {
        this(path, null, null, null);
    }

    public ClassPathResource(String path, Class<?> clazz) {
        this(path, null, clazz, null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        this(path, null, null, classLoader);
    }

    public ClassPathResource(String path, String encoding) {
        this(path, encoding, null, null);
    }

    public ClassPathResource(String path, String encoding, Class<?> clazz) {
        this(path, encoding, clazz, null);
    }

    public ClassPathResource(String path, String encoding, ClassLoader classLoader) {
        this(path, encoding, null, classLoader);
    }

    public ClassPathResource(String path, String encoding, Class<?> clazz, ClassLoader classLoader) {
        ClassLoader[] classLoaderArray;
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        this.path = path;
        this.encoding = encoding;
        this.clazz = clazz;
        if (classLoader == null) {
            classLoaderArray = null;
        } else {
            ClassLoader[] classLoaderArray2 = new ClassLoader[1];
            classLoaderArray = classLoaderArray2;
            classLoaderArray2[0] = classLoader;
        }
        this.classLoader = ClassLoaderUtil.getClassLoader((ClassLoader[])classLoaderArray, clazz, (boolean)false);
        this.setSourcePath(path);
        this.setResourceType(ResourceType.determineResourceType((String)path));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.path);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.path = (String)in.readObject();
    }

    public InputStream getInputStream() throws IOException {
        this.lastRead = this.getLastModified();
        return this.getURL().openStream();
    }

    @Override
    public URL getURL() throws IOException {
        URL url = null;
        if (this.clazz != null) {
            url = this.clazz.getResource(this.path);
        }
        if (url == null) {
            url = this.classLoader.getResource(this.path);
        }
        if (url == null) {
            throw new FileNotFoundException("'" + this.path + "' cannot be opened because it does not exist");
        }
        return url;
    }

    @Override
    public boolean hasURL() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getLastModified() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 33[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long getLastRead() {
        return this.lastRead;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.getInputStream());
    }

    @Override
    public boolean isDirectory() {
        try {
            URL url = this.getURL();
            if (!"file".equals(url.getProtocol())) {
                return false;
            }
            File file = new File(StringUtils.toURI(url.toString()).getSchemeSpecificPart());
            return file.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Collection<Resource> listResources() {
        try {
            URL url = this.getURL();
            if ("file".equals(url.getProtocol())) {
                File dir = new File(StringUtils.toURI(url.toString()).getSchemeSpecificPart());
                ArrayList<Resource> resources = new ArrayList<Resource>();
                for (File file : dir.listFiles()) {
                    resources.add(new FileSystemResource(file));
                }
                return resources;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException("This Resource cannot be listed, or is not a directory");
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getPath() {
        return this.path;
    }

    protected void setLastRead(long lastRead) {
        this.lastRead = lastRead;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ClassPathResource)) {
            return false;
        }
        ClassPathResource other = (ClassPathResource)object;
        return this.path.equals(other.path) && this.clazz == other.clazz && this.classLoader == other.classLoader;
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String toString() {
        return "[ClassPathResource path='" + this.path + "']";
    }
}

