/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractEventSupport<E extends EventListener>
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private List<E> listeners = new CopyOnWriteArrayList();

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.listeners = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.listeners);
    }

    protected final Iterator<E> getEventListenersIterator() {
        return this.listeners.iterator();
    }

    public final synchronized void addEventListener(E listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final synchronized void removeEventListener(Class cls) {
        int listenerIndex = 0;
        while (listenerIndex < this.listeners.size()) {
            EventListener listener = (EventListener)this.listeners.get(listenerIndex);
            if (cls.isAssignableFrom(listener.getClass())) {
                this.listeners.remove(listenerIndex);
                continue;
            }
            ++listenerIndex;
        }
    }

    public final void removeEventListener(E listener) {
        this.listeners.remove(listener);
    }

    public List<E> getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public final int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void clear() {
        this.listeners.clear();
    }
}

