/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.FactException;
import org.drools.beliefsystem.BeliefSet;
import org.drools.common.InternalFactHandle;
import org.drools.common.LogicalDependency;
import org.drools.core.util.LinkedList;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;

public class TruthMaintenanceSystemHelper {
    public static void removeLogicalDependencies(InternalFactHandle handle, PropagationContext propagationContext) throws FactException {
        BeliefSet beliefSet = handle.getEqualityKey().getBeliefSet();
        if (beliefSet != null && !beliefSet.isEmpty()) {
            beliefSet.cancel(propagationContext);
        }
    }

    public static void clearLogicalDependencies(InternalFactHandle handle, PropagationContext propagationContext) throws FactException {
        BeliefSet beliefSet = handle.getEqualityKey().getBeliefSet();
        if (beliefSet != null && !beliefSet.isEmpty()) {
            beliefSet.clear(propagationContext);
        }
    }

    public static void removeLogicalDependencies(Activation activation, PropagationContext context, Rule rule) throws FactException {
        LinkedList<LogicalDependency> list = activation.getLogicalDependencies();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (LogicalDependency node = list.getFirst(); node != null; node = (LogicalDependency)node.getNext()) {
            TruthMaintenanceSystemHelper.removeLogicalDependency(node, context);
        }
        activation.setLogicalDependencies(null);
    }

    public static void removeLogicalDependency(LogicalDependency node, PropagationContext context) {
        BeliefSet beliefSet = (BeliefSet)node.getJustified();
        beliefSet.getBeliefSystem().delete(node, beliefSet, context);
    }
}

