/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.common.AgendaItem;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalRuleBase;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;

public class ArrayAgendaGroup
implements InternalAgendaGroup {
    private static final long serialVersionUID = 510L;
    private String name;
    private LinkedList[] array;
    private boolean active;
    private int size;
    private int index;
    private int lastIndex;
    private PropagationContext autoFocusActivator;
    private long activatedForRecency;
    private long clearedForRecency;

    public ArrayAgendaGroup() {
        this.clearedForRecency = -1L;
    }

    public ArrayAgendaGroup(String name, InternalRuleBase ruleBase) {
        this.name = name;
        Integer integer = ruleBase.getAgendaGroupRuleTotals().get(name);
        this.array = integer == null ? new LinkedList[0] : new LinkedList[integer.intValue()];
        this.index = this.array.length - 1;
        this.lastIndex = 0;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void clear() {
        this.lastIndex = 0;
        this.array = new LinkedList[this.array.length];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Activation[] getAndClear() {
        Activation[] queue = this.getActivations();
        this.clear();
        return queue;
    }

    @Override
    public void add(Activation activation) {
        LinkedList<LinkedListEntry<Activation>> list;
        AgendaItem item = (AgendaItem)activation;
        ++this.size;
        int seq = item.getSequenence();
        if (seq < this.index) {
            this.index = seq;
        }
        if (seq > this.lastIndex) {
            this.lastIndex = seq;
        }
        if ((list = this.array[seq]) == null) {
            this.array[item.getSequenence()] = list = new LinkedList<LinkedListEntry<Activation>>();
        }
        list.add(new LinkedListEntry<Activation>(activation));
    }

    @Override
    public Activation getNext() {
        Activation activation = null;
        while (this.index <= this.lastIndex) {
            LinkedList list = this.array[this.index];
            if (list != null) {
                activation = (Activation)((LinkedListEntry)list.removeFirst()).getObject();
                if (list.isEmpty()) {
                    this.array[this.index++] = null;
                }
                --this.size;
                break;
            }
            ++this.index;
        }
        return activation;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean activate) {
        this.active = activate;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Activation[] getActivations() {
        Activation[] activations = new Activation[this.size];
        int j = 0;
        for (LinkedList list : this.array) {
            if (list == null) continue;
            FastIterator it = list.fastIterator();
            LinkedListEntry entry = (LinkedListEntry)list.getFirst();
            while (entry != null) {
                if (entry.getObject() != null) {
                    activations[j++] = (Activation)entry.getObject();
                }
                entry = (LinkedListEntry)it.next(entry);
            }
        }
        return activations;
    }

    public String toString() {
        return "AgendaGroup '" + this.name + "'";
    }

    public boolean equals(Object object) {
        if (!(object instanceof ArrayAgendaGroup)) {
            return false;
        }
        return ((ArrayAgendaGroup)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setFocus() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(AgendaItem agendaItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAutoFocusActivator(PropagationContext ctx) {
        this.autoFocusActivator = ctx;
    }

    @Override
    public PropagationContext getAutoFocusActivator() {
        return this.autoFocusActivator;
    }

    @Override
    public void setActivatedForRecency(long recency) {
        this.activatedForRecency = recency;
    }

    @Override
    public long getActivatedForRecency() {
        return this.activatedForRecency;
    }

    @Override
    public void setClearedForRecency(long recency) {
        this.clearedForRecency = recency;
    }

    @Override
    public long getClearedForRecency() {
        return this.clearedForRecency;
    }
}

