/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.drools.command.CommandService;
import org.drools.command.GetSessionClockCommand;
import org.drools.command.Interceptor;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.command.runtime.AddEventListenerCommand;
import org.drools.command.runtime.DisposeCommand;
import org.drools.command.runtime.GetCalendarsCommand;
import org.drools.command.runtime.GetChannelsCommand;
import org.drools.command.runtime.GetEnvironmentCommand;
import org.drools.command.runtime.GetGlobalCommand;
import org.drools.command.runtime.GetGlobalsCommand;
import org.drools.command.runtime.GetIdCommand;
import org.drools.command.runtime.GetKnowledgeBaseCommand;
import org.drools.command.runtime.RegisterChannelCommand;
import org.drools.command.runtime.RemoveEventListenerCommand;
import org.drools.command.runtime.SetGlobalCommand;
import org.drools.command.runtime.UnregisterChannelCommand;
import org.drools.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.command.runtime.process.AbortWorkItemCommand;
import org.drools.command.runtime.process.CompleteWorkItemCommand;
import org.drools.command.runtime.process.CreateCorrelatedProcessInstanceCommand;
import org.drools.command.runtime.process.CreateProcessInstanceCommand;
import org.drools.command.runtime.process.GetProcessEventListenersCommand;
import org.drools.command.runtime.process.GetProcessInstanceByCorrelationKeyCommand;
import org.drools.command.runtime.process.GetProcessInstanceCommand;
import org.drools.command.runtime.process.GetProcessInstancesCommand;
import org.drools.command.runtime.process.GetWorkItemCommand;
import org.drools.command.runtime.process.RegisterWorkItemHandlerCommand;
import org.drools.command.runtime.process.SignalEventCommand;
import org.drools.command.runtime.process.StartCorrelatedProcessCommand;
import org.drools.command.runtime.process.StartProcessCommand;
import org.drools.command.runtime.process.StartProcessInstanceCommand;
import org.drools.command.runtime.rule.AgendaGroupSetFocusCommand;
import org.drools.command.runtime.rule.ClearActivationGroupCommand;
import org.drools.command.runtime.rule.ClearAgendaCommand;
import org.drools.command.runtime.rule.ClearAgendaGroupCommand;
import org.drools.command.runtime.rule.ClearRuleFlowGroupCommand;
import org.drools.command.runtime.rule.DeleteCommand;
import org.drools.command.runtime.rule.FireAllRulesCommand;
import org.drools.command.runtime.rule.FireUntilHaltCommand;
import org.drools.command.runtime.rule.GetAgendaEventListenersCommand;
import org.drools.command.runtime.rule.GetEntryPointCommand;
import org.drools.command.runtime.rule.GetEntryPointsCommand;
import org.drools.command.runtime.rule.GetFactHandleCommand;
import org.drools.command.runtime.rule.GetFactHandlesCommand;
import org.drools.command.runtime.rule.GetObjectCommand;
import org.drools.command.runtime.rule.GetObjectsCommand;
import org.drools.command.runtime.rule.GetWorkingMemoryEventListenersCommand;
import org.drools.command.runtime.rule.HaltCommand;
import org.drools.command.runtime.rule.InsertObjectCommand;
import org.drools.command.runtime.rule.QueryCommand;
import org.drools.command.runtime.rule.UpdateCommand;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.WorkItemManager;
import org.drools.rule.EntryPoint;
import org.kie.KnowledgeBase;
import org.kie.command.Command;
import org.kie.event.process.ProcessEventListener;
import org.kie.event.rule.AgendaEventListener;
import org.kie.event.rule.WorkingMemoryEventListener;
import org.kie.process.CorrelationAwareProcessRuntime;
import org.kie.process.CorrelationKey;
import org.kie.runtime.Calendars;
import org.kie.runtime.Channel;
import org.kie.runtime.Environment;
import org.kie.runtime.Globals;
import org.kie.runtime.KieSessionConfiguration;
import org.kie.runtime.ObjectFilter;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.ProcessInstance;
import org.kie.runtime.process.WorkItemHandler;
import org.kie.runtime.rule.ActivationGroup;
import org.kie.runtime.rule.Agenda;
import org.kie.runtime.rule.AgendaFilter;
import org.kie.runtime.rule.AgendaGroup;
import org.kie.runtime.rule.FactHandle;
import org.kie.runtime.rule.LiveQuery;
import org.kie.runtime.rule.QueryResults;
import org.kie.runtime.rule.RuleFlowGroup;
import org.kie.runtime.rule.SessionEntryPoint;
import org.kie.runtime.rule.ViewChangedEventListener;
import org.kie.time.SessionClock;

public class CommandBasedStatefulKnowledgeSession
implements StatefulKnowledgeSession,
CorrelationAwareProcessRuntime {
    private CommandService commandService;
    private transient WorkItemManager workItemManager;
    private transient Agenda agenda;

    public CommandBasedStatefulKnowledgeSession(CommandService commandService) {
        this.commandService = commandService;
    }

    public int getId() {
        return (Integer)this.commandService.execute(new GetIdCommand());
    }

    public ProcessInstance getProcessInstance(long id) {
        GetProcessInstanceCommand command = new GetProcessInstanceCommand();
        command.setProcessInstanceId(id);
        return (ProcessInstance)this.commandService.execute(command);
    }

    public ProcessInstance getProcessInstance(long id, boolean readOnly) {
        GetProcessInstanceCommand command = new GetProcessInstanceCommand();
        command.setProcessInstanceId(id);
        command.setReadOnly(readOnly);
        return (ProcessInstance)this.commandService.execute(command);
    }

    public void abortProcessInstance(long id) {
        AbortProcessInstanceCommand command = new AbortProcessInstanceCommand();
        command.setProcessInstanceId(id);
        this.commandService.execute(command);
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    public Collection<ProcessInstance> getProcessInstances() {
        return (Collection)this.commandService.execute(new GetProcessInstancesCommand());
    }

    public WorkItemManager getWorkItemManager() {
        if (this.workItemManager == null) {
            this.workItemManager = new WorkItemManager(){

                public void completeWorkItem(long id, Map<String, Object> results) {
                    CompleteWorkItemCommand command = new CompleteWorkItemCommand();
                    command.setWorkItemId(id);
                    command.setResults(results);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                public void abortWorkItem(long id) {
                    AbortWorkItemCommand command = new AbortWorkItemCommand();
                    command.setWorkItemId(id);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
                    RegisterWorkItemHandlerCommand command = new RegisterWorkItemHandlerCommand();
                    command.setWorkItemName(workItemName);
                    command.setHandler(handler);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public WorkItem getWorkItem(long id) {
                    GetWorkItemCommand command = new GetWorkItemCommand();
                    command.setWorkItemId(id);
                    return (WorkItem)CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Set<WorkItem> getWorkItems() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void internalAbortWorkItem(long id) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void internalAddWorkItem(WorkItem workItem) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void internalExecuteWorkItem(WorkItem workItem) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.workItemManager;
    }

    public void signalEvent(String type, Object event) {
        SignalEventCommand command = new SignalEventCommand(type, event);
        this.commandService.execute(command);
    }

    public void signalEvent(String type, Object event, long processInstanceId) {
        SignalEventCommand command = new SignalEventCommand(processInstanceId, type, event);
        this.commandService.execute(command);
    }

    public ProcessInstance startProcess(String processId) {
        return this.startProcess(processId, null);
    }

    public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        StartProcessCommand command = new StartProcessCommand();
        command.setProcessId(processId);
        command.setParameters(parameters);
        return (ProcessInstance)this.commandService.execute(command);
    }

    public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        CreateProcessInstanceCommand command = new CreateProcessInstanceCommand();
        command.setProcessId(processId);
        command.setParameters(parameters);
        return (ProcessInstance)this.commandService.execute(command);
    }

    public ProcessInstance startProcessInstance(long processInstanceId) {
        StartProcessInstanceCommand command = new StartProcessInstanceCommand();
        command.setProcessInstanceId(processInstanceId);
        return (ProcessInstance)this.commandService.execute(command);
    }

    public void dispose() {
        this.commandService.execute(new DisposeCommand());
    }

    public int fireAllRules() {
        return (Integer)this.commandService.execute(new FireAllRulesCommand());
    }

    public int fireAllRules(int max) {
        return (Integer)this.commandService.execute(new FireAllRulesCommand(max));
    }

    public int fireAllRules(AgendaFilter agendaFilter) {
        return (Integer)this.commandService.execute(new FireAllRulesCommand(agendaFilter));
    }

    public int fireAllRules(AgendaFilter agendaFilter, int max) {
        return (Integer)this.commandService.execute(new FireAllRulesCommand(agendaFilter, max));
    }

    public void fireUntilHalt() {
        this.commandService.execute(new FireUntilHaltCommand());
    }

    public void fireUntilHalt(AgendaFilter agendaFilter) {
        this.commandService.execute(new FireUntilHaltCommand(agendaFilter));
    }

    public KnowledgeBase getKieBase() {
        return (KnowledgeBase)this.commandService.execute(new GetKnowledgeBaseCommand());
    }

    public void registerChannel(String name, Channel channel) {
        this.commandService.execute(new RegisterChannelCommand(name, channel));
    }

    public void unregisterChannel(String name) {
        this.commandService.execute(new UnregisterChannelCommand(name));
    }

    public Map<String, Channel> getChannels() {
        return (Map)this.commandService.execute(new GetChannelsCommand());
    }

    public Agenda getAgenda() {
        if (this.agenda == null) {
            this.agenda = new Agenda(){

                public void clear() {
                    ClearAgendaCommand command = new ClearAgendaCommand();
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                public ActivationGroup getActivationGroup(final String name) {
                    return new ActivationGroup(){

                        public void clear() {
                            ClearActivationGroupCommand command = new ClearActivationGroupCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }

                        public String getName() {
                            return name;
                        }
                    };
                }

                public AgendaGroup getAgendaGroup(final String name) {
                    return new AgendaGroup(){

                        public void clear() {
                            ClearAgendaGroupCommand command = new ClearAgendaGroupCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }

                        public String getName() {
                            return name;
                        }

                        public void setFocus() {
                            AgendaGroupSetFocusCommand command = new AgendaGroupSetFocusCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }
                    };
                }

                public RuleFlowGroup getRuleFlowGroup(final String name) {
                    return new RuleFlowGroup(){

                        public void clear() {
                            ClearRuleFlowGroupCommand command = new ClearRuleFlowGroupCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }

                        public String getName() {
                            return name;
                        }
                    };
                }
            };
        }
        return this.agenda;
    }

    public FactHandle getFactHandle(Object object) {
        return (FactHandle)this.commandService.execute(new GetFactHandleCommand(object));
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return (Collection)this.commandService.execute(new GetFactHandlesCommand());
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return (Collection)this.commandService.execute(new GetFactHandlesCommand(filter));
    }

    public Collection<Object> getObjects() {
        return this.getObjects(null);
    }

    public Collection<Object> getObjects(ObjectFilter filter) {
        Collection result = (Collection)this.commandService.execute(new GetObjectsCommand(filter));
        return result;
    }

    public <T extends SessionClock> T getSessionClock() {
        return (T)((SessionClock)this.commandService.execute(new GetSessionClockCommand()));
    }

    public SessionEntryPoint getEntryPoint(String name) {
        return (SessionEntryPoint)this.commandService.execute(new GetEntryPointCommand(name));
    }

    public Collection<? extends SessionEntryPoint> getEntryPoints() {
        return (Collection)this.commandService.execute(new GetEntryPointsCommand());
    }

    public void halt() {
        this.commandService.execute(new HaltCommand());
    }

    public FactHandle insert(Object object) {
        return (FactHandle)this.commandService.execute(new InsertObjectCommand(object));
    }

    public void retract(FactHandle handle) {
        this.commandService.execute(new DeleteCommand(handle));
    }

    public void delete(FactHandle handle) {
        this.commandService.execute(new DeleteCommand(handle));
    }

    public void update(FactHandle handle, Object object) {
        this.commandService.execute(new UpdateCommand(handle, object));
    }

    public void addEventListener(WorkingMemoryEventListener listener) {
        this.commandService.execute(new AddEventListenerCommand(listener));
    }

    public void addEventListener(AgendaEventListener listener) {
        this.commandService.execute(new AddEventListenerCommand(listener));
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return (Collection)this.commandService.execute(new GetAgendaEventListenersCommand());
    }

    public Collection<WorkingMemoryEventListener> getWorkingMemoryEventListeners() {
        return (Collection)this.commandService.execute(new GetWorkingMemoryEventListenersCommand());
    }

    public void removeEventListener(WorkingMemoryEventListener listener) {
        this.commandService.execute(new RemoveEventListenerCommand(listener));
    }

    public void removeEventListener(AgendaEventListener listener) {
        this.commandService.execute(new RemoveEventListenerCommand(listener));
    }

    public void addEventListener(ProcessEventListener listener) {
        this.commandService.execute(new AddEventListenerCommand(listener));
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return (Collection)this.commandService.execute(new GetProcessEventListenersCommand());
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.commandService.execute(new RemoveEventListenerCommand(listener));
    }

    public Object getGlobal(String identifier) {
        return this.commandService.execute(new GetGlobalCommand(identifier));
    }

    public void setGlobal(String identifier, Object object) {
        this.commandService.execute(new SetGlobalCommand(identifier, object));
    }

    public Globals getGlobals() {
        return (Globals)this.commandService.execute(new GetGlobalsCommand());
    }

    public Calendars getCalendars() {
        return (Calendars)this.commandService.execute(new GetCalendarsCommand());
    }

    public Object getObject(FactHandle factHandle) {
        return this.commandService.execute(new GetObjectCommand(factHandle));
    }

    public Environment getEnvironment() {
        return (Environment)this.commandService.execute(new GetEnvironmentCommand());
    }

    public <T> T execute(Command<T> command) {
        return (T)this.commandService.execute(command);
    }

    public QueryResults getQueryResults(String query, Object ... arguments) {
        QueryCommand cmd = new QueryCommand(null, query, arguments);
        return (QueryResults)this.commandService.execute(cmd);
    }

    public String getEntryPointId() {
        return EntryPoint.DEFAULT.getEntryPointId();
    }

    public long getFactCount() {
        return 0L;
    }

    public LiveQuery openLiveQuery(String query, Object[] arguments, ViewChangedEventListener listener) {
        return null;
    }

    public KieSessionConfiguration getSessionConfiguration() {
        return ((KnowledgeCommandContext)this.commandService.getContext()).getKieSession().getSessionConfiguration();
    }

    public void addInterceptor(Interceptor interceptor) {
        interceptor.setNext(this.commandService);
        this.commandService = interceptor;
    }

    public ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return (ProcessInstance)this.commandService.execute(new StartCorrelatedProcessCommand(processId, correlationKey, parameters));
    }

    public ProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return (ProcessInstance)this.commandService.execute(new CreateCorrelatedProcessInstanceCommand(processId, correlationKey, parameters));
    }

    public ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        return (ProcessInstance)this.commandService.execute(new GetProcessInstanceByCorrelationKeyCommand(correlationKey));
    }
}

