/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class OverlapsEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator OVERLAPS = Operator.addOperatorToRegistry("overlaps", false);
    public static final Operator OVERLAPS_NOT = Operator.addOperatorToRegistry("overlaps", true);
    private static final String[] SUPPORTED_IDS = new String[]{OVERLAPS.getOperatorString()};
    private Map<String, OverlapsEvaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        OverlapsEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, OverlapsEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new OverlapsEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.HANDLE;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class OverlapsEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long minDev;
        private long maxDev;
        private String paramText;

        public OverlapsEvaluator() {
        }

        public OverlapsEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText) {
            super(type, isNegated ? OVERLAPS_NOT : OVERLAPS);
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.minDev = in.readLong();
            this.maxDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.minDev);
            out.writeLong(this.maxDev);
            out.writeObject(this.paramText);
        }

        @Override
        public boolean isTemporal() {
            return true;
        }

        @Override
        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(Long.MIN_VALUE, 0L);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'overlaps' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            if (context.rightNull || context.declaration.getExtractor().isNullValue(workingMemory, left.getObject())) {
                return false;
            }
            long leftStartTS = ((EventFactHandle)left).getStartTimestamp();
            long rightEndTS = ((VariableRestriction.TemporalVariableContextEntry)context).endTS;
            long dist = rightEndTS - leftStartTS;
            return this.getOperator().isNegated() ^ (((VariableRestriction.TemporalVariableContextEntry)context).startTS < leftStartTS && rightEndTS < ((EventFactHandle)left).getEndTimestamp() && dist >= this.minDev && dist <= this.maxDev);
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            if (context.leftNull || context.extractor.isNullValue(workingMemory, right.getObject())) {
                return false;
            }
            long leftStartTS = ((VariableRestriction.TemporalVariableContextEntry)context).startTS;
            long rightEndTS = ((EventFactHandle)right).getEndTimestamp();
            long dist = rightEndTS - leftStartTS;
            return this.getOperator().isNegated() ^ (((EventFactHandle)right).getStartTimestamp() < leftStartTS && rightEndTS < ((VariableRestriction.TemporalVariableContextEntry)context).endTS && dist >= this.minDev && dist <= this.maxDev);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            if (extractor1.isNullValue(workingMemory, handle1.getObject()) || extractor2.isNullValue(workingMemory, handle2.getObject())) {
                return false;
            }
            long startTS = ((EventFactHandle)handle2).getStartTimestamp();
            long endTS = ((EventFactHandle)handle1).getEndTimestamp();
            long dist = endTS - startTS;
            return this.getOperator().isNegated() ^ (((EventFactHandle)handle1).getStartTimestamp() < startTS && endTS < ((EventFactHandle)handle2).getEndTimestamp() && dist >= this.minDev && dist <= this.maxDev);
        }

        @Override
        public String toString() {
            return "overlaps[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        @Override
        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.maxDev ^ this.maxDev >>> 32);
            result = 31 * result + (int)(this.minDev ^ this.minDev >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OverlapsEvaluator other = (OverlapsEvaluator)obj;
            return this.maxDev == other.maxDev && this.minDev == other.minDev;
        }

        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.minDev = 1L;
                this.maxDev = Long.MAX_VALUE;
            } else if (parameters.length == 1) {
                this.minDev = 1L;
                this.maxDev = parameters[0];
            } else if (parameters.length == 2) {
                this.minDev = parameters[0];
                this.maxDev = parameters[1];
            } else {
                throw new RuntimeDroolsException("[Overlaps Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
            }
        }
    }
}

