/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.drools.QueryResult;
import org.drools.WorkingMemory;
import org.drools.base.QueryRowWithSubruleIndex;
import org.drools.rule.Declaration;

public class QueryResults
implements Iterable<QueryResult> {
    private Map<String, Declaration>[] declarations;
    protected List<QueryRowWithSubruleIndex> results;
    protected WorkingMemory workingMemory;
    protected Declaration[] parameters;

    public QueryResults(List<QueryRowWithSubruleIndex> results, Map<String, Declaration>[] declarations, WorkingMemory workingMemory, Declaration[] parameters) {
        this.results = results;
        this.workingMemory = workingMemory;
        this.declarations = declarations;
        this.parameters = parameters;
    }

    public Map<String, Declaration>[] getDeclarations() {
        return this.declarations;
    }

    public Declaration[] getParameters() {
        return this.parameters;
    }

    public Map<String, Declaration> getDeclarations(int subruleIndex) {
        if (this.declarations == null || this.declarations.length == 0) {
            return Collections.emptyMap();
        }
        return this.declarations[subruleIndex];
    }

    public QueryResult get(int i) {
        if (i > this.results.size()) {
            throw new NoSuchElementException();
        }
        return new QueryResult(this.results.get(i), this.workingMemory, this);
    }

    @Override
    public Iterator<QueryResult> iterator() {
        return new QueryResultsIterator(this.results.iterator());
    }

    public int size() {
        return this.results.size();
    }

    private class QueryResultsIterator
    implements Iterator<QueryResult> {
        private Iterator<QueryRowWithSubruleIndex> iterator;

        public QueryResultsIterator(Iterator<QueryRowWithSubruleIndex> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public QueryResult next() {
            return new QueryResult(this.iterator.next(), QueryResults.this.workingMemory, QueryResults.this);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

