/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;

public class Forall
extends ConditionalElement {
    private static final long serialVersionUID = 510L;
    private Pattern basePattern;
    private List remainingPatterns;

    public Forall() {
        this(null, new ArrayList(1));
    }

    public Forall(Pattern basePattern) {
        this(basePattern, new ArrayList(1));
    }

    public Forall(Pattern basePattern, List remainingPatterns) {
        this.basePattern = basePattern;
        this.remainingPatterns = remainingPatterns;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.basePattern = (Pattern)in.readObject();
        this.remainingPatterns = (List)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.basePattern);
        out.writeObject(this.remainingPatterns);
    }

    public Forall clone() {
        return new Forall(this.basePattern, new ArrayList(this.remainingPatterns));
    }

    public Map getInnerDeclarations() {
        HashMap<String, Declaration> inner = new HashMap<String, Declaration>(this.basePattern.getOuterDeclarations());
        Iterator it = this.remainingPatterns.iterator();
        while (it.hasNext()) {
            inner.putAll(((Pattern)it.next()).getOuterDeclarations());
        }
        return inner;
    }

    public Map getOuterDeclarations() {
        return Collections.EMPTY_MAP;
    }

    public Declaration resolveDeclaration(String identifier) {
        return (Declaration)this.getInnerDeclarations().get(identifier);
    }

    public Pattern getBasePattern() {
        return this.basePattern;
    }

    public void setBasePattern(Pattern basePattern) {
        this.basePattern = basePattern;
    }

    public List getRemainingPatterns() {
        return this.remainingPatterns;
    }

    public void setRemainingPatterns(List remainingPatterns) {
        this.remainingPatterns = remainingPatterns;
    }

    public void addRemainingPattern(Pattern pattern) {
        this.remainingPatterns.add(pattern);
    }

    public List getNestedElements() {
        ArrayList<Pattern> elements = new ArrayList<Pattern>(1 + this.remainingPatterns.size());
        elements.add(this.basePattern);
        elements.addAll(this.remainingPatterns);
        return elements;
    }

    public boolean isPatternScopeDelimiter() {
        return true;
    }

    public String toString() {
        return "forall( " + this.basePattern + " " + this.remainingPatterns + " )";
    }
}

