/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.Entry;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RightTuple;
import org.drools.spi.PropagationContext;

public class ModifyPreviousTuples {
    private LeftTuple leftTuple;
    private RightTuple rightTuple;

    public ModifyPreviousTuples(LeftTuple leftTuple, RightTuple rightTuple) {
        this.leftTuple = leftTuple;
        this.rightTuple = rightTuple;
    }

    public LeftTuple peekLeftTuple() {
        return this.leftTuple;
    }

    public RightTuple peekRightTuple() {
        return this.rightTuple;
    }

    public void removeLeftTuple() {
        LeftTuple current = this.leftTuple;
        current.setLeftParentPrevious(null);
        this.leftTuple = current.getLeftParentNext();
        current.setLeftParentNext(null);
    }

    public void removeRightTuple() {
        RightTuple current = this.rightTuple;
        current.setHandlePrevious(null);
        this.rightTuple = current.getHandleNext();
        current.setHandleNext(null);
    }

    public void retractTuples(PropagationContext context, InternalWorkingMemory workingMemory) {
        Entry current;
        if (this.leftTuple != null) {
            for (current = this.leftTuple; current != null; current = current.getLeftParentNext()) {
                current.getLeftTupleSink().retractLeftTuple((LeftTuple)current, context, workingMemory);
            }
        }
        if (this.rightTuple != null) {
            for (current = this.rightTuple; current != null; current = ((RightTuple)current).getHandleNext()) {
                ((RightTuple)current).getRightTupleSink().retractRightTuple((RightTuple)current, context, workingMemory);
            }
        }
    }
}

