/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.common.BeliefSet;
import org.drools.common.BeliefSystem;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LogicalDependency;
import org.drools.common.NamedEntryPoint;
import org.drools.common.SimpleBeliefSet;
import org.drools.common.SimpleLogicalDependency;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;

public class SimpleBeliefSystem
implements BeliefSystem {
    private InternalWorkingMemory wm;
    private TruthMaintenanceSystem tms;

    public SimpleBeliefSystem(InternalWorkingMemory wm, TruthMaintenanceSystem tms) {
        this.wm = wm;
        this.tms = tms;
    }

    public void insert(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        boolean empty = beliefSet.isEmpty();
        beliefSet.add(node.getJustifierEntry());
        if (empty) {
            InternalFactHandle handle = (InternalFactHandle)node.getJustified();
            ((NamedEntryPoint)handle.getEntryPoint()).insert(handle, handle.getObject(), node.getJustifier().getRule(), node.getJustifier(), typeConf);
        }
    }

    public void read(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        beliefSet.add(node.getJustifierEntry());
    }

    public void delete(LogicalDependency node, BeliefSet beliefSet, PropagationContext context) {
        beliefSet.remove(node.getJustifierEntry());
        TruthMaintenanceSystem.LogicalRetractCallback action = new TruthMaintenanceSystem.LogicalRetractCallback(this.tms, node, beliefSet, (InternalFactHandle)node.getJustified(), context, node.getJustifier());
        this.wm.queueWorkingMemoryAction(action);
    }

    public BeliefSet newBeliefSet() {
        return new SimpleBeliefSet();
    }

    public LogicalDependency newLogicalDependency(Activation activation, InternalFactHandle handle, Object value) {
        return new SimpleLogicalDependency(activation, handle, value);
    }
}

