/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.runtime.process;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.command.Context;
import org.drools.command.IdentifiableResult;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.impl.ExecutionResultImpl;
import org.drools.runtime.process.ProcessInstance;
import org.drools.xml.jaxb.util.JaxbMapAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class StartProcessCommand
implements GenericCommand<ProcessInstance>,
IdentifiableResult {
    @XmlAttribute(required=true)
    private String processId;
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    @XmlElement(name="parameter")
    private Map<String, Object> parameters = new HashMap<String, Object>();
    @XmlElementWrapper(name="data")
    private List<Object> data = null;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    public StartProcessCommand() {
    }

    public StartProcessCommand(String processId) {
        this.processId = processId;
    }

    public StartProcessCommand(String processId, String outIdentifier) {
        this(processId);
        this.outIdentifier = outIdentifier;
    }

    public StartProcessCommand(String processId, Map<String, Object> parameters) {
        this(processId);
        this.parameters = parameters;
    }

    public StartProcessCommand(String processId, Map<String, Object> parameters, String outIdentifier) {
        this(processId, outIdentifier);
        this.parameters = parameters;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void putParameter(String key, Object value) {
        this.getParameters().put(key, value);
    }

    public List<Object> getData() {
        return this.data;
    }

    public void setData(List<Object> data) {
        this.data = data;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public ProcessInstance execute(Context context) {
        StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
        if (this.data != null) {
            for (Object o : this.data) {
                ksession.insert(o);
            }
        }
        ProcessInstance processInstance = ksession.startProcess(this.processId, this.parameters);
        if (this.outIdentifier != null) {
            ((ExecutionResultImpl)((KnowledgeCommandContext)context).getExecutionResults()).getResults().put(this.outIdentifier, processInstance.getId());
        }
        return processInstance;
    }

    public String toString() {
        String result = "session.startProcess(" + this.processId + ", [";
        if (this.parameters != null) {
            int i = 0;
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                if (i++ > 0) {
                    result = result + ", ";
                }
                result = result + entry.getKey() + "=" + entry.getValue();
            }
        }
        result = result + "]);";
        return result;
    }
}

