/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.drools.base.ValueType;
import org.drools.base.evaluators.Operator;
import org.drools.spi.Evaluator;

public class EvaluatorCache
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private Map<ValueType, Map<Operator, Evaluator>> evaluators = new HashMap<ValueType, Map<Operator, Evaluator>>();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Map temp = (Map)in.readObject();
        for (Map.Entry entry : temp.entrySet()) {
            this.evaluators.put(ValueType.determineValueType(((ValueType)entry.getKey()).getClassType()), (Map<Operator, Evaluator>)entry.getValue());
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluators);
    }

    public void addEvaluator(ValueType type, Operator operator, Evaluator evaluator) {
        Map<Operator, Evaluator> opEvalMap = this.evaluators.get(type);
        if (opEvalMap == null) {
            opEvalMap = new HashMap<Operator, Evaluator>();
            this.evaluators.put(type, opEvalMap);
        }
        opEvalMap.put(operator, evaluator);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        Map<Operator, Evaluator> opEvalMap = this.evaluators.get(type);
        return opEvalMap != null ? opEvalMap.get(operator) : null;
    }

    public boolean supportsType(ValueType type) {
        return this.evaluators.containsKey(type);
    }
}

