/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.audit.event.LogEvent;

public class ActivationLogEvent
extends LogEvent {
    private String activationId;
    private String rule;
    private String declarations;
    private String ruleFlowGroup;

    public ActivationLogEvent() {
    }

    public ActivationLogEvent(int type, String activationId, String rule, String declarations, String ruleFlowGroup) {
        super(type);
        this.activationId = activationId;
        this.rule = rule;
        this.declarations = declarations;
        this.ruleFlowGroup = ruleFlowGroup;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.activationId = (String)in.readObject();
        this.rule = (String)in.readObject();
        this.declarations = (String)in.readObject();
        this.ruleFlowGroup = (String)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.activationId);
        out.writeObject(this.rule);
        out.writeObject(this.declarations);
        out.writeObject(this.ruleFlowGroup);
    }

    public String getActivationId() {
        return this.activationId;
    }

    public String getRule() {
        return this.rule;
    }

    public String getDeclarations() {
        return this.declarations;
    }

    public String getRuleFlowGroup() {
        return this.ruleFlowGroup;
    }

    public String toString() {
        String msg = null;
        switch (this.getType()) {
            case 5: {
                msg = "ACTIVATION CANCELLED";
                break;
            }
            case 4: {
                msg = "ACTIVATION CREATED";
                break;
            }
            case 7: {
                msg = "AFTER ACTIVATION FIRED";
                break;
            }
            case 6: {
                msg = "BEFORE ACTIVATION FIRED";
            }
        }
        return msg + " rule:" + this.rule + " activationId:" + this.activationId + " declarations: " + this.declarations + (this.ruleFlowGroup == null ? "" : " ruleflow-group: " + this.ruleFlowGroup);
    }
}

