/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.common.BetaConstraints;
import org.drools.common.TupleStartEqualsConstraint;
import org.drools.reteoo.ExistsNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.QueryRiaFixerNode;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.builder.BuildUtils;
import org.drools.reteoo.builder.ReteooComponentBuilder;
import org.drools.rule.GroupElement;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.BetaNodeFieldConstraint;

public class GroupElementBuilder
implements ReteooComponentBuilder {
    protected final Map<GroupElement.Type, ReteooComponentBuilder> geBuilders = new HashMap<GroupElement.Type, ReteooComponentBuilder>();

    public GroupElementBuilder() {
        this.geBuilders.put(GroupElement.AND, new AndBuilder());
        this.geBuilders.put(GroupElement.OR, new OrBuilder());
        this.geBuilders.put(GroupElement.NOT, new NotBuilder());
        this.geBuilders.put(GroupElement.EXISTS, new ExistsBuilder());
    }

    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        GroupElement ge = (GroupElement)rce;
        ReteooComponentBuilder builder = this.geBuilders.get((Object)ge.getType());
        context.push(ge);
        context.pushRuleComponent(ge);
        builder.build(context, utils, rce);
        context.pop();
        context.popRuleComponent();
    }

    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        GroupElement ge = (GroupElement)rce;
        ReteooComponentBuilder builder = this.geBuilders.get((Object)ge.getType());
        return builder.requiresLeftActivation(utils, rce);
    }

    public static class ExistsBuilder
    implements ReteooComponentBuilder {
        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            boolean existSubNetwort = false;
            GroupElement exists = (GroupElement)rce;
            int currentPatternIndex = context.getCurrentPatternOffset();
            LeftTupleSource tupleSource = context.getTupleSource();
            RuleConditionElement child = exists.getChildren().get(0);
            ReteooComponentBuilder builder = utils.getBuilderFor(child);
            builder.build(context, utils, child);
            if (context.getObjectSource() == null && context.getTupleSource() != null) {
                context.setObjectSource((ObjectSource)utils.attachNode(context, new RightInputAdapterNode(context.getNextId(), context.getTupleSource(), context)));
                context.setTupleSource(tupleSource);
                TupleStartEqualsConstraint constraint = TupleStartEqualsConstraint.getInstance();
                ArrayList<BetaNodeFieldConstraint> predicates = new ArrayList<BetaNodeFieldConstraint>();
                predicates.add(constraint);
                context.setBetaconstraints(predicates);
                existSubNetwort = true;
            }
            if (!context.isTupleMemoryEnabled() && existSubNetwort) {
                context.setTupleSource((LeftTupleSource)utils.attachNode(context, new QueryRiaFixerNode(context.getNextId(), context.getTupleSource(), context)));
            }
            BetaConstraints betaConstraints = utils.createBetaNodeConstraint(context, context.getBetaconstraints(), false);
            context.setTupleSource((LeftTupleSource)utils.attachNode(context, new ExistsNode(context.getNextId(), context.getTupleSource(), context.getObjectSource(), betaConstraints, context)));
            context.setBetaconstraints(null);
            context.setObjectSource(null);
            context.setCurrentPatternOffset(currentPatternIndex);
        }

        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            return true;
        }
    }

    public static class NotBuilder
    implements ReteooComponentBuilder {
        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            boolean existSubNetwort = false;
            GroupElement not = (GroupElement)rce;
            int currentPatternIndex = context.getCurrentPatternOffset();
            LeftTupleSource tupleSource = context.getTupleSource();
            RuleConditionElement child = not.getChildren().get(0);
            ReteooComponentBuilder builder = utils.getBuilderFor(child);
            builder.build(context, utils, child);
            if (context.getObjectSource() == null && context.getTupleSource() != null) {
                context.setObjectSource((ObjectSource)utils.attachNode(context, new RightInputAdapterNode(context.getNextId(), context.getTupleSource(), context)));
                context.setTupleSource(tupleSource);
                TupleStartEqualsConstraint constraint = TupleStartEqualsConstraint.getInstance();
                ArrayList<BetaNodeFieldConstraint> predicates = new ArrayList<BetaNodeFieldConstraint>();
                predicates.add(constraint);
                context.setBetaconstraints(predicates);
                existSubNetwort = true;
            }
            if (!context.isTupleMemoryEnabled() && existSubNetwort) {
                context.setTupleSource((LeftTupleSource)utils.attachNode(context, new QueryRiaFixerNode(context.getNextId(), context.getTupleSource(), context)));
            }
            BetaConstraints betaConstraints = utils.createBetaNodeConstraint(context, context.getBetaconstraints(), false);
            NotNode node = new NotNode(context.getNextId(), context.getTupleSource(), context.getObjectSource(), betaConstraints, context);
            context.setTupleSource((LeftTupleSource)utils.attachNode(context, node));
            context.setBetaconstraints(null);
            context.setObjectSource(null);
            context.setCurrentPatternOffset(currentPatternIndex);
        }

        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            return true;
        }
    }

    public static class OrBuilder
    implements ReteooComponentBuilder {
        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            throw new RuntimeDroolsException("BUG: Can't build a rete network with an inner OR group element");
        }

        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            throw new RuntimeDroolsException("BUG: Can't build a rete network with an inner OR group element");
        }
    }

    public static class AndBuilder
    implements ReteooComponentBuilder {
        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            GroupElement ge = (GroupElement)rce;
            for (RuleConditionElement child : ge.getChildren()) {
                ReteooComponentBuilder builder = utils.getBuilderFor(child);
                builder.build(context, utils, child);
                if (context.getObjectSource() != null && context.getTupleSource() == null) {
                    ObjectSource source = context.getObjectSource();
                    while (!(source instanceof ObjectTypeNode)) {
                        source = source.getParentObjectSource();
                    }
                    context.setRootObjectTypeNode((ObjectTypeNode)source);
                    context.setTupleSource((LeftTupleSource)utils.attachNode(context, context.getComponentFactory().getNodeFactoryService().buildLeftInputAdapterNode(context.getNextId(), context.getObjectSource(), context)));
                    context.setObjectSource(null);
                }
                if (context.getObjectSource() == null || context.getTupleSource() == null) continue;
                BetaConstraints betaConstraints = utils.createBetaNodeConstraint(context, context.getBetaconstraints(), false);
                context.setTupleSource((LeftTupleSource)utils.attachNode(context, context.getComponentFactory().getNodeFactoryService().buildJoinNode(context.getNextId(), context.getTupleSource(), context.getObjectSource(), betaConstraints, context)));
                context.setBetaconstraints(null);
                context.setObjectSource(null);
            }
        }

        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            GroupElement and = (GroupElement)rce;
            if (and.getChildren().isEmpty()) {
                return true;
            }
            RuleConditionElement child = and.getChildren().get(0);
            ReteooComponentBuilder builder = utils.getBuilderFor(child);
            return builder.requiresLeftActivation(utils, child);
        }
    }
}

