/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.drools.base.mvel.MVELEnabledExpression;
import org.drools.base.mvel.MVELSalienceExpression;
import org.drools.common.AgendaItem;
import org.drools.common.BaseNode;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.ScheduledAgendaItem;
import org.drools.common.UpdateContext;
import org.drools.event.rule.ActivationCancelledCause;
import org.drools.reteoo.AbstractTerminalNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.time.impl.ExpressionIntervalTimer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleTerminalNode
extends AbstractTerminalNode {
    private int sequence = -1;
    private static final long serialVersionUID = 510L;
    private Rule rule;
    private GroupElement subrule;
    private int subruleIndex;
    private Declaration[] declarations;
    private Declaration[] timerDelayDeclarations;
    private Declaration[] timerPeriodDeclarations;
    private Declaration[] salienceDeclarations;
    private Declaration[] enabledDeclarations;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private boolean fireDirect;
    private int leftInputOtnId;
    private String consequenceName;

    public RuleTerminalNode() {
    }

    public RuleTerminalNode(int id, LeftTupleSource source, Rule rule, GroupElement subrule, int subruleIndex, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), source);
        this.rule = rule;
        this.subrule = subrule;
        this.subruleIndex = subruleIndex;
        this.setFireDirect(rule.getActivationListener().equals("direct"));
        this.setDeclarations(this.subrule.getOuterDeclarations());
        this.initDeclaredMask(context);
        this.initInferredMask();
    }

    public void setDeclarations(Map<String, Declaration> decls) {
        int i;
        Declaration[] declrs;
        Externalizable expr;
        if (this.rule.getSalience() instanceof MVELSalienceExpression) {
            expr = (MVELSalienceExpression)this.rule.getSalience();
            declrs = ((MVELSalienceExpression)expr).getMVELCompilationUnit().getPreviousDeclarations();
            this.salienceDeclarations = new Declaration[declrs.length];
            i = 0;
            for (Declaration declr : declrs) {
                this.salienceDeclarations[i++] = decls.get(declr.getIdentifier());
            }
            Arrays.sort(this.salienceDeclarations, SortDeclarations.instance);
        }
        if (this.rule.getEnabled() instanceof MVELEnabledExpression) {
            expr = (MVELEnabledExpression)this.rule.getEnabled();
            declrs = ((MVELEnabledExpression)expr).getMVELCompilationUnit().getPreviousDeclarations();
            this.enabledDeclarations = new Declaration[declrs.length];
            i = 0;
            for (Declaration declr : declrs) {
                this.enabledDeclarations[i++] = decls.get(declr.getIdentifier());
            }
            Arrays.sort(this.enabledDeclarations, SortDeclarations.instance);
        }
        if (this.rule.getTimer() instanceof ExpressionIntervalTimer) {
            expr = (ExpressionIntervalTimer)this.rule.getTimer();
            declrs = ((ExpressionIntervalTimer)expr).getDelayMVELCompilationUnit().getPreviousDeclarations();
            this.timerDelayDeclarations = new Declaration[declrs.length];
            i = 0;
            for (Declaration declr : declrs) {
                this.timerDelayDeclarations[i++] = decls.get(declr.getIdentifier());
            }
            Arrays.sort(this.timerDelayDeclarations, SortDeclarations.instance);
            declrs = ((ExpressionIntervalTimer)expr).getPeriodMVELCompilationUnit().getPreviousDeclarations();
            this.timerPeriodDeclarations = new Declaration[declrs.length];
            i = 0;
            for (Declaration declr : declrs) {
                this.timerPeriodDeclarations[i++] = decls.get(declr.getIdentifier());
            }
            Arrays.sort(this.timerPeriodDeclarations, SortDeclarations.instance);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sequence = in.readInt();
        this.rule = (Rule)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.subruleIndex = in.readInt();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.timerDelayDeclarations = (Declaration[])in.readObject();
        this.timerPeriodDeclarations = (Declaration[])in.readObject();
        this.salienceDeclarations = (Declaration[])in.readObject();
        this.enabledDeclarations = (Declaration[])in.readObject();
        this.consequenceName = (String)in.readObject();
        this.fireDirect = this.rule.getActivationListener().equals("direct");
        this.leftInputOtnId = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.sequence);
        out.writeObject(this.rule);
        out.writeObject(this.subrule);
        out.writeInt(this.subruleIndex);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
        out.writeObject(this.declarations);
        out.writeObject(this.timerDelayDeclarations);
        out.writeObject(this.timerPeriodDeclarations);
        out.writeObject(this.salienceDeclarations);
        out.writeObject(this.enabledDeclarations);
        out.writeObject(this.consequenceName);
        out.writeLong(this.leftInputOtnId);
    }

    public Rule getRule() {
        return this.rule;
    }

    public GroupElement getSubRule() {
        return this.subrule;
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    public int getSequence() {
        return this.sequence;
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (!this.rule.isEffective(leftTuple, this, workingMemory) || this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            leftTuple.setObject(Boolean.TRUE);
            return;
        }
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        boolean fire = agenda.createActivation(leftTuple, context, workingMemory, this, false);
        if (fire && !this.fireDirect) {
            agenda.addActivation((AgendaItem)leftTuple.getObject());
        }
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        boolean fire;
        AgendaItem match;
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        Object o = leftTuple.getObject();
        if (o != Boolean.TRUE && (match = (AgendaItem)o) != null && match.isActivated()) {
            agenda.modifyActivation(match, true);
            return;
        }
        if (!this.rule.isEffective(leftTuple, this, workingMemory) || this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            agenda.increaseDormantActivations();
            return;
        }
        boolean reuseActivation = true;
        if (o == Boolean.TRUE) {
            reuseActivation = false;
            leftTuple.setObject(null);
        }
        if ((fire = agenda.createActivation(leftTuple, context, workingMemory, this, reuseActivation)) && !this.isFireDirect()) {
            agenda.decreaseDormantActivations();
            agenda.modifyActivation((AgendaItem)leftTuple.getObject(), false);
        }
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object obj = leftTuple.getObject();
        if (obj == null || obj == Boolean.TRUE) {
            return;
        }
        Activation activation = (Activation)obj;
        activation.setMatched(false);
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        agenda.cancelActivation(leftTuple, context, workingMemory, activation, this);
    }

    @Override
    public String toString() {
        return "[RuleTerminalNode(" + this.getId() + "): rule=" + this.rule.getName() + "]";
    }

    @Override
    public void attach(BuildContext context) {
        this.getLeftTupleSource().addTupleSink(this, context);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.getLeftTupleSource().updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.getLeftTupleSource().networkUpdated(updateContext);
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        RuleRemovalContext.CleanupAdapter adapter = context.getCleanupAdapter();
        context.setCleanupAdapter(new RTNCleanupAdapter(this));
        this.getLeftTupleSource().remove(context, builder, this, workingMemories);
        for (InternalWorkingMemory workingMemory : workingMemories) {
            workingMemory.executeQueuedActions();
        }
        context.setCleanupAdapter(adapter);
    }

    @Override
    public boolean isInUse() {
        return false;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
    }

    public Declaration[] getDeclarations() {
        if (this.declarations == null) {
            Map<String, Declaration> decls = this.subrule.getOuterDeclarations();
            String[] requiredDeclarations = this.rule.getRequiredDeclarationsForConsequence(this.getConsequenceName());
            this.declarations = new Declaration[requiredDeclarations.length];
            int i = 0;
            for (String str : requiredDeclarations) {
                this.declarations[i++] = decls.get(str);
            }
            Arrays.sort(this.declarations, SortDeclarations.instance);
        }
        return this.declarations;
    }

    public Declaration[] getTimerDelayDeclarations() {
        return this.timerDelayDeclarations;
    }

    public void setTimerDelayDeclarations(Declaration[] timerDelayDeclarations) {
        this.timerDelayDeclarations = timerDelayDeclarations;
    }

    public Declaration[] getTimerPeriodDeclarations() {
        return this.timerPeriodDeclarations;
    }

    public void setTimerPeriodDeclarations(Declaration[] timerPeriodDeclarations) {
        this.timerPeriodDeclarations = timerPeriodDeclarations;
    }

    public Declaration[] getSalienceDeclarations() {
        return this.salienceDeclarations;
    }

    public void setSalienceDeclarations(Declaration[] salienceDeclarations) {
        this.salienceDeclarations = salienceDeclarations;
    }

    public Declaration[] getEnabledDeclarations() {
        return this.enabledDeclarations;
    }

    public void setEnabledDeclarations(Declaration[] enabledDeclarations) {
        this.enabledDeclarations = enabledDeclarations;
    }

    public String getConsequenceName() {
        return this.consequenceName == null ? "default" : this.consequenceName;
    }

    public void setConsequenceName(String consequenceName) {
        this.consequenceName = consequenceName;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public int hashCode() {
        return this.rule.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RuleTerminalNode)) {
            return false;
        }
        RuleTerminalNode other = (RuleTerminalNode)object;
        return this.rule.equals(other.rule) && (this.consequenceName == null ? other.consequenceName == null : this.consequenceName.equals(other.consequenceName));
    }

    @Override
    public short getType() {
        return 9;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public int getLeftInputOtnId() {
        return this.leftInputOtnId;
    }

    @Override
    public void setLeftInputOtnId(int leftInputOtnId) {
        this.leftInputOtnId = leftInputOtnId;
    }

    public boolean isFireDirect() {
        return this.fireDirect;
    }

    public void setFireDirect(boolean fireDirect) {
        this.fireDirect = fireDirect;
    }

    protected ObjectTypeNode getObjectTypeNode() {
        return this.getLeftTupleSource().getObjectTypeNode();
    }

    public static class RTNCleanupAdapter
    implements RuleRemovalContext.CleanupAdapter {
        private final RuleTerminalNode node;

        public RTNCleanupAdapter(RuleTerminalNode node) {
            this.node = node;
        }

        public void cleanUp(LeftTuple leftTuple, InternalWorkingMemory workingMemory) {
            if (leftTuple.getLeftTupleSink() != this.node) {
                return;
            }
            Activation activation = (Activation)leftTuple.getObject();
            if (activation instanceof ScheduledAgendaItem) {
                ScheduledAgendaItem scheduled = (ScheduledAgendaItem)activation;
                workingMemory.getTimerService().removeJob(scheduled.getJobHandle());
                scheduled.getJobHandle().setCancel(true);
            }
            if (activation.isActivated()) {
                activation.remove();
                ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory, ActivationCancelledCause.CLEAR);
            }
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 4, null, null, null);
            workingMemory.getTruthMaintenanceSystem().removeLogicalDependencies(activation, propagationContext, this.node.getRule());
            leftTuple.unlinkFromLeftParent();
            leftTuple.unlinkFromRightParent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortDeclarations
    implements Comparator<Declaration> {
        public static final SortDeclarations instance = new SortDeclarations();

        @Override
        public int compare(Declaration d1, Declaration d2) {
            return d1.getIdentifier().compareTo(d2.getIdentifier());
        }
    }
}

