/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.WorkingMemoryAction;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.marshalling.impl.TimersInputMarshaller;
import org.drools.marshalling.impl.TimersOutputMarshaller;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.WindowNode;
import org.drools.reteoo.WindowTuple;
import org.drools.reteoo.WindowTupleList;
import org.drools.rule.Behavior;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.TimerService;
import org.drools.time.impl.PointInTimeTrigger;

public class SlidingTimeWindow
implements Externalizable,
Behavior {
    private long size;
    public static final BehaviorJob job = new BehaviorJob();

    public SlidingTimeWindow() {
        this(0L);
    }

    public SlidingTimeWindow(long size) {
        this.size = size;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readLong();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.size);
    }

    public Behavior.BehaviorType getType() {
        return Behavior.BehaviorType.TIME_WINDOW;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Object createContext() {
        return new SlidingTimeWindowContext();
    }

    public boolean assertFact(WindowNode.WindowMemory memory, Object context, InternalFactHandle fact, InternalWorkingMemory workingMemory) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        EventFactHandle handle = (EventFactHandle)fact;
        queue.queue.add(handle);
        if (queue.queue.peek() == handle) {
            SlidingTimeWindow.updateNextExpiration(handle, workingMemory, memory, this, queue);
        }
        return true;
    }

    public void retractFact(WindowNode.WindowMemory memory, Object context, InternalFactHandle fact, InternalWorkingMemory workingMemory) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        EventFactHandle handle = (EventFactHandle)fact;
        if (queue.expiringHandle != handle) {
            if (queue.queue.peek() == handle) {
                queue.queue.poll();
                SlidingTimeWindow.updateNextExpiration(queue.queue.peek(), workingMemory, memory, this, queue);
            } else {
                queue.queue.remove(handle);
            }
        }
    }

    public void expireFacts(WindowNode.WindowMemory memory, Object context, InternalWorkingMemory workingMemory) {
        TimerService clock = workingMemory.getTimerService();
        long currentTime = clock.getCurrentTime();
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        EventFactHandle handle = queue.queue.peek();
        while (handle != null && this.isExpired(currentTime, handle)) {
            queue.expiringHandle = handle;
            queue.queue.remove();
            if (handle.isValid()) {
                PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 5, null, null, handle);
                WindowTupleList list = (WindowTupleList)memory.events.get(handle);
                WindowTuple tuple = list.getFirstWindowTuple();
                while (tuple != null) {
                    tuple.getRightTupleSink().retractRightTuple(tuple, propagationContext, workingMemory);
                    propagationContext.evaluateActionQueue(workingMemory);
                    ((RightTuple)tuple).unlinkFromRightParent();
                    tuple = list.getFirstWindowTuple();
                }
            }
            queue.expiringHandle = null;
            handle = queue.queue.peek();
        }
        SlidingTimeWindow.updateNextExpiration(handle, workingMemory, memory, this, queue);
    }

    private boolean isExpired(long currentTime, EventFactHandle handle) {
        return handle.getStartTimestamp() + this.size <= currentTime;
    }

    private static void updateNextExpiration(InternalFactHandle fact, InternalWorkingMemory workingMemory, WindowNode.WindowMemory memory, SlidingTimeWindow stw, Object context) {
        TimerService clock = workingMemory.getTimerService();
        if (fact != null) {
            long nextTimestamp = ((EventFactHandle)fact).getStartTimestamp() + stw.getSize();
            BehaviorJobContext jobctx = new BehaviorJobContext(workingMemory, stw, memory, context);
            JobHandle handle = clock.scheduleJob(job, jobctx, new PointInTimeTrigger(nextTimestamp, null, null));
            jobctx.setJobHandle(handle);
        }
    }

    public long getExpirationOffset() {
        return this.size;
    }

    public String toString() {
        return "SlidingTimeWindow( size=" + this.size + " )";
    }

    public static class BehaviorExpireWMAction
    implements WorkingMemoryAction {
        private final Behavior behavior;
        private final Object context;
        private final WindowNode.WindowMemory memory;

        public BehaviorExpireWMAction(Behavior behavior, WindowNode.WindowMemory memory, Object context) {
            this.behavior = behavior;
            this.memory = memory;
            this.context = context;
        }

        public BehaviorExpireWMAction(MarshallerReaderContext inCtx) throws IOException {
            int sinkId = inCtx.readInt();
            WindowNode windowNode = (WindowNode)inCtx.sinks.get(sinkId);
            this.memory = (WindowNode.WindowMemory)inCtx.wm.getNodeMemory(windowNode);
            Object[] behaviorContext = (Object[])this.memory.behaviorContext;
            int i = inCtx.readInt();
            this.behavior = (SlidingTimeWindow)windowNode.getBehaviors()[i];
            this.context = (SlidingTimeWindowContext)behaviorContext[i];
        }

        public BehaviorExpireWMAction(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            int sinkId = _action.getBehaviorExpire().getNodeId();
            WindowNode windowNode = (WindowNode)context.sinks.get(sinkId);
            this.memory = (WindowNode.WindowMemory)context.wm.getNodeMemory(windowNode);
            Object[] behaviorContext = (Object[])this.memory.behaviorContext;
            int i = 0;
            this.behavior = (SlidingTimeWindow)windowNode.getBehaviors()[i];
            this.context = (SlidingTimeWindowContext)behaviorContext[i];
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.behavior.expireFacts(this.memory, this.context, workingMemory);
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }

        public void write(MarshallerWriteContext outputCtx) throws IOException {
            outputCtx.writeShort(8);
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)this.context;
            EventFactHandle handle = slCtx.getQueue().peek();
            outputCtx.writeInt(handle.getId());
        }

        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext outputCtx) {
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)this.context;
            ProtobufMessages.ActionQueue.BehaviorExpire _be = ProtobufMessages.ActionQueue.BehaviorExpire.newBuilder().setNodeId(slCtx.getQueue().peek().getId()).build();
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.BEHAVIOR_EXPIRE).setBehaviorExpire(_be).build();
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    public static class BehaviorJob
    implements Job {
        public void execute(JobContext ctx) {
            BehaviorJobContext context = (BehaviorJobContext)ctx;
            context.workingMemory.queueWorkingMemoryAction(new BehaviorExpireWMAction(context.behavior, context.memory, context.behaviorContext));
        }
    }

    public static class BehaviorJobContext
    implements JobContext,
    Externalizable {
        public InternalWorkingMemory workingMemory;
        public Behavior behavior;
        public Object behaviorContext;
        public WindowNode.WindowMemory memory;
        public JobHandle handle;

        public BehaviorJobContext(InternalWorkingMemory workingMemory, Behavior behavior, WindowNode.WindowMemory memory, Object behaviorContext) {
            this.workingMemory = workingMemory;
            this.behavior = behavior;
            this.memory = memory;
            this.behaviorContext = behaviorContext;
        }

        public JobHandle getJobHandle() {
            return this.handle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.handle = jobHandle;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    public static class BehaviorJobContextTimerInputMarshaller
    implements TimersInputMarshaller {
        public void read(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
            int sinkId = inCtx.readInt();
            WindowNode windowNode = (WindowNode)inCtx.sinks.get(sinkId);
            WindowNode.WindowMemory memory = (WindowNode.WindowMemory)inCtx.wm.getNodeMemory(windowNode);
            Object[] behaviorContext = (Object[])memory.behaviorContext;
            int i = inCtx.readInt();
        }

        public void deserialize(MarshallerReaderContext inCtx, ProtobufMessages.Timers.Timer _timer) throws ClassNotFoundException {
            int i = _timer.getBehavior().getHandleId();
        }
    }

    public static class BehaviorJobContextTimerOutputMarshaller
    implements TimersOutputMarshaller {
        public void write(JobContext jobCtx, MarshallerWriteContext outputCtx) throws IOException {
            outputCtx.writeShort(51);
            BehaviorJobContext bjobCtx = (BehaviorJobContext)jobCtx;
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)bjobCtx.behaviorContext;
            EventFactHandle handle = slCtx.getQueue().peek();
            outputCtx.writeInt(handle.getId());
        }

        public ProtobufMessages.Timers.Timer serialize(JobContext jobCtx, MarshallerWriteContext outputCtx) {
            BehaviorJobContext bjobCtx = (BehaviorJobContext)jobCtx;
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)bjobCtx.behaviorContext;
            EventFactHandle handle = slCtx.getQueue().peek();
            return ProtobufMessages.Timers.Timer.newBuilder().setType(ProtobufMessages.Timers.TimerType.BEHAVIOR).setBehavior(ProtobufMessages.Timers.BehaviorTimer.newBuilder().setHandleId(handle.getId()).build()).build();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SlidingTimeWindowContext
    implements Externalizable {
        public PriorityQueue<EventFactHandle> queue = new PriorityQueue<EventFactHandle>(16, new SlidingTimeWindowComparator());
        public EventFactHandle expiringHandle;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.queue = (PriorityQueue)in.readObject();
            this.expiringHandle = (EventFactHandle)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.queue);
            out.writeObject(this.expiringHandle);
        }

        public PriorityQueue<EventFactHandle> getQueue() {
            return this.queue;
        }

        public void setQueue(PriorityQueue<EventFactHandle> queue) {
            this.queue = queue;
        }

        public EventFactHandle getExpiringHandle() {
            return this.expiringHandle;
        }

        public void setExpiringTuple(EventFactHandle expiringHandle) {
            this.expiringHandle = expiringHandle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SlidingTimeWindowComparator
    implements Comparator<EventFactHandle> {
        private SlidingTimeWindowComparator() {
        }

        @Override
        public int compare(EventFactHandle e1, EventFactHandle e2) {
            return e1.getStartTimestamp() < e2.getStartTimestamp() ? -1 : (e1.getStartTimestamp() == e2.getStartTimestamp() ? 0 : 1);
        }
    }
}

