/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.drools.KnowledgeBase;
import org.drools.base.ClassFieldAccessor;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.common.AbstractRuleBase;
import org.drools.core.util.TripleStore;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.factmodel.BuildUtils;
import org.drools.factmodel.ClassBuilderFactory;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.factmodel.traits.CoreWrapper;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.TraitCoreWrapperClassBuilderImpl;
import org.drools.factmodel.traits.TraitMapPropertyWrapperClassBuilderImpl;
import org.drools.factmodel.traits.TraitMapProxyClassBuilderImpl;
import org.drools.factmodel.traits.TraitPropertyWrapperClassBuilder;
import org.drools.factmodel.traits.TraitProxyClassBuilder;
import org.drools.factmodel.traits.TraitRegistry;
import org.drools.factmodel.traits.TraitTriplePropertyWrapperClassBuilderImpl;
import org.drools.factmodel.traits.TraitTripleProxyClassBuilderImpl;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.rule.Package;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Opcodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitFactory<T extends Thing<K>, K extends TraitableBean>
implements Opcodes {
    private static VirtualPropertyMode mode = VirtualPropertyMode.TRIPLES;
    public static final String SUFFIX = "_Trait__Extension";
    private static final String pack = "org.drools.factmodel.traits.";
    private static Map<String, Constructor> factoryCache = new HashMap<String, Constructor>();
    private static Map<Class, Class<? extends CoreWrapper<?>>> wrapperCache = new HashMap();
    private AbstractRuleBase ruleBase;

    public static void reset() {
        factoryCache.clear();
        wrapperCache.clear();
    }

    public static void setMode(VirtualPropertyMode newMode) {
        mode = newMode;
        switch (mode) {
            case MAP: {
                ClassBuilderFactory.setPropertyWrapperBuilderService(new TraitMapPropertyWrapperClassBuilderImpl());
                ClassBuilderFactory.setTraitProxyBuilderService(new TraitMapProxyClassBuilderImpl());
                break;
            }
            case TRIPLES: {
                ClassBuilderFactory.setPropertyWrapperBuilderService(new TraitTriplePropertyWrapperClassBuilderImpl());
                ClassBuilderFactory.setTraitProxyBuilderService(new TraitTripleProxyClassBuilderImpl());
                break;
            }
            default: {
                throw new RuntimeException(" This should not happen : unexpected property wrapping method " + (Object)((Object)mode));
            }
        }
    }

    public TraitFactory(KnowledgeBase knowledgeBase) {
        this.ruleBase = (AbstractRuleBase)((KnowledgeBaseImpl)knowledgeBase).getRuleBase();
    }

    public T getProxy(K core, Class<?> trait) {
        String traitName = trait.getName();
        if (core.hasTrait(traitName)) {
            return (T)core.getTrait(traitName);
        }
        String key = TraitFactory.getKey(core.getClass(), trait);
        Constructor<T> konst = factoryCache.get(key);
        if (konst == null) {
            konst = this.cacheConstructor(key, core, trait);
        }
        Thing proxy = null;
        try {
            switch (mode) {
                case MAP: {
                    proxy = (Thing)konst.newInstance(core, core.getDynamicProperties());
                    break;
                }
                case TRIPLES: {
                    proxy = (Thing)konst.newInstance(core, this.ruleBase.getTripleStore());
                    break;
                }
                default: {
                    throw new RuntimeException(" This should not happen : unexpected property wrapping method " + (Object)((Object)mode));
                }
            }
            core.addTrait(traitName, proxy);
            return (T)proxy;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Constructor<T> cacheConstructor(String key, K core, Class<?> trait) {
        Class<T> proxyClass = this.buildProxyClass(key, core, trait);
        if (proxyClass == null) {
            return null;
        }
        try {
            Constructor<T> konst;
            switch (mode) {
                case MAP: {
                    konst = proxyClass.getConstructor(core.getClass(), Map.class);
                    break;
                }
                case TRIPLES: {
                    konst = proxyClass.getConstructor(core.getClass(), TripleStore.class);
                    break;
                }
                default: {
                    throw new RuntimeException(" This should not happen : unexpected property wrapping method " + (Object)((Object)mode));
                }
            }
            factoryCache.put(key, konst);
            return konst;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getProxyName(ClassDefinition trait, ClassDefinition core) {
        return TraitFactory.getKey(core.getDefinedClass(), trait.getDefinedClass()) + "Proxy";
    }

    public static String getPropertyWrapperName(ClassDefinition trait, ClassDefinition core) {
        return TraitFactory.getKey(core.getDefinedClass(), trait.getDefinedClass()) + "ProxyWrapper";
    }

    private static String getKey(Class core, Class trait) {
        return trait.getName() + core.getName().replace(".", "");
    }

    private Class<T> buildProxyClass(String key, K core, Class<?> trait) {
        Class<?> coreKlass = core.getClass();
        ClassDefinition tdef = TraitRegistry.getInstance().getTrait(trait.getName());
        ClassDefinition cdef = TraitRegistry.getInstance().getTraitable(coreKlass.getName());
        String proxyName = TraitFactory.getProxyName(tdef, cdef);
        String wrapperName = TraitFactory.getPropertyWrapperName(tdef, cdef);
        TraitPropertyWrapperClassBuilder propWrapperBuilder = (TraitPropertyWrapperClassBuilder)ClassBuilderFactory.getPropertyWrapperBuilderService();
        propWrapperBuilder.init(tdef);
        try {
            byte[] propWrapper = propWrapperBuilder.buildClass(cdef);
            this.ruleBase.registerAndLoadTypeDefinition(wrapperName, propWrapper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TraitProxyClassBuilder proxyBuilder = (TraitProxyClassBuilder)ClassBuilderFactory.getTraitProxyBuilderService();
        proxyBuilder.init(tdef);
        try {
            byte[] proxy = proxyBuilder.buildClass(cdef);
            this.ruleBase.registerAndLoadTypeDefinition(proxyName, proxy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            long mask = TraitRegistry.getInstance().getFieldMask(trait.getName(), cdef.getDefinedClass().getName());
            Class proxyClass = this.ruleBase.getRootClassLoader().loadClass(proxyName, true);
            this.bindAccessors(proxyClass, tdef, cdef, mask);
            Class wrapperClass = this.ruleBase.getRootClassLoader().loadClass(wrapperName, true);
            this.bindCoreAccessors(wrapperClass, cdef);
            return proxyClass;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void bindAccessors(Class<T> proxyClass, ClassDefinition tdef, ClassDefinition cdef, long mask) {
        int j = 0;
        for (FieldDefinition traitField : tdef.getFieldsDefinitions()) {
            boolean isSoftField = TraitRegistry.isSoftField(traitField, j++, mask);
            if (isSoftField) continue;
            FieldDefinition field = cdef.getField(traitField.getName());
            try {
                Field staticField = proxyClass.getField(field.getName() + "_reader");
                staticField.set(null, field.getFieldAccessor().getReadAccessor());
                staticField = proxyClass.getField(field.getName() + "_writer");
                staticField.set(null, field.getFieldAccessor().getWriteAccessor());
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void bindCoreAccessors(Class<T> wrapperClass, ClassDefinition cdef) {
        for (FieldDefinition field : cdef.getFieldsDefinitions()) {
            try {
                Field staticField = wrapperClass.getField(field.getName() + "_reader");
                staticField.set(null, field.getFieldAccessor().getReadAccessor());
                staticField = wrapperClass.getField(field.getName() + "_writer");
                staticField.set(null, field.getFieldAccessor().getWriteAccessor());
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private Package getPackage(String pack) {
        Package pkg = this.ruleBase.getPackage(pack);
        if (pkg == null) {
            pkg = new Package(pack);
            JavaDialectRuntimeData data = new JavaDialectRuntimeData();
            pkg.getDialectRuntimeRegistry().setDialectData("java", data);
            data.onAdd(pkg.getDialectRuntimeRegistry(), this.ruleBase.getRootClassLoader());
            this.ruleBase.addPackages(Arrays.asList(pkg));
        }
        return pkg;
    }

    public CoreWrapper<K> getCoreWrapper(Class<K> coreKlazz) {
        if (wrapperCache == null) {
            wrapperCache = new HashMap();
        }
        Class<CoreWrapper<Object>> wrapperClass = null;
        if (wrapperCache.containsKey(coreKlazz)) {
            wrapperClass = wrapperCache.get(coreKlazz);
        } else {
            try {
                wrapperClass = this.buildCoreWrapper(coreKlazz);
            }
            catch (IOException e) {
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            wrapperCache.put(coreKlazz, wrapperClass);
        }
        try {
            TraitRegistry.getInstance().addTraitable(this.buildWrapperClassDefinition(coreKlazz, wrapperClass));
            return wrapperClass != null ? wrapperClass.newInstance() : null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private ClassDefinition buildWrapperClassDefinition(Class<K> coreKlazz, Class<? extends CoreWrapper<K>> wrapperClass) throws IOException {
        ClassFieldInspector inspector = new ClassFieldInspector(coreKlazz);
        Package traitPackage = this.ruleBase.getPackagesMap().get(pack);
        if (traitPackage == null) {
            traitPackage = new Package(pack);
            traitPackage.setClassFieldAccessorCache(this.ruleBase.getClassFieldAccessorCache());
            this.ruleBase.getPackagesMap().put(pack, traitPackage);
        }
        ClassFieldAccessorStore store = traitPackage.getClassFieldAccessorStore();
        String className = coreKlazz.getName() + "Wrapper";
        String superClass = coreKlazz.getName();
        String[] interfaces = new String[]{CoreWrapper.class.getName()};
        ClassDefinition def = new ClassDefinition(className, superClass, interfaces);
        def.setTraitable(true);
        def.setDefinedClass(wrapperClass);
        Map<String, Field> fields = inspector.getFieldTypesField();
        for (Field f : fields.values()) {
            if (f == null) continue;
            FieldDefinition fld = new FieldDefinition();
            fld.setName(f.getName());
            fld.setTypeName(f.getType().getName());
            fld.setInherited(true);
            ClassFieldAccessor accessor = store.getAccessor(def.getDefinedClass().getName(), fld.getName());
            fld.setReadWriteAccessor(accessor);
            def.addField(fld);
        }
        return def;
    }

    private Class<CoreWrapper<K>> buildCoreWrapper(Class<K> coreKlazz) throws IOException, ClassNotFoundException {
        String coreName = coreKlazz.getName();
        String wrapperName = coreName + "Wrapper";
        ClassDefinition coreDef = new ClassDefinition(coreKlazz.getName());
        coreDef.setDefinedClass(coreKlazz);
        try {
            byte[] wrapper = new TraitCoreWrapperClassBuilderImpl().buildClass(coreDef);
            this.ruleBase.registerAndLoadTypeDefinition(wrapperName, wrapper);
        }
        catch (Exception e) {
            // empty catch block
        }
        Class wrapperClass = this.ruleBase.getRootClassLoader().loadClass(wrapperName, true);
        return wrapperClass;
    }

    public static void valueOf(MethodVisitor mv, String type) {
        mv.visitMethodInsn(184, BuildUtils.getInternalType(BuildUtils.box(type)), "valueOf", "(" + BuildUtils.getTypeDescriptor(type) + ")" + BuildUtils.getTypeDescriptor(BuildUtils.box(type)));
    }

    public static void promote(MethodVisitor mv, String fieldType) {
        mv.visitTypeInsn(192, BuildUtils.getInternalType(BuildUtils.box(fieldType)));
        mv.visitMethodInsn(182, BuildUtils.getInternalType(BuildUtils.box(fieldType)), fieldType + "Value", "()" + BuildUtils.getTypeDescriptor(fieldType));
    }

    public static void invokeExtractor(MethodVisitor mv, String masterName, ClassDefinition source, ClassDefinition target, FieldDefinition field) {
        String fieldType = field.getTypeName();
        mv.visitFieldInsn(178, BuildUtils.getInternalType(masterName), field.getName() + "_reader", "Lorg/drools/spi/InternalReadAccessor;");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(masterName), "object", BuildUtils.getTypeDescriptor(target.getName()));
        String returnType = BuildUtils.isPrimitive(fieldType) ? BuildUtils.getTypeDescriptor(fieldType) : "Ljava/lang/Object;";
        mv.visitMethodInsn(185, "org/drools/spi/InternalReadAccessor", BuildUtils.extractor(fieldType), "(Ljava/lang/Object;)" + returnType);
    }

    public static void invokeInjector(MethodVisitor mv, String masterName, ClassDefinition source, ClassDefinition target, FieldDefinition field, boolean toNull, int pointer) {
        String fieldName = field.getName();
        String fieldType = field.getTypeName();
        mv.visitFieldInsn(178, BuildUtils.getInternalType(masterName), fieldName + "_writer", "Lorg/drools/spi/WriteAccessor;");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(masterName), "object", BuildUtils.getTypeDescriptor(target.getName()));
        if (toNull) {
            mv.visitInsn(BuildUtils.zero(field.getTypeName()));
        } else {
            mv.visitVarInsn(BuildUtils.varType(fieldType), pointer);
        }
        String argType = BuildUtils.isPrimitive(fieldType) ? BuildUtils.getTypeDescriptor(fieldType) : "Ljava/lang/Object;";
        mv.visitMethodInsn(185, "org/drools/spi/WriteAccessor", BuildUtils.injector(fieldType), "(Ljava/lang/Object;" + argType + ")V");
    }

    public static String buildSignature(Method method) {
        String sig = "(";
        for (Class<?> arg : method.getParameterTypes()) {
            sig = sig + BuildUtils.getTypeDescriptor(arg.getName());
        }
        sig = sig + ")";
        sig = sig + BuildUtils.getTypeDescriptor(method.getReturnType().getName());
        return sig;
    }

    public static int getStackSize(Method m) {
        int stack = 1;
        for (Class<?> klass : m.getParameterTypes()) {
            stack += BuildUtils.sizeOf(klass.getName());
        }
        return stack;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VirtualPropertyMode {
        MAP,
        TRIPLES;

    }
}

