/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.definition.type.FactField;
import org.drools.definition.type.FactType;
import org.drools.factmodel.AnnotationDefinition;
import org.drools.factmodel.FieldDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDefinition
implements FactType {
    private String className;
    private String superClass;
    private String[] interfaces;
    private transient Class<?> definedClass;
    private boolean traitable;
    private boolean abstrakt = false;
    private LinkedHashMap<String, FieldDefinition> fields = new LinkedHashMap();
    private List<AnnotationDefinition> annotations;
    private Map<String, List<String>> modifiedPropsByMethod;

    public ClassDefinition() {
        this(null, null, null);
    }

    public ClassDefinition(String className) {
        this(className, null, null);
    }

    public ClassDefinition(String className, String superClass) {
        this(className, superClass, null);
    }

    public ClassDefinition(String className, String superClass, String[] interfaces) {
        this.setClassName(className);
        this.setSuperClass(superClass);
        this.setInterfaces(interfaces);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        this.superClass = (String)in.readObject();
        this.interfaces = (String[])in.readObject();
        this.fields = (LinkedHashMap)in.readObject();
        this.annotations = (List)in.readObject();
        this.modifiedPropsByMethod = (Map)in.readObject();
        this.traitable = in.readBoolean();
        this.abstrakt = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.superClass);
        out.writeObject(this.interfaces);
        out.writeObject(this.fields);
        out.writeObject(this.annotations);
        out.writeObject(this.modifiedPropsByMethod);
        out.writeBoolean(this.traitable);
        out.writeBoolean(this.abstrakt);
    }

    public final String getClassName() {
        return this.className;
    }

    public final void setClassName(String className) {
        this.className = className;
    }

    public final Class<?> getDefinedClass() {
        return this.definedClass;
    }

    public void setDefinedClass(Class<?> definedClass) {
        this.definedClass = definedClass;
    }

    public final void addField(FieldDefinition attr) {
        this.fields.put(attr.getName(), attr);
    }

    public final Collection<FieldDefinition> getFieldsDefinitions() {
        return Collections.unmodifiableCollection(this.fields.values());
    }

    public final FieldDefinition getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public FieldDefinition getField(int index) {
        if (index >= this.fields.size() || index < 0) {
            throw new IndexOutOfBoundsException("Error trying to access field at position " + index);
        }
        Iterator<FieldDefinition> iter = this.fields.values().iterator();
        for (int j = 0; j < index; ++j) {
            iter.next();
        }
        return iter.next();
    }

    public final String[] getInterfaces() {
        return this.interfaces;
    }

    public final void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces != null ? interfaces : new String[]{};
    }

    public final String getSuperClass() {
        return this.superClass;
    }

    public final void setSuperClass(String superClass) {
        this.superClass = superClass != null ? superClass : "java.lang.Object";
    }

    public String getName() {
        return this.getClassName();
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        return this.definedClass.newInstance();
    }

    public Class<?> getFactClass() {
        return this.getDefinedClass();
    }

    public List<FactField> getFields() {
        return new ArrayList<FactField>(this.fields.values());
    }

    public Object get(Object bean, String field) {
        return this.getField(field).getFieldAccessor().getValue(bean);
    }

    public void set(Object bean, String field, Object value) {
        this.getField(field).getFieldAccessor().setValue(bean, value);
    }

    public Map<String, Object> getAsMap(Object bean) {
        HashMap<String, Object> m = new HashMap<String, Object>(this.fields.size());
        for (Map.Entry<String, FieldDefinition> ent : this.fields.entrySet()) {
            Object val = ent.getValue().getFieldAccessor().getValue(bean);
            m.put(ent.getKey(), val);
        }
        return m;
    }

    public void setFromMap(Object bean, Map<String, Object> data) {
        for (Map.Entry<String, Object> ent : data.entrySet()) {
            this.set(bean, ent.getKey(), ent.getValue());
        }
    }

    public void addAnnotation(AnnotationDefinition annotationDefinition) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationDefinition>();
        }
        this.annotations.add(annotationDefinition);
    }

    public List<AnnotationDefinition> getAnnotations() {
        return this.annotations;
    }

    public void addModifiedPropsByMethod(Method method, List<String> props) {
        if (this.modifiedPropsByMethod == null) {
            this.modifiedPropsByMethod = new HashMap<String, List<String>>();
        }
        String methodName = method.getName() + "_" + method.getParameterTypes().length;
        this.modifiedPropsByMethod.put(methodName, props);
    }

    public List<String> getModifiedPropsByMethod(Method method) {
        String methodName = method.getName() + "_" + method.getParameterTypes().length;
        return this.getModifiedPropsByMethod(methodName);
    }

    public List<String> getModifiedPropsByMethod(String methodName) {
        return this.modifiedPropsByMethod == null ? null : this.modifiedPropsByMethod.get(methodName);
    }

    public boolean isTraitable() {
        return this.traitable;
    }

    public void setTraitable(boolean traitable) {
        this.traitable = traitable;
    }

    public boolean isAbstrakt() {
        return this.abstrakt;
    }

    public void setAbstrakt(boolean abstrakt) {
        this.abstrakt = abstrakt;
    }

    public String toString() {
        return "ClassDefinition{className='" + this.className + '\'' + ", superClass='" + this.superClass + '\'' + ", interfaces=" + (this.interfaces == null ? null : Arrays.asList(this.interfaces)) + ", definedClass=" + this.definedClass + ", traitable=" + this.traitable + ", abstract=" + this.abstrakt + ", fields=" + this.fields + ", annotations=" + this.annotations + '}';
    }
}

