/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.common.ActivationNode;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleFlowGroupListener;
import org.drools.common.WorkingMemoryAction;
import org.drools.core.util.LinkedList;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.spi.Activation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleFlowGroupImpl
implements InternalRuleFlowGroup {
    private static final long serialVersionUID = 510L;
    private InternalWorkingMemory workingMemory;
    private String name;
    private boolean active = false;
    private boolean autoDeactivate = true;
    private LinkedList list;
    private List<RuleFlowGroupListener> listeners;
    private Map<Long, String> nodeInstances = new HashMap<Long, String>();

    public RuleFlowGroupImpl() {
    }

    public RuleFlowGroupImpl(String name) {
        this.name = name;
        this.list = new LinkedList();
    }

    public RuleFlowGroupImpl(String name, boolean active, boolean autoDeactivate) {
        this.name = name;
        this.active = active;
        this.autoDeactivate = autoDeactivate;
        this.list = new LinkedList();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (InternalWorkingMemory)in.readObject();
        this.name = (String)in.readObject();
        this.active = in.readBoolean();
        this.list = (LinkedList)in.readObject();
        this.autoDeactivate = in.readBoolean();
        this.listeners = (List)in.readObject();
        this.nodeInstances = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
        out.writeObject(this.name);
        out.writeBoolean(this.active);
        out.writeObject(this.list);
        out.writeBoolean(this.autoDeactivate);
        out.writeObject(this.listeners);
        out.writeObject(this.nodeInstances);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    @Override
    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (active) {
            ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireBeforeRuleFlowGroupActivated(this, this.workingMemory);
            if (this.list.isEmpty()) {
                if (this.autoDeactivate) {
                    DeactivateCallback action = new DeactivateCallback(this);
                    this.workingMemory.queueWorkingMemoryAction(action);
                }
            } else {
                this.triggerActivations();
            }
            ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireAfterRuleFlowGroupActivated(this, this.workingMemory);
        } else {
            ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireBeforeRuleFlowGroupDeactivated(this, this.workingMemory);
            org.drools.core.util.Iterator it = this.list.iterator();
            ActivationNode node = (ActivationNode)it.next();
            while (node != null) {
                Activation activation = node.getActivation();
                activation.remove();
                if (activation.getActivationGroupNode() != null) {
                    activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
                }
                node = (ActivationNode)it.next();
            }
            this.nodeInstances.clear();
            this.notifyRuleFlowGroupListeners();
            ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireAfterRuleFlowGroupDeactivated(this, this.workingMemory);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isAutoDeactivate() {
        return this.autoDeactivate;
    }

    @Override
    public void setAutoDeactivate(boolean autoDeactivate) {
        this.autoDeactivate = autoDeactivate;
        if (autoDeactivate && this.active && this.list.isEmpty()) {
            this.active = false;
        }
    }

    private void triggerActivations() {
        org.drools.core.util.Iterator it = this.list.iterator();
        ActivationNode node = (ActivationNode)it.next();
        while (node != null) {
            Activation activation = node.getActivation();
            ((InternalAgendaGroup)activation.getAgendaGroup()).add(activation);
            node = (ActivationNode)it.next();
        }
        ((InternalAgenda)this.workingMemory.getAgenda()).notifyHalt();
    }

    @Override
    public void clear() {
        this.list.clear();
        this.active = false;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void addActivation(Activation activation) {
        assert (activation.getActivationNode() == null);
        ActivationNode node = new ActivationNode(activation, this);
        activation.setActivationNode(node);
        this.list.add(node);
        if (this.active) {
            ((InternalAgendaGroup)activation.getAgendaGroup()).add(activation);
        }
    }

    @Override
    public void removeActivation(Activation activation) {
        ActivationNode node = activation.getActivationNode();
        this.list.remove(node);
        activation.setActivationNode(null);
    }

    @Override
    public void deactivateIfEmpty() {
        if (this.active && this.autoDeactivate && this.list.isEmpty()) {
            DeactivateCallback action = new DeactivateCallback(this);
            this.workingMemory.queueWorkingMemoryAction(action);
        }
    }

    @Override
    public void addRuleFlowGroupListener(RuleFlowGroupListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<RuleFlowGroupListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeRuleFlowGroupListener(RuleFlowGroupListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void notifyRuleFlowGroupListeners() {
        if (this.listeners != null) {
            Iterator<RuleFlowGroupListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().ruleFlowGroupDeactivated();
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Activation[] getActivations() {
        Activation[] activations = new Activation[this.list.size()];
        org.drools.core.util.Iterator it = this.list.iterator();
        int i = 0;
        ActivationNode node = (ActivationNode)it.next();
        while (node != null) {
            activations[i++] = node.getActivation();
            node = (ActivationNode)it.next();
        }
        return activations;
    }

    @Override
    public Iterator iterator() {
        return this.list.javaUtilIterator();
    }

    public String toString() {
        return "RuleFlowGroup '" + this.name + "'";
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RuleFlowGroupImpl)) {
            return false;
        }
        return ((RuleFlowGroupImpl)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void addNodeInstance(Long processInstanceId, String nodeInstanceId) {
        this.nodeInstances.put(processInstanceId, nodeInstanceId);
    }

    @Override
    public void removeNodeInstance(Long processInstanceId, String nodeInstanceId) {
        this.nodeInstances.put(processInstanceId, nodeInstanceId);
    }

    @Override
    public Map<Long, String> getNodeInstances() {
        return this.nodeInstances;
    }

    public static class DeactivateCallback
    implements WorkingMemoryAction {
        private static final long serialVersionUID = 510L;
        private InternalRuleFlowGroup ruleFlowGroup;

        public DeactivateCallback(InternalRuleFlowGroup ruleFlowGroup) {
            this.ruleFlowGroup = ruleFlowGroup;
        }

        public DeactivateCallback(MarshallerReaderContext context) throws IOException {
            this.ruleFlowGroup = (InternalRuleFlowGroup)context.wm.getAgenda().getRuleFlowGroup(context.readUTF());
        }

        public DeactivateCallback(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            this.ruleFlowGroup = (InternalRuleFlowGroup)context.wm.getAgenda().getRuleFlowGroup(_action.getDeactivateCallback().getRuleflowGroup());
        }

        public void write(MarshallerWriteContext context) throws IOException {
            context.writeShort(2);
            context.writeUTF(this.ruleFlowGroup.getName());
        }

        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.DEACTIVATE_CALLBACK).setDeactivateCallback(ProtobufMessages.ActionQueue.DeactivateCallback.newBuilder().setRuleflowGroup(this.ruleFlowGroup.getName()).build()).build();
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.ruleFlowGroup = (InternalRuleFlowGroup)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.ruleFlowGroup);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            if (this.ruleFlowGroup.isEmpty()) {
                this.ruleFlowGroup.setActive(false);
            }
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }
    }
}

