/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Map;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.marshalling.MarshallerFactory;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.ObjectMarshallingStrategyStore;
import org.drools.marshalling.impl.ObjectMarshallingStrategyStoreImpl;
import org.drools.marshalling.impl.ProtobufInputMarshaller;
import org.drools.marshalling.impl.RightTupleKey;
import org.drools.marshalling.impl.TimersInputMarshaller;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RightTuple;
import org.drools.rule.EntryPoint;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshallerReaderContext
extends ObjectInputStream {
    public final MarshallerReaderContext stream = this;
    public final InternalRuleBase ruleBase;
    public InternalWorkingMemory wm;
    public KnowledgeRuntime kruntime;
    public final Map<Integer, BaseNode> sinks;
    public Map<Integer, InternalFactHandle> handles;
    public final Map<RightTupleKey, RightTuple> rightTuples;
    public final Map<Integer, LeftTuple> terminalTupleMap;
    public final ProtobufInputMarshaller.PBActivationsFilter filter;
    public final ObjectMarshallingStrategyStore resolverStrategyFactory;
    public final Map<Integer, ObjectMarshallingStrategy> usedStrategies;
    public final Map<ObjectMarshallingStrategy, ObjectMarshallingStrategy.Context> strategyContexts;
    public final Map<String, EntryPoint> entryPoints;
    public final Map<Integer, TimersInputMarshaller> readersByInt;
    public final Map<Long, PropagationContext> propagationContexts;
    public final boolean marshalProcessInstances;
    public final boolean marshalWorkItems;
    public final Environment env;
    public final Map<Integer, Object> nodeMemories;
    public Object parameterObject;

    public MarshallerReaderContext(InputStream stream, InternalRuleBase ruleBase, Map<Integer, BaseNode> sinks, ObjectMarshallingStrategyStore resolverStrategyFactory, Map<Integer, TimersInputMarshaller> timerReaders, Environment env) throws IOException {
        this(stream, ruleBase, sinks, resolverStrategyFactory, timerReaders, true, true, env);
    }

    public MarshallerReaderContext(InputStream stream, InternalRuleBase ruleBase, Map<Integer, BaseNode> sinks, ObjectMarshallingStrategyStore resolverStrategyFactory, Map<Integer, TimersInputMarshaller> timerReaders, boolean marshalProcessInstances, boolean marshalWorkItems, Environment env) throws IOException {
        super(stream);
        this.ruleBase = ruleBase;
        this.sinks = sinks;
        this.readersByInt = timerReaders;
        this.handles = new HashMap<Integer, InternalFactHandle>();
        this.rightTuples = new HashMap<RightTupleKey, RightTuple>();
        this.terminalTupleMap = new HashMap<Integer, LeftTuple>();
        this.filter = new ProtobufInputMarshaller.PBActivationsFilter();
        this.entryPoints = new HashMap<String, EntryPoint>();
        this.propagationContexts = new HashMap<Long, PropagationContext>();
        if (resolverStrategyFactory == null) {
            ObjectMarshallingStrategy[] strats = (ObjectMarshallingStrategy[])env.get("drools.marshalling.ObjectMarshallingStrategies");
            if (strats == null) {
                strats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()};
            }
            this.resolverStrategyFactory = new ObjectMarshallingStrategyStoreImpl(strats);
        } else {
            this.resolverStrategyFactory = resolverStrategyFactory;
        }
        this.usedStrategies = new HashMap<Integer, ObjectMarshallingStrategy>();
        this.strategyContexts = new HashMap<ObjectMarshallingStrategy, ObjectMarshallingStrategy.Context>();
        this.marshalProcessInstances = marshalProcessInstances;
        this.marshalWorkItems = marshalWorkItems;
        this.env = env;
        this.nodeMemories = new HashMap<Integer, Object>();
        this.parameterObject = null;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        try {
            return Class.forName(name, false, this.ruleBase == null ? null : this.ruleBase.getRootClassLoader());
        }
        catch (ClassNotFoundException ex) {
            return super.resolveClass(desc);
        }
    }
}

