/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BetaConstraints;
import org.drools.common.DefaultBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.LeftTupleIndexHashTable;
import org.drools.core.util.LeftTupleList;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.RightTupleIndexHashTable;
import org.drools.core.util.RightTupleList;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.RightTupleMemory;
import org.drools.rule.ContextEntry;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;

public class QuadroupleBetaConstraints
implements BetaConstraints {
    private static final long serialVersionUID = 510L;
    private BetaNodeFieldConstraint constraint0;
    private BetaNodeFieldConstraint constraint1;
    private BetaNodeFieldConstraint constraint2;
    private BetaNodeFieldConstraint constraint3;
    private boolean indexed0;
    private boolean indexed1;
    private boolean indexed2;
    private boolean indexed3;

    public QuadroupleBetaConstraints() {
    }

    public QuadroupleBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf) {
        this(constraints, conf, false);
    }

    public QuadroupleBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf, boolean disableIndexing) {
        if (disableIndexing || !conf.isIndexLeftBetaMemory() && !conf.isIndexRightBetaMemory()) {
            this.indexed0 = false;
            this.indexed1 = false;
            this.indexed2 = false;
            this.indexed3 = false;
        } else {
            int depth = conf.getCompositeKeyDepth();
            if (!DefaultBetaConstraints.compositeAllowed(constraints)) {
                depth = 1;
            }
            boolean i0 = this.isIndexable(constraints[0]);
            boolean i1 = this.isIndexable(constraints[1]);
            boolean i2 = this.isIndexable(constraints[2]);
            boolean i3 = this.isIndexable(constraints[3]);
            if (depth >= 1 && i0) {
                this.indexed0 = true;
            }
            if (i1) {
                if (depth >= 1 && !this.indexed0) {
                    this.indexed0 = true;
                    this.swap(constraints, 1, 0);
                } else if (depth >= 2) {
                    this.indexed1 = true;
                }
            }
            if (i2) {
                if (depth >= 1 && !this.indexed0) {
                    this.indexed0 = true;
                    this.swap(constraints, 2, 0);
                } else if (depth >= 2 && this.indexed0 && !this.indexed1) {
                    this.indexed1 = true;
                    this.swap(constraints, 2, 1);
                } else if (depth >= 3) {
                    this.indexed2 = true;
                }
            }
            if (i3) {
                if (depth >= 1 && !this.indexed0) {
                    this.indexed0 = true;
                    this.swap(constraints, 3, 0);
                } else if (depth >= 2 && this.indexed0 && !this.indexed1) {
                    this.indexed1 = true;
                    this.swap(constraints, 3, 1);
                } else if (depth >= 3 && this.indexed0 && this.indexed1 && !this.indexed2) {
                    this.indexed2 = true;
                    this.swap(constraints, 3, 2);
                } else if (depth >= 4) {
                    this.indexed3 = true;
                }
            }
        }
        this.constraint0 = constraints[0];
        this.constraint1 = constraints[1];
        this.constraint2 = constraints[2];
        this.constraint3 = constraints[3];
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraint0 = (BetaNodeFieldConstraint)in.readObject();
        this.constraint1 = (BetaNodeFieldConstraint)in.readObject();
        this.constraint2 = (BetaNodeFieldConstraint)in.readObject();
        this.constraint3 = (BetaNodeFieldConstraint)in.readObject();
        this.indexed0 = in.readBoolean();
        this.indexed1 = in.readBoolean();
        this.indexed2 = in.readBoolean();
        this.indexed3 = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.constraint0);
        out.writeObject(this.constraint1);
        out.writeObject(this.constraint2);
        out.writeObject(this.constraint3);
        out.writeBoolean(this.indexed0);
        out.writeBoolean(this.indexed1);
        out.writeBoolean(this.indexed2);
        out.writeBoolean(this.indexed3);
    }

    private void swap(BetaNodeFieldConstraint[] constraints, int p1, int p2) {
        BetaNodeFieldConstraint temp = constraints[p2];
        constraints[p2] = constraints[p1];
        constraints[p1] = temp;
    }

    private boolean isIndexable(BetaNodeFieldConstraint constraint) {
        return DefaultBetaConstraints.isIndexable(constraint);
    }

    public void updateFromTuple(ContextEntry[] context, InternalWorkingMemory workingMemory, LeftTuple tuple) {
        context[0].updateFromTuple(workingMemory, tuple);
        context[1].updateFromTuple(workingMemory, tuple);
        context[2].updateFromTuple(workingMemory, tuple);
        context[3].updateFromTuple(workingMemory, tuple);
    }

    public void updateFromFactHandle(ContextEntry[] context, InternalWorkingMemory workingMemory, InternalFactHandle handle) {
        context[0].updateFromFactHandle(workingMemory, handle);
        context[1].updateFromFactHandle(workingMemory, handle);
        context[2].updateFromFactHandle(workingMemory, handle);
        context[3].updateFromFactHandle(workingMemory, handle);
    }

    public void resetTuple(ContextEntry[] context) {
        context[0].resetTuple();
        context[1].resetTuple();
        context[2].resetTuple();
        context[3].resetTuple();
    }

    public void resetFactHandle(ContextEntry[] context) {
        context[0].resetFactHandle();
        context[1].resetFactHandle();
        context[2].resetFactHandle();
        context[3].resetFactHandle();
    }

    public boolean isAllowedCachedLeft(ContextEntry[] context, InternalFactHandle handle) {
        return !(!this.indexed0 && !this.constraint0.isAllowedCachedLeft(context[0], handle) || !this.indexed1 && !this.constraint1.isAllowedCachedLeft(context[1], handle) || !this.indexed2 && !this.constraint2.isAllowedCachedLeft(context[2], handle) || !this.indexed3 && !this.constraint3.isAllowedCachedLeft(context[3], handle));
    }

    public boolean isAllowedCachedRight(ContextEntry[] context, LeftTuple tuple) {
        return this.constraint0.isAllowedCachedRight(tuple, context[0]) && this.constraint1.isAllowedCachedRight(tuple, context[1]) && this.constraint2.isAllowedCachedRight(tuple, context[2]) && (this.indexed3 || this.constraint3.isAllowedCachedRight(tuple, context[3]));
    }

    public boolean isIndexed() {
        return this.indexed0;
    }

    public int getIndexCount() {
        int count = 0;
        if (this.indexed0) {
            ++count;
        }
        if (this.indexed1) {
            ++count;
        }
        if (this.indexed2) {
            ++count;
        }
        if (this.indexed3) {
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        return false;
    }

    public BetaMemory createBetaMemory(RuleBaseConfiguration conf, short nodeType) {
        BetaMemory memory;
        AbstractHashTable.FieldIndex index;
        VariableConstraint variableConstraint;
        ArrayList<AbstractHashTable.FieldIndex> list = new ArrayList<AbstractHashTable.FieldIndex>(2);
        if (this.indexed0) {
            variableConstraint = (VariableConstraint)this.constraint0;
            index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            list.add(index);
        }
        if (this.indexed1) {
            variableConstraint = (VariableConstraint)this.constraint1;
            index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            list.add(index);
        }
        if (this.indexed2) {
            variableConstraint = (VariableConstraint)this.constraint2;
            index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            list.add(index);
        }
        if (this.indexed3) {
            variableConstraint = (VariableConstraint)this.constraint3;
            index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            list.add(index);
        }
        if (!list.isEmpty()) {
            AbstractHashTable.FieldIndex[] indexes = list.toArray(new AbstractHashTable.FieldIndex[list.size()]);
            LeftTupleMemory tupleMemory = conf.isIndexLeftBetaMemory() ? new LeftTupleIndexHashTable(indexes) : new LeftTupleList();
            RightTupleMemory factHandleMemory = conf.isIndexRightBetaMemory() ? new RightTupleIndexHashTable(indexes) : new RightTupleList();
            memory = new BetaMemory(conf.isSequential() ? null : tupleMemory, factHandleMemory, this.createContext(), nodeType);
        } else {
            memory = new BetaMemory(conf.isSequential() ? null : new LeftTupleList(), new RightTupleList(), this.createContext(), nodeType);
        }
        return memory;
    }

    public int hashCode() {
        return this.constraint0.hashCode() ^ this.constraint1.hashCode() ^ this.constraint2.hashCode() ^ this.constraint3.hashCode();
    }

    public LinkedList getConstraints() {
        LinkedList list = new LinkedList();
        list.add(new LinkedListEntry(this.constraint0));
        list.add(new LinkedListEntry(this.constraint1));
        list.add(new LinkedListEntry(this.constraint2));
        list.add(new LinkedListEntry(this.constraint3));
        return list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof QuadroupleBetaConstraints)) {
            return false;
        }
        QuadroupleBetaConstraints other = (QuadroupleBetaConstraints)object;
        if (this.constraint0 != other.constraint0 && !this.constraint0.equals(other.constraint0)) {
            return false;
        }
        if (this.constraint1 != other.constraint1 && !this.constraint1.equals(other.constraint1)) {
            return false;
        }
        if (this.constraint2 != other.constraint2 && !this.constraint2.equals(other.constraint2)) {
            return false;
        }
        return this.constraint3 == other.constraint3 || this.constraint3.equals(other.constraint3);
    }

    public ContextEntry[] createContext() {
        return new ContextEntry[]{this.constraint0.createContextEntry(), this.constraint1.createContextEntry(), this.constraint2.createContextEntry(), this.constraint3.createContextEntry()};
    }

    public BetaConstraints getOriginalConstraint() {
        throw new UnsupportedOperationException();
    }
}

