/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel;

import org.drools.factmodel.BeanClassBuilder;
import org.drools.factmodel.ClassBuilder;
import org.drools.factmodel.traits.TraitClassBuilder;
import org.drools.factmodel.traits.TraitClassBuilderImpl;
import org.drools.factmodel.traits.TraitCoreWrapperClassBuilder;
import org.drools.factmodel.traits.TraitCoreWrapperClassBuilderImpl;
import org.drools.factmodel.traits.TraitPropertyWrapperClassBuilder;
import org.drools.factmodel.traits.TraitPropertyWrapperClassBuilderImpl;
import org.drools.factmodel.traits.TraitProxyClassBuilder;
import org.drools.factmodel.traits.TraitProxyClassBuilderImpl;
import org.drools.util.ServiceRegistryImpl;

public class ClassBuilderFactory {
    private static BeanClassBuilder beanClassBuilderProvider;
    private static TraitClassBuilder traitBuilderProvider;
    private static ClassBuilder propertyWrapperBuilderProvider;
    private static TraitProxyClassBuilder traitProxyBuilderProvider;
    private static TraitCoreWrapperClassBuilder traitCoreWrapperBuilderProvider;

    public static synchronized ClassBuilder getBeanClassBuilderService() {
        if (beanClassBuilderProvider == null) {
            ClassBuilderFactory.loadBeanClassBuilderProvider();
        }
        return beanClassBuilderProvider;
    }

    public static synchronized void setBeanClassBuilderService(BeanClassBuilder provider) {
        beanClassBuilderProvider = provider;
    }

    private static void loadBeanClassBuilderProvider() {
        String defaultName = "org.drools.factmodel.DefaultBeanClassBuilder";
        try {
            ServiceRegistryImpl.getInstance().addDefault(BeanClassBuilder.class, defaultName);
            ClassBuilderFactory.setBeanClassBuilderService((BeanClassBuilder)ServiceRegistryImpl.getInstance().get(BeanClassBuilder.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized ClassBuilder getTraitBuilderService() {
        if (traitBuilderProvider == null) {
            ClassBuilderFactory.loadTraitBuilderProvider();
        }
        return traitBuilderProvider;
    }

    public static synchronized void setTraitBuilderService(TraitClassBuilder provider) {
        traitBuilderProvider = provider;
    }

    private static void loadTraitBuilderProvider() {
        ServiceRegistryImpl.getInstance().addDefault(TraitClassBuilder.class, "org.drools.factmodel.traits.TraitClassBuilderImpl");
        ClassBuilderFactory.setTraitBuilderService((TraitClassBuilder)ServiceRegistryImpl.getInstance().get(TraitClassBuilder.class));
    }

    public static synchronized ClassBuilder getPropertyWrapperBuilderService() {
        if (propertyWrapperBuilderProvider == null) {
            ClassBuilderFactory.loadPropertyWrapperClassBuilderProvider();
        }
        return propertyWrapperBuilderProvider;
    }

    public static synchronized void setPropertyWrapperBuilderService(TraitPropertyWrapperClassBuilder provider) {
        propertyWrapperBuilderProvider = provider;
    }

    private static void loadPropertyWrapperClassBuilderProvider() {
        try {
            ServiceRegistryImpl.getInstance().addDefault(TraitPropertyWrapperClassBuilder.class, "org.drools.factmodel.TraitPropertyWrapperClassBuilderImpl");
            ClassBuilderFactory.setPropertyWrapperBuilderService((TraitPropertyWrapperClassBuilder)ServiceRegistryImpl.getInstance().get(TraitPropertyWrapperClassBuilder.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized ClassBuilder getTraitProxyBuilderService() {
        if (traitProxyBuilderProvider == null) {
            ClassBuilderFactory.loadTraitProxyClassBuilderProvider();
        }
        return traitProxyBuilderProvider;
    }

    public static synchronized void setTraitProxyBuilderService(TraitProxyClassBuilder provider) {
        traitProxyBuilderProvider = provider;
    }

    private static void loadTraitProxyClassBuilderProvider() {
        try {
            ServiceRegistryImpl.getInstance().addDefault(TraitProxyClassBuilder.class, "org.drools.factmodel.TraitProxyClassBuilderImpl");
            ClassBuilderFactory.setTraitProxyBuilderService((TraitProxyClassBuilder)ServiceRegistryImpl.getInstance().get(TraitProxyClassBuilder.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized TraitCoreWrapperClassBuilder getTraitCoreWrapperBuilderService() {
        if (traitCoreWrapperBuilderProvider == null) {
            ClassBuilderFactory.loadTraitCoreWrapperClassBuilderProvider();
        }
        return traitCoreWrapperBuilderProvider;
    }

    public static synchronized void setTraitCoreWrapperBuilderService(TraitCoreWrapperClassBuilder provider) {
        traitCoreWrapperBuilderProvider = provider;
    }

    private static void loadTraitCoreWrapperClassBuilderProvider() {
        try {
            ServiceRegistryImpl.getInstance().addDefault(TraitCoreWrapperClassBuilder.class, "org.drools.factmodel.TraitCoreWrapperClassBuilderImpl");
            ClassBuilderFactory.setTraitCoreWrapperBuilderService((TraitCoreWrapperClassBuilder)ServiceRegistryImpl.getInstance().get(TraitCoreWrapperClassBuilder.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        traitBuilderProvider = new TraitClassBuilderImpl();
        propertyWrapperBuilderProvider = new TraitPropertyWrapperClassBuilderImpl();
        traitProxyBuilderProvider = new TraitProxyClassBuilderImpl();
        traitCoreWrapperBuilderProvider = new TraitCoreWrapperClassBuilderImpl();
    }
}

