/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Arrays;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.core.util.Entry;
import org.drools.core.util.LeftTupleList;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.RightTuple;
import org.drools.rule.Declaration;
import org.drools.spi.Tuple;

public class NotNodeLeftTuple
implements Tuple,
Entry,
LeftTuple {
    private static final long serialVersionUID = 510L;
    private int index;
    private InternalFactHandle handle;
    private LeftTuple parent;
    private RightTuple blocker;
    private LeftTuple blockedPrevious;
    private LeftTuple blockedNext;
    private LeftTuple leftParent;
    private LeftTuple leftParentPrevious;
    private LeftTuple leftParentNext;
    private RightTuple rightParent;
    private LeftTuple rightParentPrevious;
    private LeftTuple rightParentNext;
    private LeftTupleList memory;
    private Entry next;
    private Entry previous;
    private LeftTuple firstChild;
    private LeftTuple lastChild;
    private LeftTupleSink sink;

    public NotNodeLeftTuple() {
    }

    public NotNodeLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this.handle = factHandle;
        if (leftTupleMemoryEnabled) {
            LeftTuple first = this.handle.getLastLeftTuple();
            if (first == null) {
                this.handle.setFirstLeftTuple(this);
                this.handle.setLastLeftTuple(this);
            } else {
                this.leftParentPrevious = this.handle.getLastLeftTuple();
                this.leftParentPrevious.setLeftParentNext(this);
                this.handle.setLastLeftTuple(this);
            }
        }
        this.sink = sink;
    }

    public NotNodeLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this.index = leftTuple.getIndex();
        this.parent = leftTuple.getParent();
        this.handle = leftTuple.getHandle();
        if (leftTupleMemoryEnabled) {
            this.leftParent = leftTuple;
            if (leftTuple.getLastChild() != null) {
                this.leftParentPrevious = leftTuple.getLastChild();
                this.leftParentPrevious.setLeftParentNext(this);
            } else {
                leftTuple.setFirstChild(this);
            }
            leftTuple.setLastChild(this);
        }
        this.sink = sink;
    }

    public NotNodeLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        this.index = leftTuple.getIndex() + 1;
        this.parent = leftTuple;
        this.handle = rightTuple.getFactHandle();
        this.leftParent = leftTuple;
        if (leftTuple.getLastChild() != null) {
            this.leftParentPrevious = leftTuple.getLastChild();
            this.leftParentPrevious.setLeftParentNext(this);
        } else {
            leftTuple.setFirstChild(this);
        }
        leftTuple.setLastChild(this);
        this.rightParent = rightTuple;
        if (rightTuple.lastChild != null) {
            this.rightParentPrevious = rightTuple.lastChild;
            this.rightParentPrevious.setRightParentNext(this);
        } else {
            rightTuple.firstChild = this;
        }
        rightTuple.lastChild = this;
        this.sink = sink;
    }

    public NotNodeLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this(leftTuple, rightTuple, null, null, sink, leftTupleMemoryEnabled);
    }

    public NotNodeLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this.handle = rightTuple.getFactHandle();
        this.index = leftTuple.getIndex() + 1;
        this.parent = leftTuple;
        if (leftTupleMemoryEnabled) {
            this.leftParent = leftTuple;
            this.rightParent = rightTuple;
            if (currentLeftChild == null) {
                if (leftTuple.getLastChild() != null) {
                    this.leftParentPrevious = leftTuple.getLastChild();
                    this.leftParentPrevious.setLeftParentNext(this);
                } else {
                    leftTuple.setFirstChild(this);
                }
                leftTuple.setLastChild(this);
            } else {
                this.leftParentNext = currentLeftChild;
                this.leftParentPrevious = currentLeftChild.getLeftParentPrevious();
                currentLeftChild.setLeftParentPrevious(this);
                if (this.leftParentPrevious == null) {
                    this.leftParent.setFirstChild(this);
                } else {
                    this.leftParentPrevious.setLeftParentNext(this);
                }
            }
            if (currentRightChild == null) {
                if (rightTuple.lastChild != null) {
                    this.rightParentPrevious = rightTuple.lastChild;
                    this.rightParentPrevious.setRightParentNext(this);
                } else {
                    rightTuple.firstChild = this;
                }
                rightTuple.lastChild = this;
            } else {
                this.rightParentNext = currentRightChild;
                this.rightParentPrevious = currentRightChild.getRightParentPrevious();
                currentRightChild.setRightParentPrevious(this);
                if (this.rightParentPrevious == null) {
                    this.rightParent.firstChild = this;
                } else {
                    this.rightParentPrevious.setRightParentNext(this);
                }
            }
        }
        this.sink = sink;
    }

    public void reAdd() {
        LeftTuple first = this.handle.getLastLeftTuple();
        if (first == null) {
            this.handle.setFirstLeftTuple(this);
            this.handle.setLastLeftTuple(this);
        } else {
            this.handle.getLastLeftTuple().setLeftParentNext(this);
            this.leftParentPrevious = this.handle.getLastLeftTuple();
            this.handle.setLastLeftTuple(this);
        }
    }

    public void reAddLeft() {
        if (this.leftParentNext != null) {
            if (this.leftParentPrevious != null) {
                this.leftParentPrevious.setLeftParentNext(this.leftParentNext);
                this.leftParentNext.setLeftParentPrevious(this.leftParentPrevious);
            } else {
                if (this.leftParent.getFirstChild() == this) {
                    this.leftParent.setFirstChild(this.leftParentNext);
                }
                this.leftParentNext.setLeftParentPrevious(null);
            }
            this.leftParentPrevious = this.leftParent.getLastChild();
            this.leftParentPrevious.setLeftParentNext(this);
            this.leftParent.setLastChild(this);
            this.leftParentNext = null;
        }
    }

    public void reAddRight() {
        if (this.rightParentNext != null) {
            if (this.rightParentPrevious != null) {
                this.rightParentPrevious.setRightParentNext(this.rightParentNext);
                this.rightParentNext.setRightParentPrevious(this.rightParentPrevious);
            } else {
                if (this.rightParent.firstChild == this) {
                    this.rightParent.firstChild = this.rightParentNext;
                }
                this.rightParentNext.setRightParentPrevious(null);
            }
            this.rightParentPrevious = this.rightParent.lastChild;
            this.rightParentPrevious.setRightParentNext(this);
            this.rightParent.lastChild = this;
            this.rightParentNext = null;
        }
    }

    public void unlinkFromLeftParent() {
        LeftTuple previousParent = this.leftParentPrevious;
        LeftTuple nextParent = this.leftParentNext;
        if (previousParent != null && nextParent != null) {
            this.leftParentPrevious.setLeftParentNext(nextParent);
            this.leftParentNext.setLeftParentPrevious(previousParent);
        } else if (nextParent != null) {
            if (this.leftParent != null) {
                this.leftParent.setFirstChild(nextParent);
            } else {
                this.handle.setFirstLeftTuple(nextParent);
            }
            nextParent.setLeftParentPrevious(null);
        } else if (previousParent != null) {
            if (this.leftParent != null) {
                this.leftParent.setLastChild(previousParent);
            } else {
                this.handle.setLastLeftTuple(previousParent);
            }
            previousParent.setLeftParentNext(null);
        } else if (this.leftParent != null) {
            this.leftParent.setFirstChild(null);
            this.leftParent.setLastChild(null);
        } else {
            this.handle.setFirstLeftTuple(null);
            this.handle.setLastLeftTuple(null);
        }
        this.leftParent = null;
        this.leftParentPrevious = null;
        this.leftParentNext = null;
        this.blocker = null;
    }

    public void unlinkFromRightParent() {
        if (this.rightParent == null) {
            return;
        }
        LeftTuple previousParent = this.rightParentPrevious;
        LeftTuple nextParent = this.rightParentNext;
        if (previousParent != null && nextParent != null) {
            this.rightParentPrevious.setRightParentNext(this.rightParentNext);
            this.rightParentNext.setRightParentPrevious(this.rightParentPrevious);
        } else if (nextParent != null) {
            this.rightParent.firstChild = nextParent;
            nextParent.setRightParentPrevious(null);
        } else if (previousParent != null) {
            this.rightParent.lastChild = previousParent;
            previousParent.setRightParentNext(null);
        } else {
            this.rightParent.firstChild = null;
            this.rightParent.lastChild = null;
        }
        this.blocker = null;
        this.rightParent = null;
        this.rightParentPrevious = null;
        this.rightParentNext = null;
    }

    public int getIndex() {
        return this.index;
    }

    public LeftTupleSink getLeftTupleSink() {
        return this.sink;
    }

    public void setLeftTupleSink(LeftTupleSink sink) {
        this.sink = sink;
    }

    public LeftTuple getLeftParent() {
        return this.leftParent;
    }

    public void setLeftParent(LeftTuple leftParent) {
        this.leftParent = leftParent;
    }

    public LeftTuple getLeftParentPrevious() {
        return this.leftParentPrevious;
    }

    public void setLeftParentPrevious(LeftTuple leftParentLeft) {
        this.leftParentPrevious = leftParentLeft;
    }

    public LeftTuple getLeftParentNext() {
        return this.leftParentNext;
    }

    public void setLeftParentNext(LeftTuple leftParentright) {
        this.leftParentNext = leftParentright;
    }

    public RightTuple getRightParent() {
        return this.rightParent;
    }

    public void setRightParent(RightTuple rightParent) {
        this.rightParent = rightParent;
    }

    public LeftTuple getRightParentPrevious() {
        return this.rightParentPrevious;
    }

    public void setRightParentPrevious(LeftTuple rightParentLeft) {
        this.rightParentPrevious = rightParentLeft;
    }

    public LeftTuple getRightParentNext() {
        return this.rightParentNext;
    }

    public void setRightParentNext(LeftTuple rightParentRight) {
        this.rightParentNext = rightParentRight;
    }

    public InternalFactHandle get(int index) {
        LeftTuple entry = this;
        while (entry.getIndex() != index) {
            entry = entry.getParent();
        }
        return entry.getHandle();
    }

    public void setFactHandle(InternalFactHandle handle) {
        this.handle = handle;
    }

    public LeftTupleList getMemory() {
        return this.memory;
    }

    public void setMemory(LeftTupleList memory) {
        this.memory = memory;
    }

    public Entry getPrevious() {
        return this.previous;
    }

    public void setPrevious(Entry previous) {
        this.previous = previous;
    }

    public void setNext(Entry next) {
        this.next = next;
    }

    public Entry getNext() {
        return this.next;
    }

    public InternalFactHandle getLastHandle() {
        return this.handle;
    }

    public InternalFactHandle get(Declaration declaration) {
        return this.get(declaration.getPattern().getOffset());
    }

    public InternalFactHandle[] getFactHandles() {
        InternalFactHandle[] handles = new InternalFactHandle[this.index + 1];
        int i = 0;
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            handles[i++] = entry.getHandle();
        }
        return handles;
    }

    public InternalFactHandle[] toFactHandles() {
        InternalFactHandle[] handles = new InternalFactHandle[this.index + 1];
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            handles[entry.getIndex()] = entry.getHandle();
        }
        return handles;
    }

    public void setBlocker(RightTuple blocker) {
        this.blocker = blocker;
    }

    public RightTuple getBlocker() {
        return this.blocker;
    }

    public LeftTuple getBlockedPrevious() {
        return this.blockedPrevious;
    }

    public void setBlockedPrevious(LeftTuple blockerPrevious) {
        this.blockedPrevious = blockerPrevious;
    }

    public LeftTuple getBlockedNext() {
        return this.blockedNext;
    }

    public void setBlockedNext(LeftTuple blockerNext) {
        this.blockedNext = blockerNext;
    }

    public Object getObject() {
        throw new UnsupportedOperationException();
    }

    public void setObject(Object object) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            buffer.append(entry.getHandle()).append("\n");
        }
        return buffer.toString();
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public boolean equals(LeftTuple other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.hashCode() != ((Object)other).hashCode()) {
            return false;
        }
        if (this.handle != other.getHandle()) {
            return false;
        }
        if (this.parent == null) {
            return other.getParent() == null;
        }
        return this.parent.equals(other.getParent());
    }

    public boolean equals(Object object) {
        return this.equals((LeftTuple)object);
    }

    public int size() {
        return this.index + 1;
    }

    public InternalFactHandle getHandle() {
        return this.handle;
    }

    public void setHandle(InternalFactHandle handle) {
        this.handle = handle;
    }

    public LeftTuple getFirstChild() {
        return this.firstChild;
    }

    public void setFirstChild(LeftTuple firstChild) {
        this.firstChild = firstChild;
    }

    public LeftTuple getLastChild() {
        return this.lastChild;
    }

    public void setLastChild(LeftTuple lastChild) {
        this.lastChild = lastChild;
    }

    public LeftTupleSink getSink() {
        return this.sink;
    }

    public void setSink(LeftTupleSink sink) {
        this.sink = sink;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setParent(LeftTuple parent) {
        this.parent = parent;
    }

    public LeftTuple getSubTuple(int elements) {
        LeftTuple entry = this;
        if (elements < this.size()) {
            int lastindex = elements - 1;
            while (entry.getIndex() != lastindex) {
                entry = entry.getParent();
            }
        }
        return entry;
    }

    public Object[] toObjectArray() {
        Object[] objects = new Object[this.index + 1];
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            Object object;
            objects[entry.getIndex()] = object = entry.getLastHandle().getObject();
        }
        return objects;
    }

    public LeftTuple getParent() {
        return this.parent;
    }

    public String toTupleTree(int indent) {
        StringBuilder buf = new StringBuilder();
        char[] spaces = new char[indent];
        Arrays.fill(spaces, ' ');
        String istr = new String(spaces);
        buf.append(istr);
        buf.append(this.toExternalString());
        buf.append("\n");
        for (LeftTuple leftTuple = this.firstChild; leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
            buf.append(leftTuple.toTupleTree(indent + 4));
        }
        return buf.toString();
    }

    private String toExternalString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%08X", System.identityHashCode(this))).append(":");
        int[] ids = new int[this.index + 1];
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            ids[entry.getIndex()] = entry.getLastHandle().getId();
        }
        builder.append(Arrays.toString(ids)).append(" activation=").append(" sink=").append(this.sink.getClass().getSimpleName()).append("(").append(this.sink.getId()).append(")");
        return builder.toString();
    }

    public void increaseActivationCountForEvents() {
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            if (!entry.getLastHandle().isEvent()) continue;
            ((EventFactHandle)entry.getLastHandle()).increaseActivationsCount();
        }
    }

    public void decreaseActivationCountForEvents() {
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            if (!entry.getLastHandle().isEvent()) continue;
            ((EventFactHandle)entry.getLastHandle()).decreaseActivationsCount();
        }
    }
}

