/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.runtime.rule;

import java.util.Collection;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.common.DefaultFactHandle;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetFactHandlesCommand
implements GenericCommand<Collection<FactHandle>> {
    private ObjectFilter filter = null;
    private boolean disconnected = false;

    public GetFactHandlesCommand() {
    }

    public GetFactHandlesCommand(ObjectFilter filter) {
        this.filter = filter;
    }

    public GetFactHandlesCommand(ObjectFilter filter, boolean disconnected) {
        this.filter = filter;
        this.disconnected = disconnected;
    }

    @Override
    public Collection<FactHandle> execute(Context context) {
        StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
        if (this.filter != null) {
            Collection factHandles = ksession.getFactHandles(this.filter);
            if (factHandles != null && this.disconnected) {
                for (FactHandle factHandle : factHandles) {
                    ((DefaultFactHandle)factHandle).disconnect();
                }
            }
            return factHandles;
        }
        Collection factHandles = ksession.getFactHandles();
        if (factHandles != null && this.disconnected) {
            for (FactHandle factHandle : factHandles) {
                ((DefaultFactHandle)factHandle).disconnect();
            }
        }
        return factHandles;
    }

    public String toString() {
        if (this.filter != null) {
            return "new ObjectStoreWrapper( reteooStatefulSession.getObjectStore(), null, ObjectStoreWrapper.FACT_HANDLE )";
        }
        return "new ObjectStoreWrapper( reteooStatefulSession.getObjectStore(), filter, ObjectStoreWrapper.FACT_HANDLE )";
    }
}

