/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.drools.reteoo.TupleSinkNode;

public class TupleSinkNodeList
implements Serializable {
    private static final long serialVersionUID = 400L;
    private TupleSinkNode firstNode;
    private TupleSinkNode lastNode;
    private int size;

    public void add(TupleSinkNode node) {
        if (this.firstNode == null) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            this.lastNode.setNextTupleSinkNode(node);
            node.setPreviousTupleSinkNode(this.lastNode);
            this.lastNode = node;
        }
        ++this.size;
    }

    public void remove(TupleSinkNode node) {
        if (this.firstNode != node && this.lastNode != node) {
            node.getPreviousTupleSinkNode().setNextTupleSinkNode(node.getNextTupleSinkNode());
            node.getNextTupleSinkNode().setPreviousTupleSinkNode(node.getPreviousTupleSinkNode());
            --this.size;
            node.setPreviousTupleSinkNode(null);
            node.setNextTupleSinkNode(null);
        } else if (this.firstNode == node) {
            this.removeFirst();
        } else if (this.lastNode == node) {
            this.removeLast();
        }
    }

    public final TupleSinkNode getFirst() {
        return this.firstNode;
    }

    public final TupleSinkNode getLast() {
        return this.lastNode;
    }

    public TupleSinkNode removeFirst() {
        if (this.firstNode == null) {
            return null;
        }
        TupleSinkNode node = this.firstNode;
        this.firstNode = node.getNextTupleSinkNode();
        node.setNextTupleSinkNode(null);
        if (this.firstNode != null) {
            this.firstNode.setPreviousTupleSinkNode(null);
        } else {
            this.lastNode = null;
        }
        --this.size;
        return node;
    }

    public TupleSinkNode removeLast() {
        if (this.lastNode == null) {
            return null;
        }
        TupleSinkNode node = this.lastNode;
        this.lastNode = node.getPreviousTupleSinkNode();
        node.setPreviousTupleSinkNode(null);
        if (this.lastNode != null) {
            this.lastNode.setNextTupleSinkNode(null);
        } else {
            this.firstNode = this.lastNode;
        }
        --this.size;
        return node;
    }

    public final boolean isEmpty() {
        return this.firstNode == null;
    }

    public void clear() {
        while (this.removeFirst() != null) {
        }
    }

    public final int size() {
        return this.size;
    }

    public Iterator iterator() {
        return new Iterator(){
            private TupleSinkNode currentNode = null;
            private TupleSinkNode nextNode = TupleSinkNodeList.this.getFirst();

            public boolean hasNext() {
                return this.nextNode != null;
            }

            public Object next() {
                this.currentNode = this.nextNode;
                if (this.currentNode == null) {
                    throw new NoSuchElementException("No more elements to return");
                }
                this.nextNode = this.currentNode.getNextTupleSinkNode();
                return this.currentNode;
            }

            public void remove() {
                if (this.currentNode == null) {
                    throw new IllegalStateException("No item to remove. Call next() before calling remove().");
                }
                TupleSinkNodeList.this.remove(this.currentNode);
                this.currentNode = null;
            }
        };
    }
}

