/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.math.BigInteger;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.BaseMemberOfEvaluator;
import org.drools.base.evaluators.BaseNotMemberOfEvaluator;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;

public class BigIntegerFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = 400L;
    private static EvaluatorFactory INSTANCE = new BigIntegerFactory();

    private BigIntegerFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BigIntegerFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return BigIntegerEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return BigIntegerNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS) {
            return BigIntegerLessEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS_OR_EQUAL) {
            return BigIntegerLessOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER) {
            return BigIntegerGreaterEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER_OR_EQUAL) {
            return BigIntegerGreaterOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return BigIntegerMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return BigIntegerNotMemberOfEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for BigIntegerEvaluator");
    }

    static class BigIntegerNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerNotMemberOfEvaluator();

        private BigIntegerNotMemberOfEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.NOTMEMBEROF);
        }

        public String toString() {
            return "BigInteger not memberOf";
        }
    }

    static class BigIntegerMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerMemberOfEvaluator();

        private BigIntegerMemberOfEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.MEMBEROF);
        }

        public String toString() {
            return "BigInteger memberOf";
        }
    }

    static class BigIntegerGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new BigIntegerGreaterOrEqualEvaluator();

        private BigIntegerGreaterOrEqualEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = (BigInteger)extractor.getValue(workingMemory, object1);
            return comp.compareTo((BigInteger)object2.getValue()) >= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigInteger comp = (BigInteger)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comp.compareTo((BigInteger)context.declaration.getExtractor().getValue(workingMemory, left)) >= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigInteger comp = (BigInteger)context.extractor.getValue(workingMemory, right);
            return comp.compareTo((BigInteger)((VariableRestriction.ObjectVariableContextEntry)context).left) >= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = (BigInteger)extractor1.getValue(workingMemory, object1);
            return comp.compareTo((BigInteger)extractor2.getValue(workingMemory, object2)) >= 0;
        }

        public String toString() {
            return "BigInteger >=";
        }
    }

    static class BigIntegerGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerGreaterEvaluator();

        private BigIntegerGreaterEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = (BigInteger)extractor.getValue(workingMemory, object1);
            return comp.compareTo((BigInteger)object2.getValue()) > 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigInteger comp = (BigInteger)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comp.compareTo((BigInteger)context.declaration.getExtractor().getValue(workingMemory, left)) > 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigInteger comp = (BigInteger)context.extractor.getValue(workingMemory, right);
            return comp.compareTo((BigInteger)((VariableRestriction.ObjectVariableContextEntry)context).left) > 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = (BigInteger)extractor1.getValue(workingMemory, object1);
            return comp.compareTo((BigInteger)extractor2.getValue(workingMemory, object2)) > 0;
        }

        public String toString() {
            return "BigInteger >";
        }
    }

    static class BigIntegerLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerLessOrEqualEvaluator();

        private BigIntegerLessOrEqualEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = (BigInteger)extractor.getValue(workingMemory, object1);
            return comp.compareTo((BigInteger)object2.getValue()) <= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigInteger comp = (BigInteger)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comp.compareTo((BigInteger)context.declaration.getExtractor().getValue(workingMemory, left)) <= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigInteger comp = (BigInteger)context.extractor.getValue(workingMemory, right);
            return comp.compareTo((BigInteger)((VariableRestriction.ObjectVariableContextEntry)context).left) <= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = (BigInteger)extractor1.getValue(workingMemory, object1);
            return comp.compareTo((BigInteger)extractor2.getValue(workingMemory, object2)) <= 0;
        }

        public String toString() {
            return "BigInteger <=";
        }
    }

    static class BigIntegerLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerLessEvaluator();

        private BigIntegerLessEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = (BigInteger)extractor.getValue(workingMemory, object1);
            return comp.compareTo((BigInteger)object2.getValue()) < 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigInteger comp = (BigInteger)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comp.compareTo((BigInteger)context.declaration.getExtractor().getValue(workingMemory, left)) < 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigInteger comp = (BigInteger)context.extractor.getValue(workingMemory, right);
            return comp.compareTo((BigInteger)((VariableRestriction.ObjectVariableContextEntry)context).left) < 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = (BigInteger)extractor1.getValue(workingMemory, object1);
            return comp.compareTo((BigInteger)extractor2.getValue(workingMemory, object2)) < 0;
        }

        public String toString() {
            return "BigInteger <";
        }
    }

    static class BigIntegerNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerNotEqualEvaluator();

        private BigIntegerNotEqualEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right != null;
            }
            return !value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value != null;
            }
            return !((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public String toString() {
            return "BigInteger !=";
        }
    }

    static class BigIntegerEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerEqualEvaluator();

        private BigIntegerEqualEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right == null;
            }
            return value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value == null;
            }
            return ((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public String toString() {
            return "BigInteger ==";
        }
    }
}

