/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.drools.base.ClassFieldExtractor;
import org.drools.base.ClassFieldExtractorFactory;

public class ClassFieldExtractorCache {
    private static final ClassFieldExtractorCache INSTANCE = new ClassFieldExtractorCache();
    private Map cache;
    private ClassFieldExtractorFactory factory = new ClassFieldExtractorFactory();

    private ClassFieldExtractorCache() {
    }

    public static ClassFieldExtractorCache getInstance() {
        return new ClassFieldExtractorCache();
    }

    public synchronized ClassFieldExtractor getExtractor(Class clazz, String fieldName, ClassLoader classLoader) {
        ExtractorKey key;
        if (this.cache == null) {
            this.cache = new HashMap();
        }
        if (this.cache.containsKey(key = new ExtractorKey(clazz, fieldName))) {
            return (ClassFieldExtractor)this.cache.get(key);
        }
        ClassFieldExtractor ex = new ClassFieldExtractor(clazz, fieldName, classLoader, this.factory);
        this.cache.put(key, ex);
        return ex;
    }

    private static class ExtractorKey
    implements Serializable {
        private static final long serialVersionUID = 400L;
        private final Class clazz;
        private final String fieldName;
        private final int hashCode;

        public ExtractorKey(Class clazz, String fieldName) {
            this.clazz = clazz;
            this.fieldName = fieldName;
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (clazz == null ? 0 : clazz.hashCode());
            this.hashCode = result = 31 * result + (fieldName == null ? 0 : fieldName.hashCode());
        }

        public Class getClazz() {
            return this.clazz;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExtractorKey other = (ExtractorKey)obj;
            if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                return false;
            }
            return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
        }

        public String toString() {
            return this.clazz + "@" + Math.abs(System.identityHashCode(this.clazz)) + "(" + this.fieldName + ")";
        }
    }
}

