/*
 * Decompiled with CFR 0.152.
 */
package org.drools.visualize;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.ConstantVertexAspectRatioFunction;
import edu.uci.ics.jung.graph.decorators.ConstantVertexSizeFunction;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EdgeShapeFunction;
import edu.uci.ics.jung.graph.decorators.EllipseVertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.PickableEdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.ToolTipFunction;
import edu.uci.ics.jung.graph.decorators.VertexAspectRatioFunction;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexSizeFunction;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.visualization.DefaultGraphLabelRenderer;
import edu.uci.ics.jung.visualization.GraphLabelRenderer;
import edu.uci.ics.jung.visualization.GraphMouseListener;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PickedInfo;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.CrossoverScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PluggableGraphMouse;
import edu.uci.ics.jung.visualization.control.RotatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.control.ViewScalingGraphMousePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.drools.RuleBase;
import org.drools.reteoo.ReteooToJungVisitor;
import org.drools.visualize.ReteooJungViewer;
import org.drools.visualize.ReteooLayout;
import org.drools.visualize.ReteooLayoutSolver;
import org.drools.visualize.VertexFunctions;

public class ReteooJungViewerPanel
extends JPanel {
    private static final long serialVersionUID = 73294554831916314L;
    private Graph graph;
    private VisualizationViewer vv;

    public ReteooJungViewerPanel(RuleBase ruleBase) {
        this.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel(new BorderLayout());
        JPanel rightPanel = new JPanel(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1, leftPanel, rightPanel);
        splitPane.setDividerLocation(0.75);
        splitPane.setResizeWeight(1.0);
        this.add(splitPane);
        this.graph = new DirectedSparseGraph();
        ReteooToJungVisitor visitor = new ReteooToJungVisitor(this.graph);
        visitor.visit(ruleBase);
        PluggableRenderer pr = new PluggableRenderer();
        pr.setEdgeShapeFunction((EdgeShapeFunction)new EdgeShape.QuadCurve());
        pr.setVertexPaintFunction(new VertexPaintFunction(){

            public Paint getFillPaint(Vertex v) {
                return ((ReteooJungViewer.DroolsVertex)v).getFillPaint();
            }

            public Paint getDrawPaint(Vertex v) {
                return ((ReteooJungViewer.DroolsVertex)v).getDrawPaint();
            }
        });
        pr.setEdgePaintFunction((EdgePaintFunction)new PickableEdgePaintFunction((PickedInfo)pr, (Paint)Color.black, (Paint)Color.cyan));
        pr.setGraphLabelRenderer((GraphLabelRenderer)new DefaultGraphLabelRenderer(Color.cyan, Color.cyan));
        pr.setVertexShapeFunction((VertexShapeFunction)new EllipseVertexShapeFunction((VertexSizeFunction)new ConstantVertexSizeFunction(14), (VertexAspectRatioFunction)new ConstantVertexAspectRatioFunction(1.0f)));
        ReteooLayoutSolver solver = new ReteooLayoutSolver(visitor.getRootVertex());
        ReteooLayout layout = new ReteooLayout(this.graph, new VertexFunctions(), solver.getRowList());
        this.vv = new VisualizationViewer((Layout)layout, (Renderer)pr);
        this.vv.setBackground(Color.white);
        this.vv.setPickSupport((PickSupport)new ShapePickSupport());
        this.vv.setToolTipFunction((ToolTipFunction)new DefaultToolTipFunction());
        PluggableGraphMouse graphMouse = new PluggableGraphMouse();
        graphMouse.add((GraphMousePlugin)new PickingGraphMousePlugin());
        graphMouse.add((GraphMousePlugin)new ViewScalingGraphMousePlugin());
        graphMouse.add((GraphMousePlugin)new CrossoverScalingGraphMousePlugin());
        graphMouse.add((GraphMousePlugin)new RotatingGraphMousePlugin());
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            private final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(ReteooJungViewerPanel.this.vv, 1.1f, ReteooJungViewerPanel.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            private final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(ReteooJungViewerPanel.this.vv, 0.9f, ReteooJungViewerPanel.this.vv.getCenter());
            }
        });
        GraphZoomScrollPane graphPanel = new GraphZoomScrollPane(this.vv);
        graphPanel.scrollRectToVisible(new Rectangle(1, 1, 1, 1));
        leftPanel.add((Component)graphPanel);
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(scaleGrid);
        leftPanel.add((Component)controls, "South");
        final JEditorPane infoPane = new JEditorPane();
        infoPane.setEditable(false);
        infoPane.setContentType("text/html");
        JScrollPane infoScrollPane = new JScrollPane(infoPane);
        infoScrollPane.setPreferredSize(new Dimension(150, 10));
        infoScrollPane.setMinimumSize(new Dimension(150, 10));
        this.vv.addGraphMouseListener(new GraphMouseListener(){

            public void graphClicked(Vertex vertex, MouseEvent e) {
                infoPane.setText(((ReteooJungViewer.DroolsVertex)vertex).getHtml());
            }

            public void graphPressed(Vertex vertex, MouseEvent e) {
            }

            public void graphReleased(Vertex vertex, MouseEvent e) {
            }
        });
        rightPanel.add(infoScrollPane);
    }
}

