/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.asm;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.drools.asm.ClassWriter;
import org.drools.asm.Label;
import org.drools.asm.MethodVisitor;
import org.drools.asm.Opcodes;
import org.drools.asm.Type;
import org.drools.util.asm.ClassFieldInspector;
import org.drools.util.asm.FieldAccessor;
import org.drools.util.asm.FieldAccessorMap;

public class FieldAccessorGenerator {
    private static FieldAccessorGenerator INSTANCE;
    private static final String GEN_PACKAGE_PREFIX = "org.drools.fieldaccess.";
    private final Map cache = new HashMap();

    private FieldAccessorGenerator() {
    }

    public static FieldAccessorGenerator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FieldAccessorGenerator();
        }
        return INSTANCE;
    }

    public FieldAccessorMap getInstanceFor(Class cls) throws Exception {
        Object obj = this.cache.get(cls);
        if (obj == null) {
            obj = this.newInstanceFor(cls);
            this.cache.put(cls, obj);
        }
        return (FieldAccessorMap)obj;
    }

    public FieldAccessorMap newInstanceFor(Class cls) throws Exception {
        ClassFieldInspector inspector = new ClassFieldInspector(cls);
        Method[] getters = inspector.getPropertyGetters().toArray(new Method[0]);
        String generatedClassName = GEN_PACKAGE_PREFIX + cls.getName();
        byte[] generatedClass = AccessorClassFactory.generateClass(getters, cls, generatedClassName);
        ByteArrayClassLoader cl = new ByteArrayClassLoader(Thread.currentThread().getContextClassLoader());
        cl.addByteArray(generatedClassName, generatedClass);
        FieldAccessor accessor = (FieldAccessor)cl.loadClass(generatedClassName).newInstance();
        FieldAccessorMap map = new FieldAccessorMap(accessor, inspector.getFieldNames());
        return map;
    }

    static class AccessorClassFactory
    implements Opcodes {
        private static final String GET_FIELD_BY_INDEX_METHOD_NAME = "getFieldByIndex";
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;
        static /* synthetic */ Class class$5;
        static /* synthetic */ Class class$6;
        static /* synthetic */ Class class$7;
        static /* synthetic */ Class class$8;
        static /* synthetic */ Class class$9;
        static /* synthetic */ Class class$10;
        static /* synthetic */ Class class$11;
        static /* synthetic */ Class class$12;
        static /* synthetic */ Class class$13;
        static /* synthetic */ Class class$14;
        static /* synthetic */ Class class$15;
        static /* synthetic */ Class class$16;
        static /* synthetic */ Class class$17;
        static /* synthetic */ Class class$18;

        AccessorClassFactory() {
        }

        private static String getShortName(Class cls) {
            String name = cls.getName();
            String packageName = cls.getPackage().getName();
            return name.substring(packageName.length() + 1, name.length());
        }

        public static byte[] generateClass(Method[] getters, Class targetClass, String generatedClassName) throws Exception {
            ClassWriter cw = new ClassWriter(true);
            generatedClassName = generatedClassName.replaceAll("\\.", "/");
            String[] stringArray = new String[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.drools.util.asm.FieldAccessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            stringArray[0] = Type.getInternalName(clazz);
            cw.visit(46, 33, generatedClassName, null, "java/lang/Object", stringArray);
            cw.visitSource(String.valueOf(AccessorClassFactory.getShortName(targetClass)) + ".java", null);
            AccessorClassFactory.doConstructor(cw);
            AccessorClassFactory.doMethods(cw, Type.getInternalName(targetClass), getters, targetClass.isInterface());
            cw.visitEnd();
            return cw.toByteArray();
        }

        private static void doMethods(ClassWriter cw, String targetType, Method[] getters, boolean isInterface) {
            MethodVisitor mv = cw.visitMethod(1, GET_FIELD_BY_INDEX_METHOD_NAME, "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
            mv.visitCode();
            Label entry = new Label();
            mv.visitLabel(entry);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, targetType);
            int target = 3;
            mv.visitVarInsn(58, 3);
            Label start = new Label();
            mv.visitLabel(start);
            mv.visitVarInsn(21, 2);
            Label[] switchItems = new Label[getters.length];
            int i = 0;
            while (i < getters.length) {
                switchItems[i] = new Label();
                ++i;
            }
            Label defaultSwitch = new Label();
            mv.visitTableSwitchInsn(0, switchItems.length - 1, defaultSwitch, switchItems);
            int i2 = 0;
            while (i2 < getters.length) {
                Method method = getters[i2];
                if (method.getReturnType().isPrimitive()) {
                    AccessorClassFactory.doSwitchItemBoxed(mv, switchItems[i2], 3, targetType, method.getName(), method.getReturnType(), isInterface);
                } else {
                    AccessorClassFactory.doSwitchItemObject(mv, switchItems[i2], 3, targetType, method.getName(), method.getReturnType(), isInterface);
                }
                ++i2;
            }
            mv.visitLabel(defaultSwitch);
            mv.visitInsn(1);
            mv.visitInsn(176);
            Label endLabel = new Label();
            mv.visitLabel(endLabel);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private static void doSwitchItemBoxed(MethodVisitor mv, Label switchItem, int target, String targetType, String targetMethod, Class scalarType, boolean isInterface) {
            Class boxType = null;
            boxType = AccessorClassFactory.getBoxType(scalarType);
            String scalarDescriptor = Type.getDescriptor(scalarType);
            String internalBoxName = Type.getInternalName(boxType);
            mv.visitLabel(switchItem);
            mv.visitTypeInsn(187, internalBoxName);
            mv.visitInsn(89);
            mv.visitVarInsn(25, target);
            if (isInterface) {
                mv.visitMethodInsn(185, targetType, targetMethod, "()" + scalarDescriptor);
            } else {
                mv.visitMethodInsn(182, targetType, targetMethod, "()" + scalarDescriptor);
            }
            mv.visitMethodInsn(183, internalBoxName, "<init>", "(" + scalarDescriptor + ")V");
            mv.visitInsn(176);
        }

        private static Class getBoxType(Class scalarType) {
            if (scalarType == Integer.TYPE) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (scalarType == Boolean.TYPE) {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (scalarType == Character.TYPE) {
                Class<?> clazz = class$6;
                if (clazz == null) {
                    try {
                        clazz = class$6 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (scalarType == Byte.TYPE) {
                Class<?> clazz = class$8;
                if (clazz == null) {
                    try {
                        clazz = class$8 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (scalarType == Short.TYPE) {
                Class<?> clazz = class$10;
                if (clazz == null) {
                    try {
                        clazz = class$10 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (scalarType == Long.TYPE) {
                Class<?> clazz = class$12;
                if (clazz == null) {
                    try {
                        clazz = class$12 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (scalarType == Float.TYPE) {
                Class<?> clazz = class$14;
                if (clazz == null) {
                    try {
                        clazz = class$14 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (scalarType == Double.TYPE) {
                Class<?> clazz = class$16;
                if (clazz == null) {
                    try {
                        clazz = class$16 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (scalarType == Void.TYPE) {
                Class<?> clazz = class$18;
                if (clazz == null) {
                    try {
                        clazz = class$18 = Class.forName("java.lang.Void");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            throw new IllegalArgumentException("Unknown scalar type: " + scalarType.getName());
        }

        private static void doSwitchItemObject(MethodVisitor mv, Label label, int target, String targetType, String targetMethod, Class returnClass, boolean isInterface) {
            String returnType = "()" + Type.getDescriptor(returnClass);
            mv.visitLabel(label);
            mv.visitVarInsn(25, target);
            if (isInterface) {
                mv.visitMethodInsn(185, targetType, targetMethod, returnType);
            } else {
                mv.visitMethodInsn(182, targetType, targetMethod, returnType);
            }
            mv.visitInsn(176);
        }

        private static void doConstructor(ClassWriter cw) {
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(5, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
            mv.visitInsn(177);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
    }

    static class ByteArrayClassLoader
    extends ClassLoader {
        public ByteArrayClassLoader(ClassLoader parent) {
            super(parent);
        }

        public void addByteArray(String name, byte[] bytes) {
            this.defineClass(name, bytes, 0, bytes.length);
        }
    }
}

