/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.asm;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.asm.AnnotationVisitor;
import org.drools.asm.Attribute;
import org.drools.asm.ClassReader;
import org.drools.asm.ClassVisitor;
import org.drools.asm.FieldVisitor;
import org.drools.asm.MethodVisitor;

public class ClassFieldInspector {
    private final List methods = new ArrayList();
    private final Map fieldNames = new HashMap();
    private final Map fieldTypes = new HashMap();
    private final Map methodNames = new HashMap();
    private final Set nonGetters = new HashSet();

    public ClassFieldInspector(Class clazz) throws IOException {
        this.processClass(clazz);
    }

    private void processClass(Class clazz) throws IOException {
        String name = this.getResourcePath(clazz);
        InputStream stream = clazz.getResourceAsStream(name);
        ClassReader reader = new ClassReader(stream);
        ClassFieldVisitor visitor = new ClassFieldVisitor(clazz, this);
        reader.accept(visitor, false);
        if (clazz.getSuperclass() != null) {
            this.processClass(clazz.getSuperclass());
        }
        if (clazz.isInterface()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                this.processClass(interfaces[i]);
                ++i;
            }
        }
    }

    private String getResourcePath(Class clazz) {
        return "/" + clazz.getName().replace('.', '/') + ".class";
    }

    public List getPropertyGetters() {
        return this.methods;
    }

    public Map getFieldNames() {
        return this.fieldNames;
    }

    public Map getFieldTypes() {
        return this.fieldTypes;
    }

    public Map getGetterMethods() {
        return this.methodNames;
    }

    static class ClassFieldVisitor
    implements ClassVisitor {
        private Class clazz;
        private ClassFieldInspector inspector;
        private Map fields = new HashMap();
        static /* synthetic */ Class class$0;

        ClassFieldVisitor(Class cls, ClassFieldInspector inspector) {
            this.clazz = cls;
            this.inspector = inspector;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ((access & 1) > 0 && desc.startsWith("()") && !name.equals("<init>")) {
                try {
                    Method method = this.clazz.getMethod(name, null);
                    if (method.getReturnType() != Void.TYPE) {
                        int fieldIndex = this.inspector.methods.size();
                        this.addToMapping(method, fieldIndex);
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Error in getting field access method.");
                }
            }
            return null;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        public void visitSource(String source, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new ClassFieldAnnotationVisitor();
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.fields.put(name.toLowerCase(), name);
            return null;
        }

        private void addToMapping(Method method, int index) {
            String name = method.getName();
            int offset = name.startsWith("is") ? 2 : (name.startsWith("get") ? 3 : 0);
            String fieldName = this.calcFieldName(name, offset);
            if (this.inspector.fieldNames.containsKey(fieldName)) {
                if (offset != 0 && this.inspector.nonGetters.contains(fieldName)) {
                    this.removeOldField(fieldName);
                    this.storeField(method, index, fieldName);
                    this.inspector.nonGetters.remove(fieldName);
                }
            } else {
                this.storeField(method, index, fieldName);
                if (offset == 0) {
                    this.inspector.nonGetters.add(fieldName);
                }
            }
        }

        private void removeOldField(String fieldName) {
            this.inspector.fieldNames.remove(fieldName);
            this.inspector.fieldTypes.remove(fieldName);
            this.inspector.methods.remove(this.inspector.methodNames.get(fieldName));
            this.inspector.methodNames.remove(fieldName);
        }

        private void storeField(Method method, int index, String fieldName) {
            this.inspector.fieldNames.put(fieldName, new Integer(index));
            this.inspector.fieldTypes.put(fieldName, method.getReturnType());
            this.inspector.methodNames.put(fieldName, method);
            this.inspector.methods.add(method);
        }

        private String calcFieldName(String name, int offset) {
            String result;
            if (offset > 0) {
                name = name.substring(offset);
            }
            if ((result = (String)this.fields.get(name.toLowerCase())) == null) {
                char first = Character.toLowerCase(name.charAt(0));
                result = String.valueOf(first) + name.substring(1);
            }
            return result;
        }
    }

    static class ClassFieldAnnotationVisitor
    implements AnnotationVisitor {
        ClassFieldAnnotationVisitor() {
        }

        public void visit(String arg0, Object arg1) {
        }

        public void visitEnum(String arg0, String arg1, String arg2) {
        }

        public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
            return new ClassFieldAnnotationVisitor();
        }

        public AnnotationVisitor visitArray(String arg0) {
            return new ClassFieldAnnotationVisitor();
        }

        public void visitEnd() {
        }
    }
}

