/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.drools.util.LinkedListNode;

public class LinkedList
implements Serializable {
    private LinkedListNode firstNode;
    private LinkedListNode lastNode;
    private int size;

    public void add(LinkedListNode node) {
        if (this.firstNode == null) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            this.lastNode.setNext(node);
            node.setPrevious(this.lastNode);
            this.lastNode = node;
        }
        ++this.size;
    }

    public void remove(LinkedListNode node) {
        if (this.firstNode != node && this.lastNode != node) {
            node.getPrevious().setNext(node.getNext());
            node.getNext().setPrevious(node.getPrevious());
            --this.size;
            node.setPrevious(null);
            node.setNext(null);
        } else if (this.firstNode == node) {
            this.removeFirst();
        } else if (this.lastNode == node) {
            this.removeLast();
        }
    }

    public final LinkedListNode getFirst() {
        return this.firstNode;
    }

    public final LinkedListNode getLast() {
        return this.lastNode;
    }

    public LinkedListNode removeFirst() {
        if (this.firstNode == null) {
            return null;
        }
        LinkedListNode node = this.firstNode;
        this.firstNode = node.getNext();
        node.setNext(null);
        if (this.firstNode != null) {
            this.firstNode.setPrevious(null);
        } else {
            this.lastNode = null;
        }
        --this.size;
        return node;
    }

    public LinkedListNode removeLast() {
        if (this.lastNode == null) {
            return null;
        }
        LinkedListNode node = this.lastNode;
        this.lastNode = node.getPrevious();
        node.setPrevious(null);
        if (this.lastNode != null) {
            this.lastNode.setNext(null);
        } else {
            this.firstNode = this.lastNode;
        }
        --this.size;
        return node;
    }

    public final boolean isEmpty() {
        return this.firstNode == null;
    }

    public void clear() {
        while (this.removeFirst() != null) {
        }
    }

    public final int size() {
        return this.size;
    }

    public Iterator iterator() {
        return new Iterator(){
            private LinkedListNode currentNode = null;
            private LinkedListNode nextNode;
            {
                this.nextNode = LinkedList.this.getFirst();
            }

            public boolean hasNext() {
                return this.nextNode != null;
            }

            public Object next() {
                this.currentNode = this.nextNode;
                if (this.currentNode == null) {
                    throw new NoSuchElementException("No more elements to return");
                }
                this.nextNode = this.currentNode.getNext();
                return this.currentNode;
            }

            public void remove() {
                if (this.currentNode == null) {
                    throw new IllegalStateException("No item to remove. Call next() before calling remove().");
                }
                LinkedList.this.remove(this.currentNode);
                this.currentNode = null;
            }
        };
    }
}

