/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.util.FastCollection;
import org.drools.util.FastComparator;

public class FastMap
implements Map,
Serializable {
    private static final long serialVersionUID = -4281546938715716829L;
    private static final int R0 = 5;
    private static final int M0 = 31;
    private transient Entry[][] _entries;
    private transient Entry _head = new Entry();
    private transient Entry _tail = new Entry();
    private transient int _size;
    private transient Values _values = new Values();
    private transient KeySet _keySet = new KeySet();
    private transient EntrySet _entrySet = new EntrySet();
    private transient Map _unmodifiable = new Unmodifiable();
    private transient FastMap _oldEntries;
    private transient FastComparator _keyComparator = FastComparator.DEFAULT;
    private transient FastComparator _keyComp = FastComparator.REHASH_SYSTEM_HASHCODE ? FastComparator.REHASH : null;
    private transient boolean _isShared;
    private static final Entry[] NULL_BLOCK = new Entry[32];
    static volatile boolean CHECK_POINT;

    public FastMap() {
        this(4);
    }

    public FastMap(int capacity) {
        int tableLength = 32;
        while (tableLength < capacity) {
            tableLength <<= 1;
        }
        this._entries = new Entry[tableLength >> 5][];
        int i = 0;
        while (i < this._entries.length) {
            this._entries[i++] = new Entry[32];
        }
        this._head._next = this._tail;
        this._tail._previous = this._head;
        Entry previous = this._tail;
        int i2 = 0;
        while (i2++ < capacity) {
            Entry newEntry = new Entry();
            newEntry._previous = previous;
            previous._next = newEntry;
            previous = newEntry;
        }
    }

    public FastMap(Map map) {
        this(map.size());
        this.putAll(map);
    }

    private FastMap(Entry[][] entries) {
        this._entries = entries;
        this._head._next = this._tail;
        this._tail._previous = this._head;
    }

    public final Entry head() {
        return this._head;
    }

    public final Entry tail() {
        return this._tail;
    }

    public final int size() {
        return this._size;
    }

    public final boolean isEmpty() {
        return this._head._next == this._tail;
    }

    public final boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    public final boolean containsValue(Object value) {
        return this._values.contains(value);
    }

    public final Object get(Object key) {
        Entry entry = this.getEntry(key, this._keyComp == null ? key.hashCode() : this._keyComp.hashCodeOf(key));
        return entry != null ? entry._value : null;
    }

    public final Entry getEntry(Object key) {
        return this.getEntry(key, this._keyComp == null ? key.hashCode() : this._keyComp.hashCodeOf(key));
    }

    public final Object put(Object key, Object value) {
        int keyHash;
        int n = keyHash = this._keyComp == null ? key.hashCode() : this._keyComp.hashCodeOf(key);
        if (this._isShared) {
            return this.putShared(key, value, keyHash);
        }
        Entry entry = this.getEntry(key, keyHash);
        if (entry == null) {
            this.addEntry(keyHash, key, value);
            return null;
        }
        Object prevValue = entry._value;
        entry._value = value;
        return prevValue;
    }

    private synchronized Object putShared(Object key, Object value, int keyHash) {
        Entry entry = this.getEntry(key, keyHash);
        if (entry == null) {
            this.addEntry(keyHash, key, value);
            return null;
        }
        Object prevValue = entry._value;
        entry._value = value;
        return prevValue;
    }

    public final void putAll(Map map) {
        if (map instanceof FastMap) {
            FastMap fm = (FastMap)map;
            Entry e = fm._head;
            Entry end = fm._tail;
            while ((e = e._next) != end) {
                this.put(e._key, e._value);
            }
        } else {
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public final Object remove(Object key) {
        if (this._isShared) {
            return this.removeShared(key);
        }
        Entry entry = this.getEntry(key);
        if (entry != null) {
            Object prevValue = entry._value;
            this.removeEntry(entry);
            return prevValue;
        }
        return null;
    }

    private synchronized Object removeShared(Object key) {
        Entry entry = this.getEntry(key);
        if (entry != null) {
            --this._size;
            entry.detach();
            return entry._value;
        }
        return null;
    }

    public FastMap setShared(boolean isShared) {
        this._isShared = isShared;
        return this;
    }

    public boolean isShared() {
        return this._isShared;
    }

    public FastMap setKeyComparator(FastComparator keyComparator) {
        this._keyComparator = keyComparator;
        this._keyComp = keyComparator instanceof FastComparator.Default ? (FastComparator.REHASH_SYSTEM_HASHCODE ? FastComparator.REHASH : null) : (keyComparator instanceof FastComparator.Direct ? null : keyComparator);
        return this;
    }

    public FastComparator getKeyComparator() {
        return this._keyComparator;
    }

    public FastMap setValueComparator(FastComparator valueComparator) {
        this._values.setValueComparator(valueComparator);
        return this;
    }

    public FastComparator getValueComparator() {
        return this._values.getValueComparator();
    }

    public final void clear() {
        if (this._isShared) {
            this.clearShared();
            return;
        }
        Entry e = this._head;
        Entry end = this._tail;
        while ((e = e._next) != end) {
            e._key = null;
            e._value = null;
            Entry[][] table = e._table;
            table[((Entry)e)._keyHash >> 5 & table.length - 1][((Entry)e)._keyHash & 0x1F] = null;
        }
        this._tail = this._head._next;
        this._size = 0;
        this._oldEntries = null;
    }

    private synchronized void clearShared() {
        Entry e = this._head;
        Entry end = this._tail;
        while ((e = e._next) != end) {
            Entry[][] table = e._table;
            table[((Entry)e)._keyHash >> 5 & table.length - 1][((Entry)e)._keyHash & 0x1F] = null;
        }
        this._head._next = this._tail;
        this._tail._previous = this._head;
        this._oldEntries = null;
        this._size = 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Map) {
            Map that = (Map)obj;
            if (this.size() == that.size()) {
                Set thatEntrySet = that.entrySet();
                Entry e = this._head;
                Entry end = this._tail;
                while ((e = e._next) != end) {
                    if (thatEntrySet.contains(e)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int code = 0;
        Entry e = this._head;
        Entry end = this._tail;
        while ((e = e._next) != end) {
            code += e.hashCode();
        }
        return code;
    }

    public String toString() {
        return this._entrySet.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStatistics(PrintStream out) {
        int maxOccupancy = 0;
        int totalCollisions = 0;
        int size = 0;
        int i = 0;
        while (i < this._entries.length) {
            int j = 0;
            while (j < this._entries[i].length) {
                Entry entry = this._entries[i][j];
                int occupancy = 0;
                while (entry != null) {
                    if (++occupancy > maxOccupancy) {
                        maxOccupancy = occupancy;
                    }
                    if (occupancy > 1) {
                        ++totalCollisions;
                    }
                    entry = entry._beside;
                    ++size;
                }
                ++j;
            }
            ++i;
        }
        StringBuffer percentCollisions = new StringBuffer();
        if (size != 0) {
            percentCollisions.append(100 * totalCollisions / size);
            percentCollisions.append('%');
        } else {
            percentCollisions.append("N/A");
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.print("SIZE: " + size);
            out.print(", TABLE LENGTH: " + this._entries.length * this._entries[0].length);
            out.print(", AVG COLLISIONS: " + percentCollisions);
            out.print(", MAX SLOT OCCUPANCY: " + maxOccupancy);
            out.print(", KEY COMPARATOR: " + (this._keyComp == null ? FastComparator.DIRECT : this._keyComp));
            out.print(", SHARED: " + this._isShared);
            out.println();
            if (this._oldEntries != null) {
                out.print(" + ");
                this._oldEntries.printStatistics(out);
            }
        }
    }

    public final Collection values() {
        return this._values;
    }

    public final Set entrySet() {
        return this._entrySet;
    }

    public final Set keySet() {
        return this._keySet;
    }

    public final Map unmodifiable() {
        return this._unmodifiable;
    }

    private final Entry getEntry(Object key, int keyHash) {
        Entry entry = this._entries[keyHash >> 5 & this._entries.length - 1][keyHash & 0x1F];
        while (entry != null) {
            if (key == entry._key || entry._keyHash == keyHash && (this._keyComp == null ? key.equals(entry._key) : this._keyComp.areEqual(key, entry._key))) {
                return entry;
            }
            entry = entry._beside;
        }
        return this._oldEntries != null ? this._oldEntries.getEntry(key, keyHash) : null;
    }

    private void addEntry(int hash, Object key, Object value) {
        if (this._size++ >> 5 >= this._entries.length) {
            this.increaseEntryTable();
        }
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        Entry newTail = this._tail._next;
        this._tail._key = key;
        this._tail._value = value;
        this._tail._keyHash = hash;
        this._tail._table = this._entries;
        int index = hash >> 5 & this._entries.length - 1;
        Entry[] tmp = this._entries[index];
        if (tmp == NULL_BLOCK) {
            this.newBlock(index);
            tmp = this._entries[index];
        }
        Entry beside = tmp[hash & 0x1F];
        this._tail._beside = beside;
        tmp[hash & 0x1F] = this._tail;
        this._tail = newTail;
    }

    private final void removeEntry(Entry entry) {
        --this._size;
        entry._key = null;
        entry._value = null;
        entry.detach();
        Entry next = this._tail._next;
        entry._previous = this._tail;
        entry._next = next;
        this._tail._next = entry;
        if (next != null) {
            next._previous = entry;
        }
    }

    private void newBlock(int index) {
        this._entries[index] = new Entry[32];
    }

    private void increaseCapacity() {
        Entry newEntry0 = new Entry();
        this._tail._next = newEntry0;
        newEntry0._previous = this._tail;
        Entry newEntry1 = new Entry();
        newEntry0._next = newEntry1;
        newEntry1._previous = newEntry0;
        Entry newEntry2 = new Entry();
        newEntry1._next = newEntry2;
        newEntry2._previous = newEntry1;
        Entry newEntry3 = new Entry();
        newEntry2._next = newEntry3;
        newEntry3._previous = newEntry2;
    }

    private void increaseEntryTable() {
        FastMap tmp;
        int newLength = this._entries.length << 3;
        if (newLength <= 8) {
            tmp = new FastMap(new Entry[8][]);
        } else if (newLength <= 64) {
            tmp = new FastMap(new Entry[64][]);
        } else if (newLength <= 512) {
            tmp = new FastMap(new Entry[512][]);
        } else if (newLength <= 4096) {
            tmp = new FastMap(new Entry[4096][]);
        } else if (newLength <= 32768) {
            tmp = new FastMap(new Entry[32768][]);
        } else if (newLength <= 262144) {
            tmp = new FastMap(new Entry[262144][]);
        } else if (newLength <= 0x200000) {
            tmp = new FastMap(new Entry[0x200000][]);
        } else if (newLength <= 0x1000000) {
            tmp = new FastMap(new Entry[0x1000000][]);
        } else if (newLength <= 0x8000000) {
            tmp = new FastMap(new Entry[0x8000000][]);
        } else {
            return;
        }
        int i = 0;
        while (i < tmp._entries.length) {
            tmp._entries[i++] = NULL_BLOCK;
        }
        Entry[][] newEntries = tmp._entries;
        tmp._entries = this._entries;
        tmp._oldEntries = this._oldEntries;
        tmp._keyComp = this._keyComp;
        tmp._head = null;
        tmp._tail = null;
        tmp._size = -1;
        this._oldEntries = tmp;
        FastMap.checkpoint();
        this._entries = newEntries;
    }

    public void reset() {
        this.setShared(false);
        this.clear();
        this.setKeyComparator(FastComparator.DEFAULT);
        this.setValueComparator(FastComparator.DEFAULT);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int size = stream.readInt();
        int entriesLength = stream.readInt();
        this._entries = new Entry[entriesLength][];
        int i = 0;
        while (i < this._entries.length) {
            this._entries[i++] = NULL_BLOCK;
        }
        this._head = new Entry();
        this._tail = new Entry();
        this._head._next = this._tail;
        this._tail._previous = this._head;
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._keySet = new KeySet();
        this._unmodifiable = new Unmodifiable();
        this.setShared(stream.readBoolean());
        this.setKeyComparator((FastComparator)stream.readObject());
        this.setValueComparator((FastComparator)stream.readObject());
        i = 0;
        while (i < size) {
            Object key = stream.readObject();
            Object value = stream.readObject();
            this.addEntry(this._keyComparator.hashCodeOf(key), key, value);
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this._size);
        stream.writeInt(this._entries.length);
        stream.writeBoolean(this._isShared);
        stream.writeObject(this._keyComparator);
        stream.writeObject(this._values.getValueComparator());
        Entry e = this._head;
        Entry end = this._tail;
        while ((e = e._next) != end) {
            stream.writeObject(e._key);
            stream.writeObject(e._value);
        }
    }

    private static void checkpoint() {
        if (CHECK_POINT) {
            throw new Error();
        }
    }

    private final class Values
    extends FastCollection {
        private static final long serialVersionUID = 8804295702684770940L;

        private Values() {
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._value;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }
    }

    private final class EntrySet
    extends FastCollection
    implements Set {
        private static final long serialVersionUID = 8729117163337735415L;

        private EntrySet() {
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object obj) {
            if (obj instanceof Map.Entry) {
                Entry entry = (Entry)obj;
                Entry mapEntry = FastMap.this.getEntry(entry.getKey());
                return entry.equals(mapEntry);
            }
            return false;
        }

        public String toString() {
            StringBuffer text = new StringBuffer("[");
            String equ = "=";
            String sep = ", ";
            Entry e = FastMap.this._head;
            Entry end = FastMap.this._tail;
            while ((e = e._next) != end) {
                text = text.append(String.valueOf(e._key)).append("=").append(String.valueOf(e._value));
                if (e._next == end) continue;
                text = text.append(", ");
            }
            return text.append(']').toString();
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return record;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }
    }

    private final class KeySet
    extends FastCollection
    implements Set {
        private static final long serialVersionUID = -2629453921452583782L;

        private KeySet() {
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object obj) {
            return FastMap.this.containsKey(obj);
        }

        public boolean remove(Object obj) {
            return FastMap.this.remove(obj) != null;
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._key;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }
    }

    public static final class Entry
    implements Map.Entry,
    FastCollection.Record {
        private Entry _next;
        private Entry _previous;
        private Object _key;
        private Object _value;
        private Entry _beside;
        private Entry[][] _table;
        private int _keyHash;

        private Entry() {
        }

        public final FastCollection.Record getNext() {
            return this._next;
        }

        public final FastCollection.Record getPrevious() {
            return this._previous;
        }

        public final Object getKey() {
            return this._key;
        }

        public final Object getValue() {
            return this._value;
        }

        public final Object setValue(Object value) {
            Object old = this._value;
            this._value = value;
            return old;
        }

        public boolean equals(Object that) {
            if (that instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)that;
                return this._key.equals(entry.getKey()) && (this._value != null ? this._value.equals(entry.getValue()) : entry.getValue() == null);
            }
            return false;
        }

        public int hashCode() {
            return this._key.hashCode() ^ (this._value != null ? this._value.hashCode() : 0);
        }

        /*
         * Unable to fully structure code
         */
        private final void detach() {
            block1: {
                this._previous._next = this._next;
                this._next._previous = this._previous;
                index = this._keyHash >> 5 & this._table.length - 1;
                beside = this._beside;
                previous = this._table[index][this._keyHash & 31];
                if (previous != this) ** GOTO lbl10
                this._table[index][this._keyHash & 31] = beside;
                break block1;
lbl-1000:
                // 1 sources

                {
                    previous = previous._beside;
lbl10:
                    // 2 sources

                    ** while (previous._beside != this)
                }
lbl11:
                // 1 sources

                previous._beside = beside;
            }
        }
    }

    private final class Unmodifiable
    implements Map,
    Serializable {
        private static final long serialVersionUID = 2699246906507262549L;

        private Unmodifiable() {
        }

        public boolean equals(Object obj) {
            return FastMap.this.equals(obj);
        }

        public int hashCode() {
            return FastMap.this.hashCode();
        }

        public String toString() {
            return FastMap.this.toString();
        }

        public int size() {
            return FastMap.this.size();
        }

        public boolean isEmpty() {
            return FastMap.this.isEmpty();
        }

        public boolean containsKey(Object key) {
            return FastMap.this.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return FastMap.this.containsValue(value);
        }

        public Object get(Object key) {
            return FastMap.this.get(key);
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public void clear() {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Set keySet() {
            return (Set)FastMap.this._keySet.unmodifiable();
        }

        public Collection values() {
            return FastMap.this._values.unmodifiable();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException("Direct view over unmodifiable map entries is not supported  (to prevent access to Entry.setValue(Object) method). To iterate over unmodifiable map entries, applications may use the keySet() and values() fast collection views in conjonction.");
        }
    }
}

