/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.Serializable;
import java.util.Comparator;

public abstract class FastComparator
implements Comparator,
Serializable {
    public static final boolean REHASH_SYSTEM_HASHCODE = FastComparator.isPoorSystemHash();
    public static final FastComparator DEFAULT = new Default(REHASH_SYSTEM_HASHCODE);
    public static final FastComparator DIRECT = new Direct();
    public static final FastComparator REHASH = new Rehash();
    public static final FastComparator IDENTITY = new Identity();
    public static final FastComparator LEXICAL = new Lexical();

    public abstract int hashCodeOf(Object var1);

    public abstract boolean areEqual(Object var1, Object var2);

    public abstract int compare(Object var1, Object var2);

    private static boolean isPoorSystemHash() {
        boolean[] dist = new boolean[32];
        int i = 0;
        while (i < dist.length) {
            dist[new Object().hashCode() & dist.length - 1] = true;
            ++i;
        }
        int holes = 0;
        int i2 = 0;
        while (i2 < dist.length) {
            if (!dist[i2]) {
                ++holes;
            }
            ++i2;
        }
        return holes > dist.length >> 1;
    }

    static class Default
    extends FastComparator {
        private static final long serialVersionUID = 8861926890612437587L;
        private boolean _rehash;

        public Default(boolean rehash) {
            this._rehash = rehash;
        }

        public int hashCodeOf(Object obj) {
            return this._rehash ? REHASH.hashCodeOf(obj) : obj.hashCode();
        }

        public boolean areEqual(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }

        public String toString() {
            return "default";
        }
    }

    static class Direct
    extends FastComparator {
        private static final long serialVersionUID = 8105021907265110872L;

        Direct() {
        }

        public int hashCodeOf(Object obj) {
            return obj.hashCode();
        }

        public boolean areEqual(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }

        public String toString() {
            return "direct";
        }
    }

    static class Rehash
    extends FastComparator {
        private static final long serialVersionUID = -2958722429891710908L;

        Rehash() {
        }

        public int hashCodeOf(Object obj) {
            int h = obj.hashCode();
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            return h ^ h >>> 10;
        }

        public boolean areEqual(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }

        public String toString() {
            return "rehash";
        }
    }

    static class Identity
    extends FastComparator {
        private static final long serialVersionUID = -3868143955449541107L;
        private boolean _rehash = REHASH_SYSTEM_HASHCODE;

        Identity() {
        }

        public int hashCodeOf(Object obj) {
            int h = System.identityHashCode(obj);
            if (!this._rehash) {
                return h;
            }
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            return h ^ h >>> 10;
        }

        public boolean areEqual(Object o1, Object o2) {
            return o1 == o2;
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }

        public String toString() {
            return "identity";
        }
    }

    static class Lexical
    extends FastComparator {
        private static final long serialVersionUID = -6311812856053220728L;

        Lexical() {
        }

        public int hashCodeOf(Object obj) {
            if (obj instanceof String) {
                return obj.hashCode();
            }
            CharSequence chars = (CharSequence)obj;
            int h = 0;
            int length = chars.length();
            int i = 0;
            while (i < length) {
                h = 31 * h + chars.charAt(i++);
            }
            return h;
        }

        public boolean areEqual(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return o1.equals(o2);
            }
            if (o1 instanceof CharSequence && o2 instanceof String) {
                CharSequence csq = (CharSequence)o1;
                String str = (String)o2;
                int length = str.length();
                if (csq.length() != length) {
                    return false;
                }
                int i = 0;
                while (i < length) {
                    if (str.charAt(i) == csq.charAt(i++)) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof String && o2 instanceof CharSequence) {
                CharSequence csq = (CharSequence)o2;
                String str = (String)o1;
                int length = str.length();
                if (csq.length() != length) {
                    return false;
                }
                int i = 0;
                while (i < length) {
                    if (str.charAt(i) == csq.charAt(i++)) continue;
                    return false;
                }
                return true;
            }
            CharSequence csq1 = (CharSequence)o1;
            CharSequence csq2 = (CharSequence)o2;
            int length = csq1.length();
            if (csq2.length() != length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (csq1.charAt(i) == csq2.charAt(i++)) continue;
                return false;
            }
            return true;
        }

        public int compare(Object left, Object right) {
            if (left instanceof String) {
                if (right instanceof String) {
                    return ((String)left).compareTo((String)right);
                }
                String seq1 = (String)left;
                CharSequence seq2 = (CharSequence)right;
                int i = 0;
                int n = Math.min(seq1.length(), seq2.length());
                while (n-- != 0) {
                    char c2;
                    char c1 = seq1.charAt(i);
                    if (c1 == (c2 = seq2.charAt(i++))) continue;
                    return c1 - c2;
                }
                return seq1.length() - seq2.length();
            }
            if (right instanceof String) {
                return -this.compare(right, left);
            }
            CharSequence seq1 = (CharSequence)left;
            CharSequence seq2 = (CharSequence)right;
            int i = 0;
            int n = Math.min(seq1.length(), seq2.length());
            while (n-- != 0) {
                char c2;
                char c1 = seq1.charAt(i);
                if (c1 == (c2 = seq2.charAt(i++))) continue;
                return c1 - c2;
            }
            return seq1.length() - seq2.length();
        }

        public String toString() {
            return "lexical";
        }
    }
}

