/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.drools.util.Queue;
import org.drools.util.Queueable;

public class BinaryHeapFifoQueue
implements Queue,
Serializable {
    private static final int DEFAULT_CAPACITY = 13;
    private final Comparator comparator;
    private int size;
    private Queueable[] elements;

    public BinaryHeapFifoQueue(Comparator comparator) {
        this(comparator, 13);
    }

    public BinaryHeapFifoQueue(Comparator comparator, int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("invalid capacity");
        }
        this.elements = new Queueable[capacity + 1];
        this.comparator = comparator;
    }

    public void clear() {
        this.elements = new Queueable[this.elements.length];
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.elements.length == this.size + 1;
    }

    public int size() {
        return this.size;
    }

    public void enqueue(Queueable element) {
        if (this.isFull()) {
            this.grow();
        }
        this.percolateUpMinHeap(element);
    }

    public Queueable dequeue() throws NoSuchElementException {
        if (this.isEmpty()) {
            return null;
        }
        Queueable result = this.elements[1];
        result.dequeue();
        return result;
    }

    public Queueable dequeue(int index) {
        if (index < 1 || index > this.size) {
            return null;
        }
        Queueable result = this.elements[index];
        this.setElement(index, this.elements[this.size]);
        this.elements[this.size] = null;
        --this.size;
        if (this.size != 0 && index <= this.size) {
            int compareToParent = 0;
            if (index > 1) {
                compareToParent = this.compare(this.elements[index], this.elements[index / 2]);
            }
            if (index > 1 && compareToParent < 0) {
                this.percolateUpMinHeap(index);
            } else {
                this.percolateDownMinHeap(index);
            }
        }
        return result;
    }

    private void percolateDownMinHeap(int index) {
        Queueable element = this.elements[index];
        int hole = index;
        while (hole * 2 <= this.size) {
            int child = hole * 2;
            if (child != this.size && this.compare(this.elements[child + 1], this.elements[child]) < 0) {
                ++child;
            }
            if (this.compare(this.elements[child], element) >= 0) break;
            this.setElement(hole, this.elements[child]);
            hole = child;
        }
        this.setElement(hole, element);
    }

    private void percolateUpMinHeap(int index) {
        int hole = index;
        Queueable element = this.elements[hole];
        while (hole > 1 && this.compare(element, this.elements[hole / 2]) < 0) {
            int next = hole / 2;
            this.setElement(hole, this.elements[next]);
            hole = next;
        }
        this.setElement(hole, element);
    }

    private void percolateUpMinHeap(Queueable element) {
        this.setElement(++this.size, element);
        this.percolateUpMinHeap(this.size);
    }

    private int compare(Queueable a, Queueable b) {
        return this.comparator.compare(a, b);
    }

    private void grow() {
        Queueable[] elements = new Queueable[this.elements.length * 2];
        System.arraycopy(this.elements, 0, elements, 0, this.elements.length);
        this.elements = elements;
    }

    private void setElement(int index, Queueable element) {
        this.elements[index] = element;
        element.enqueued(this, index);
    }

    public Queueable[] getQueueable() {
        return this.elements;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.elements, 1, result, 0, this.size);
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elements, 1, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }
}

