/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.rule.And;
import org.drools.rule.Column;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.rule.FixedDuration;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.LogicTransformer;
import org.drools.spi.Consequence;
import org.drools.spi.Duration;

public class Rule
implements Serializable {
    private static final long serialVersionUID = 7952983928232702826L;
    private String pkg;
    private final String name;
    private int salience;
    private final Map declarations = new HashMap();
    private Declaration[] declarationArray;
    private final And lhsRoot = new And();
    private String agendaGroup;
    private Consequence consequence;
    private Duration duration;
    private long loadOrder;
    private boolean noLoop;
    private boolean autoFocus;
    private String ActivationGroup;
    private boolean semanticallyValid = true;
    static /* synthetic */ Class class$0;

    public Rule(String name, String pkg, String agendaGroup) {
        this.name = name;
        this.pkg = pkg;
        this.agendaGroup = agendaGroup;
    }

    public Rule(String name, String agendaGroup) {
        this.name = name;
        this.pkg = null;
        this.agendaGroup = agendaGroup;
    }

    public Rule(String name) {
        this.name = name;
        this.pkg = null;
        this.agendaGroup = "MAIN";
    }

    public void setDuration(long ms) {
        this.duration = new FixedDuration(ms);
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public boolean isValid() {
        return this.consequence != null && this.isSemanticallyValid();
    }

    public String getPackage() {
        return this.pkg;
    }

    public String getName() {
        return this.name;
    }

    public int getSalience() {
        return this.salience;
    }

    public void setSalience(int salience) {
        this.salience = salience;
    }

    public String getAgendaGroup() {
        return this.agendaGroup;
    }

    public void setAgendaGroup(String agendaGroup) {
        this.agendaGroup = agendaGroup;
    }

    public boolean getNoLoop() {
        return this.noLoop;
    }

    public void setNoLoop(boolean noLoop) {
        this.noLoop = noLoop;
    }

    public boolean getAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    public String getActivationGroup() {
        return this.ActivationGroup;
    }

    public void setXorGroup(String activationGroup) {
        this.ActivationGroup = activationGroup;
    }

    public Declaration getDeclaration(String identifier) {
        return (Declaration)this.declarations.get(identifier);
    }

    public Declaration[] getDeclarations() {
        if (this.declarationArray == null) {
            this.declarationArray = this.declarations.values().toArray(new Declaration[this.declarations.values().size()]);
        }
        return this.declarationArray;
    }

    public void addPattern(ConditionalElement ce) {
        if (ce instanceof GroupElement) {
            this.addDeclarations((GroupElement)ce);
        }
        this.lhsRoot.addChild(ce);
    }

    public void addPattern(Column column) {
        this.addDeclarations(column);
        this.lhsRoot.addChild(column);
    }

    private void addDeclarations(Column column) {
        if (column.isBound()) {
            Declaration declaration = column.getDeclaration();
            this.declarations.put(declaration.getIdentifier(), declaration);
        }
        Iterator it = column.getConstraints().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (!(object instanceof Declaration)) continue;
            Declaration declaration = (Declaration)object;
            this.declarations.put(declaration.getIdentifier(), declaration);
        }
    }

    private void addDeclarations(GroupElement ce) {
        Iterator it = ce.getChildren().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof Column) {
                this.addDeclarations((Column)object);
                continue;
            }
            if (!(object instanceof GroupElement)) continue;
            this.addDeclarations((GroupElement)object);
        }
    }

    public And getLhs() {
        return this.lhsRoot;
    }

    public And[] getTransformedLhs() throws InvalidPatternException {
        return LogicTransformer.getInstance().transform(this.lhsRoot);
    }

    public int getSpecifity() {
        return this.getSpecifity(this.lhsRoot);
    }

    private int getSpecifity(GroupElement ce) {
        int specificity = 0;
        Iterator it = ce.getChildren().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof Column) {
                specificity += this.getSpecifity((Column)object);
                continue;
            }
            if (!(object instanceof GroupElement)) continue;
            specificity += this.getSpecifity((GroupElement)object);
        }
        return specificity;
    }

    private int getSpecifity(Column column) {
        int specificity = 0;
        Iterator it = column.getConstraints().iterator();
        while (it.hasNext()) {
            if (it.next() instanceof Declaration) continue;
            ++specificity;
        }
        return specificity;
    }

    public void setConsequence(Consequence consequence) {
        this.consequence = consequence;
    }

    public Consequence getConsequence() {
        return this.consequence;
    }

    public long getLoadOrder() {
        return this.loadOrder;
    }

    void setLoadOrder(long loadOrder) {
        this.loadOrder = loadOrder;
    }

    public String toString() {
        return "[Rule name=" + this.name + ", agendaGroup=" + this.agendaGroup + ", salience=" + this.salience + ", no-loop=" + this.noLoop + "]";
    }

    public boolean equals(Object object) {
        block9: {
            block8: {
                if (this == object) {
                    return true;
                }
                if (object == null) break block8;
                Class<?> clazz = object.getClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.drools.rule.Rule");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) break block9;
            }
            return false;
        }
        Rule other = (Rule)object;
        return this.name.equals(other.name) && this.agendaGroup.equals(other.agendaGroup) && this.ActivationGroup.equals(other.ActivationGroup) && this.salience == other.salience && this.noLoop == other.noLoop;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setSemanticallyValid(boolean valid) {
        this.semanticallyValid = valid;
    }

    public boolean isSemanticallyValid() {
        return this.semanticallyValid;
    }
}

