/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.rule.Column;
import org.drools.rule.ConditionalElement;
import org.drools.rule.EvalCondition;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidRulePackage;
import org.drools.rule.PackageCompilationData;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.Rule;
import org.drools.spi.TypeResolver;

public class Package
implements Externalizable {
    private static final long serialVersionUID = -3098171849409626501L;
    public static final Package[] EMPTY_ARRAY = new Package[0];
    private String name;
    private Map rules;
    private List imports;
    private Map globals;
    private TypeResolver typeResolver;
    private PackageCompilationData packageCompilationData;
    private boolean valid = true;
    private String errorSummary;

    public Package() {
    }

    public Package(String name) {
        this(name, null);
    }

    public Package(String name, ClassLoader parentClassLoader) {
        this.name = name;
        this.imports = new ArrayList(1);
        this.rules = new LinkedHashMap();
        this.globals = new HashMap();
        this.packageCompilationData = new PackageCompilationData(parentClassLoader);
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeObject(this.packageCompilationData);
        stream.writeObject(this.name);
        stream.writeObject(this.imports);
        stream.writeObject(this.globals);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(this.rules);
        stream.writeObject(bos.toByteArray());
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        this.packageCompilationData = (PackageCompilationData)stream.readObject();
        this.name = (String)stream.readObject();
        this.imports = (List)stream.readObject();
        this.globals = (Map)stream.readObject();
        byte[] bytes = (byte[])stream.readObject();
        ObjectInputStreamWithLoader streamWithLoader = new ObjectInputStreamWithLoader(new ByteArrayInputStream(bytes), this.packageCompilationData.getClassLoader());
        this.rules = (Map)streamWithLoader.readObject();
    }

    public String getName() {
        return this.name;
    }

    public void addImport(String importEntry) {
        this.imports.add(importEntry);
    }

    public void removeImport(String importEntry) {
        this.imports.remove(importEntry);
    }

    public List getImports() {
        return this.imports;
    }

    public void addGlobal(String identifier, Class clazz) {
        this.globals.put(identifier, clazz);
    }

    public void removeGlobal(String identifier) {
        this.globals.remove(identifier);
    }

    public Map getGlobals() {
        return this.globals;
    }

    public void removeFunction(String functionName) {
        this.packageCompilationData.remove(String.valueOf(this.name) + "." + this.ucFirst(functionName));
    }

    public void addRule(Rule rule) {
        String name = rule.getName();
        this.rules.put(name, rule);
        rule.setLoadOrder(this.rules.size());
    }

    public void removeRule(Rule rule) {
        this.rules.remove(rule.getName());
        String consequenceName = rule.getConsequence().getClass().getName();
        this.packageCompilationData.remove(consequenceName);
        this.removeClasses(rule.getLhs());
        this.packageCompilationData.remove(consequenceName.substring(0, consequenceName.indexOf("ConsequenceInvoker")));
    }

    private void removeClasses(ConditionalElement ce) {
        if (ce instanceof GroupElement) {
            GroupElement group = (GroupElement)ce;
            Iterator it = group.getChildren().iterator();
            while (it.hasNext()) {
                Object object = it.next();
                if (object instanceof ConditionalElement) {
                    this.removeClasses((ConditionalElement)object);
                    continue;
                }
                if (!(object instanceof Column)) continue;
                this.removeClasses((Column)object);
            }
        } else if (ce instanceof EvalCondition) {
            this.packageCompilationData.remove(((EvalCondition)ce).getEvalExpression().getClass().getName());
        }
    }

    private void removeClasses(Column column) {
        Iterator it = column.getConstraints().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof PredicateConstraint) {
                this.packageCompilationData.remove(((PredicateConstraint)object).getPredicateExpression().getClass().getName());
                continue;
            }
            if (!(object instanceof ReturnValueConstraint)) continue;
            this.packageCompilationData.remove(((ReturnValueConstraint)object).getExpression().getClass().getName());
        }
    }

    public Rule getRule(String name) {
        return (Rule)this.rules.get(name);
    }

    public Rule[] getRules() {
        return this.rules.values().toArray(new Rule[this.rules.size()]);
    }

    public void setTypeSolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public PackageCompilationData getPackageCompilationData() {
        return this.packageCompilationData;
    }

    public String toString() {
        return "[Package name=" + this.name + "]";
    }

    public void setError(String summary) {
        this.errorSummary = summary;
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void checkValidity() {
        if (!this.isValid()) {
            throw new InvalidRulePackage(this.getErrorSummary());
        }
    }

    public String getErrorSummary() {
        return this.errorSummary;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Package)) {
            return false;
        }
        Package other = (Package)object;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private String ucFirst(String name) {
        return String.valueOf(name.toUpperCase().charAt(0)) + name.substring(1);
    }

    public void clear() {
        this.rules.clear();
        this.packageCompilationData.clear();
    }

    private static class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        public ObjectInputStreamWithLoader(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
            this.enableResolveObject(true);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this.classLoader == null) {
                return super.resolveClass(desc);
            }
            String name = desc.getName();
            return this.classLoader.loadClass(name);
        }
    }
}

