/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.drools.rule.And;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Or;

class LogicTransformer {
    private final Map duplicateTransformations = new HashMap();
    private final Map orTransformations = new HashMap();
    private static LogicTransformer INSTANCE = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static LogicTransformer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LogicTransformer();
        }
        return INSTANCE;
    }

    LogicTransformer() {
        this.initialize();
    }

    private void initialize() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("org.drools.rule.And");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz6 = class$0) == null) {
            try {
                clazz6 = class$0 = Class.forName("org.drools.rule.And");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTransformationPair(clazz7, clazz6);
        Class<?> clazz8 = class$1;
        if (clazz8 == null) {
            try {
                clazz8 = class$1 = Class.forName("org.drools.rule.Or");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz5 = class$1) == null) {
            try {
                clazz5 = class$1 = Class.forName("org.drools.rule.Or");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTransformationPair(clazz8, clazz5);
        Class<?> clazz9 = class$2;
        if (clazz9 == null) {
            try {
                clazz9 = class$2 = Class.forName("org.drools.rule.Exists");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz4 = class$2) == null) {
            try {
                clazz4 = class$2 = Class.forName("org.drools.rule.Exists");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTransformationPair(clazz9, clazz4);
        Class<?> clazz10 = class$3;
        if (clazz10 == null) {
            try {
                clazz10 = class$3 = Class.forName("org.drools.rule.Not");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz3 = class$1) == null) {
            try {
                clazz3 = class$1 = Class.forName("org.drools.rule.Or");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTransformationPair(clazz10, clazz3, new NotOrTransformation());
        Class<?> clazz11 = class$2;
        if (clazz11 == null) {
            try {
                clazz11 = class$2 = Class.forName("org.drools.rule.Exists");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$1) == null) {
            try {
                clazz2 = class$1 = Class.forName("org.drools.rule.Or");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTransformationPair(clazz11, clazz2, new ExistOrTransformation());
        Class<?> clazz12 = class$0;
        if (clazz12 == null) {
            try {
                clazz12 = class$0 = Class.forName("org.drools.rule.And");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.drools.rule.Or");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addTransformationPair(clazz12, clazz, new AndOrTransformation());
    }

    private void addTransformationPair(Class parent, Class child) {
        Map map = this.duplicateTransformations;
        HashSet<Class> childSet = (HashSet<Class>)map.get(child);
        if (childSet == null) {
            childSet = new HashSet<Class>();
            map.put(parent, childSet);
        }
        childSet.add(child);
    }

    private void addTransformationPair(Class parent, Class child, Object method) {
        Map map = this.orTransformations;
        HashMap<Class, Object> childMap = (HashMap<Class, Object>)map.get(parent);
        if (childMap == null) {
            childMap = new HashMap<Class, Object>();
            map.put(parent, childMap);
        }
        childMap.put(child, method);
    }

    And[] transform(And and) throws InvalidPatternException {
        And cloned = (And)and.clone();
        this.processTree(cloned);
        GroupElement or = null;
        Iterator it = cloned.getChildren().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (!(object instanceof Or)) continue;
            or = (Or)this.applyOrTransformation(cloned, (GroupElement)object);
            break;
        }
        And[] ands = null;
        if (or == null) {
            ands = new And[]{cloned};
            this.checkForAndRemoveDuplicates(ands[0]);
        } else {
            ands = new And[or.getChildren().size()];
            int i = 0;
            Iterator it2 = or.getChildren().iterator();
            while (it2.hasNext()) {
                Object object = it2.next();
                Class<?> clazz = object.getClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.drools.rule.And");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) {
                    ands[i] = (And)object;
                } else {
                    And newAnd = new And();
                    newAnd.addChild(and);
                    ands[i] = newAnd;
                }
                this.checkForAndRemoveDuplicates(ands[i++]);
            }
        }
        return ands;
    }

    void processTree(GroupElement ce) throws InvalidPatternException {
        ListIterator<GroupElement> it = ce.getChildren().listIterator();
        block0: while (it.hasNext()) {
            Object object = it.next();
            if (!(object instanceof GroupElement)) continue;
            GroupElement parent = (GroupElement)object;
            this.processTree(parent);
            this.checkForAndRemoveDuplicates(parent);
            Iterator orIter = parent.getChildren().iterator();
            while (orIter.hasNext()) {
                Object object2 = orIter.next();
                if (!(object2 instanceof Or)) continue;
                it.remove();
                it.add(this.applyOrTransformation(parent, (GroupElement)object2));
                continue block0;
            }
        }
    }

    boolean removeDuplicate(GroupElement parent, GroupElement child) {
        if (this.duplicateTransformations.get(parent.getClass()) != null) {
            return ((HashSet)this.duplicateTransformations.get(parent.getClass())).contains(child.getClass());
        }
        return false;
    }

    void checkForAndRemoveDuplicates(GroupElement parent) {
        ListIterator it = parent.getChildren().listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (!parent.getClass().isInstance(object) || !this.removeDuplicate(parent, (GroupElement)object)) continue;
            ArrayList newList = new ArrayList();
            GroupElement child = (GroupElement)object;
            Iterator childIter = child.getChildren().iterator();
            while (childIter.hasNext()) {
                newList.add(childIter.next());
            }
            it.remove();
            childIter = newList.iterator();
            while (childIter.hasNext()) {
                it.add(childIter.next());
            }
        }
    }

    GroupElement applyOrTransformation(GroupElement parent, GroupElement child) throws InvalidPatternException {
        Transformation transformation = null;
        HashMap map = (HashMap)this.orTransformations.get(parent.getClass());
        if (map != null) {
            transformation = (Transformation)map.get(child.getClass());
        }
        if (transformation == null) {
            throw new RuntimeException("applyOrTransformation could not find transformation for parent '" + parent.getClass().getName() + "' and child '" + child.getClass().getName() + "'");
        }
        return transformation.transform(parent);
    }

    static interface Transformation {
        public GroupElement transform(GroupElement var1) throws InvalidPatternException;
    }

    class AndOrTransformation
    implements Transformation {
        AndOrTransformation() {
        }

        public GroupElement transform(GroupElement and) throws InvalidPatternException {
            Or or = new Or();
            this.determinePermutations(0, (And)and, null, or);
            return or;
        }

        private void determinePermutations(int currentLevel, And and, And combination, Or or) {
            Object entry = and.getChildren().get(currentLevel);
            if (entry instanceof Or) {
                Or childOr = (Or)entry;
                Iterator it = childOr.getChildren().iterator();
                while (it.hasNext()) {
                    And temp = new And();
                    if (currentLevel == 0) {
                        combination = new And();
                    } else {
                        temp.getChildren().addAll(combination.getChildren());
                    }
                    Object object = it.next();
                    if (object instanceof And) {
                        And childAnd = (And)object;
                        Iterator childIter = childAnd.getChildren().iterator();
                        while (childIter.hasNext()) {
                            temp.addChild(childIter.next());
                        }
                    } else {
                        temp.addChild(object);
                    }
                    if (currentLevel < and.getChildren().size() - 1) {
                        this.determinePermutations(currentLevel + 1, and, temp, or);
                        continue;
                    }
                    or.addChild(temp);
                }
            } else {
                And temp = new And();
                if (currentLevel == 0) {
                    combination = new And();
                } else {
                    temp.getChildren().addAll(combination.getChildren());
                }
                temp.addChild(entry);
                if (currentLevel < and.getChildren().size() - 1) {
                    this.determinePermutations(currentLevel + 1, and, temp, or);
                } else {
                    or.addChild(temp);
                }
            }
        }
    }

    class ExistOrTransformation
    implements Transformation {
        ExistOrTransformation() {
        }

        public GroupElement transform(GroupElement exist) throws InvalidPatternException {
            throw new InvalidPatternException("You cannot nest an OR within an Exists");
        }
    }

    public class NotOrTransformation
    implements Transformation {
        public GroupElement transform(GroupElement not) throws InvalidPatternException {
            throw new InvalidPatternException("You cannot nest an OR within an Not");
        }
    }
}

