/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.Arrays;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.rule.Declaration;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldConstraint;
import org.drools.spi.FieldExtractor;
import org.drools.spi.Tuple;

public class BoundVariableConstraint
implements FieldConstraint {
    private static final long serialVersionUID = 8141052924257031767L;
    private final FieldExtractor fieldExtractor;
    private final Declaration declaration;
    private final int column;
    private final Declaration[] requiredDeclarations;
    private final Evaluator evaluator;

    public BoundVariableConstraint(FieldExtractor fieldExtractor, Declaration declaration, Evaluator evaluator) {
        this.fieldExtractor = fieldExtractor;
        this.declaration = declaration;
        this.column = declaration.getColumn();
        this.requiredDeclarations = new Declaration[]{declaration};
        this.evaluator = evaluator;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public FieldExtractor getFieldExtractor() {
        return this.fieldExtractor;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public boolean isAllowed(InternalFactHandle handle, Tuple tuple, WorkingMemory workingMemory) {
        return this.evaluator.evaluate(this.fieldExtractor.getValue(handle.getObject()), this.declaration.getValue(tuple.get(this.column).getObject()));
    }

    public String toString() {
        return "[BoundVariableConstraint fieldExtractor=" + this.fieldExtractor + " declaration=" + this.declaration + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + (this.declaration == null ? 0 : this.declaration.hashCode());
        result = 31 * result + (this.evaluator == null ? 0 : this.evaluator.hashCode());
        result = 31 * result + (this.fieldExtractor == null ? 0 : this.fieldExtractor.hashCode());
        result = 31 * result + this.requiredDeclarations[0].hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BoundVariableConstraint other = (BoundVariableConstraint)object;
        return this.column == other.column && this.fieldExtractor.equals(other.fieldExtractor) && this.declaration.equals(other.declaration) && this.evaluator.equals(other.evaluator) && Arrays.equals(this.requiredDeclarations, other.requiredDeclarations);
    }
}

