/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.drools.common.BetaNodeBinder;
import org.drools.common.DefaultFactHandle;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.ObjectMatches;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.TupleMatch;
import org.drools.reteoo.TupleSink;
import org.drools.spi.PropagationContext;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListNode;
import org.drools.util.LinkedListObjectWrapper;

abstract class TupleSource
extends BaseNode
implements Serializable {
    protected List tupleSinks = new ArrayList(1);

    TupleSource(int id) {
        super(id);
    }

    protected void addTupleSink(TupleSink tupleSink) {
        if (!this.tupleSinks.contains(tupleSink)) {
            this.tupleSinks.add(tupleSink);
        }
    }

    protected void removeTupleSink(TupleSink tupleSink) {
        this.tupleSinks.remove(tupleSink);
    }

    protected TupleMatch attemptJoin(ReteTuple leftTuple, DefaultFactHandle handle, ObjectMatches objectMatches, BetaNodeBinder binder, ReteooWorkingMemory workingMemory) {
        if (binder.isAllowed(handle, leftTuple, workingMemory)) {
            TupleMatch tupleMatch = objectMatches.add(leftTuple);
            leftTuple.addTupleMatch(handle, tupleMatch);
            return tupleMatch;
        }
        return null;
    }

    protected void propagateAssertTuple(ReteTuple tuple, TupleMatch tupleMatch, PropagationContext context, ReteooWorkingMemory workingMemory) {
        if (!this.getTupleSinks().isEmpty()) {
            ((TupleSink)this.getTupleSinks().get(0)).assertTuple(tuple, context, workingMemory);
            tupleMatch.addJoinedTuple(tuple);
            int i = 1;
            int size = this.getTupleSinks().size();
            while (i < size) {
                ReteTuple clone = new ReteTuple(tuple);
                tupleMatch.addJoinedTuple(clone);
                ((TupleSink)this.getTupleSinks().get(i)).assertTuple(clone, context, workingMemory);
                ++i;
            }
        }
    }

    protected void propagateAssertTuple(ReteTuple tuple, PropagationContext context, ReteooWorkingMemory workingMemory) {
        int i = 0;
        int size = this.getTupleSinks().size();
        while (i < size) {
            ReteTuple child = new ReteTuple(tuple);
            tuple.addLinkedTuple(new LinkedListObjectWrapper(child));
            ((TupleSink)this.getTupleSinks().get(i)).assertTuple(child, context, workingMemory);
            ++i;
        }
    }

    protected void propagateAssertTuple(ReteTuple tuple, DefaultFactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) {
        int i = 0;
        int size = this.getTupleSinks().size();
        while (i < size) {
            ReteTuple child = new ReteTuple(tuple, handle);
            tuple.addLinkedTuple(new LinkedListObjectWrapper(child));
            ((TupleSink)this.getTupleSinks().get(i)).assertTuple(child, context, workingMemory);
            ++i;
        }
    }

    protected void propagateRetractTuple(TupleMatch tupleMatch, PropagationContext context, ReteooWorkingMemory workingMemory) {
        List joined = tupleMatch.getJoinedTuples();
        int i = 0;
        int size = joined.size();
        while (i < size) {
            ((TupleSink)this.getTupleSinks().get(i)).retractTuple((ReteTuple)joined.get(i), context, workingMemory);
            ++i;
        }
    }

    protected void propagateRetractTuple(ReteTuple tuple, PropagationContext context, ReteooWorkingMemory workingMemory) {
        LinkedList list = tuple.getLinkedTuples();
        if (list != null && !list.isEmpty()) {
            int i = 0;
            LinkedListNode node = list.removeFirst();
            while (node != null) {
                ((TupleSink)this.getTupleSinks().get(i++)).retractTuple((ReteTuple)((LinkedListObjectWrapper)node).getObject(), context, workingMemory);
                node = list.removeFirst();
            }
        }
    }

    protected void propagateModifyTuple(TupleMatch tupleMatch, PropagationContext context, ReteooWorkingMemory workingMemory) {
        List joined = tupleMatch.getJoinedTuples();
        int i = 0;
        int size = joined.size();
        while (i < size) {
            ((TupleSink)this.getTupleSinks().get(i)).modifyTuple((ReteTuple)joined.get(i), context, workingMemory);
            ++i;
        }
    }

    protected void propagateModifyTuple(ReteTuple tuple, PropagationContext context, ReteooWorkingMemory workingMemory) {
        LinkedList list = tuple.getLinkedTuples();
        if (list != null && !list.isEmpty()) {
            int i = 0;
            LinkedListNode node = list.getFirst();
            while (node != null) {
                ((TupleSink)this.getTupleSinks().get(i++)).modifyTuple((ReteTuple)((LinkedListObjectWrapper)node).getObject(), context, workingMemory);
                node = node.getNext();
            }
        }
    }

    public List getTupleSinks() {
        return this.tupleSinks;
    }

    public abstract List getPropagatedTuples(ReteooWorkingMemory var1, TupleSink var2);
}

