/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Iterator;
import org.drools.RuleBaseConfiguration;
import org.drools.common.AgendaGroupImpl;
import org.drools.common.AgendaItem;
import org.drools.common.InternalAgenda;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.ScheduledAgendaItem;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.ActivationGroup;
import org.drools.spi.Duration;
import org.drools.spi.PropagationContext;

final class TerminalNode
extends BaseNode
implements TupleSink,
NodeMemory {
    private static final long serialVersionUID = -4172639826881353001L;
    private final Rule rule;
    private final TupleSource tupleSource;
    static /* synthetic */ Class class$0;

    TerminalNode(int id, TupleSource source, Rule rule) {
        super(id);
        this.rule = rule;
        this.tupleSource = source;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void assertTuple(ReteTuple tuple, PropagationContext context, ReteooWorkingMemory workingMemory) {
        this.assertTuple(tuple, context, workingMemory, true);
    }

    public void assertTuple(ReteTuple tuple, PropagationContext context, ReteooWorkingMemory workingMemory, boolean fireActivationCreated) {
        if (this.rule.getNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            return;
        }
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        Duration dur = this.rule.getDuration();
        if (dur != null && dur.getDuration(tuple) > 0L) {
            ScheduledAgendaItem item = new ScheduledAgendaItem(context.getPropagationNumber(), tuple, agenda, context, this.rule);
            if (this.rule.getActivationGroup() != null) {
                TerminalNodeMemory memory = (TerminalNodeMemory)workingMemory.getNodeMemory(this);
                if (memory.getActivationGroup() == null) {
                    memory.setActivationGroup(workingMemory.getAgenda().getActivationGroup(this.rule.getActivationGroup()));
                }
                memory.getActivationGroup().addActivation(item);
            }
            agenda.scheduleItem(item);
            tuple.setActivation(item);
            item.setActivated(true);
            workingMemory.getAgendaEventSupport().fireActivationCreated(item);
        } else {
            TerminalNodeMemory memory = (TerminalNodeMemory)workingMemory.getNodeMemory(this);
            AgendaGroupImpl agendaGroup = memory.getAgendaGroup();
            if (agendaGroup == null) {
                agendaGroup = this.rule.getAgendaGroup() == null || this.rule.getAgendaGroup().equals("") || this.rule.getAgendaGroup().equals("MAIN") ? (AgendaGroupImpl)agenda.getAgendaGroup("MAIN") : (AgendaGroupImpl)agenda.getAgendaGroup(this.rule.getAgendaGroup());
                if (agendaGroup == null) {
                    agendaGroup = new AgendaGroupImpl(this.rule.getAgendaGroup());
                    agenda.addAgendaGroup(agendaGroup);
                }
                memory.setAgendaGroup(agendaGroup);
            }
            if (this.rule.getAutoFocus()) {
                agenda.setFocus(agendaGroup);
            }
            AgendaItem item = new AgendaItem(context.getPropagationNumber(), tuple, context, this.rule);
            if (this.rule.getActivationGroup() != null) {
                if (memory.getActivationGroup() == null) {
                    memory.setActivationGroup(workingMemory.getAgenda().getActivationGroup(this.rule.getActivationGroup()));
                }
                memory.getActivationGroup().addActivation(item);
            }
            agendaGroup.add(item);
            tuple.setActivation(item);
            item.setActivated(true);
            if (fireActivationCreated) {
                workingMemory.getAgendaEventSupport().fireActivationCreated(item);
            }
        }
    }

    public void retractTuple(ReteTuple tuple, PropagationContext context, ReteooWorkingMemory workingMemory) {
        Activation activation = tuple.getActivation();
        if (activation.isActivated()) {
            activation.remove();
            workingMemory.getAgendaEventSupport().fireActivationCancelled(activation);
        }
        workingMemory.getTruthMaintenanceSystem().removeLogicalDependencies(activation, context, this.rule);
    }

    public void modifyTuple(ReteTuple tuple, PropagationContext context, ReteooWorkingMemory workingMemory) {
        if (tuple.getActivation().isActivated()) {
            tuple.getActivation().remove();
        }
        this.assertTuple(tuple, context, workingMemory, false);
    }

    public String toString() {
        return "[TerminalNode: rule=" + this.rule.getName() + "]";
    }

    public void ruleAttached() {
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(ReteooWorkingMemory[] workingMemories) {
        this.attach();
        int i = 0;
        int length = workingMemories.length;
        while (i < length) {
            ReteooWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.tupleSource.updateNewNode(workingMemory, propagationContext);
            ++i;
        }
    }

    public void remove(BaseNode node, ReteooWorkingMemory[] workingMemories) {
        int i = 0;
        int length = workingMemories.length;
        while (i < length) {
            ReteooWorkingMemory workingMemory = workingMemories[i];
            Iterator it = this.tupleSource.getPropagatedTuples(workingMemory, this).iterator();
            while (it.hasNext()) {
                ReteTuple tuple = (ReteTuple)it.next();
                Activation activation = tuple.getActivation();
                if (activation.isActivated()) {
                    activation.remove();
                    workingMemory.getAgendaEventSupport().fireActivationCancelled(activation);
                }
                PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 4, null, null);
                workingMemory.getTruthMaintenanceSystem().removeLogicalDependencies(activation, propagationContext, this.rule);
            }
            workingMemory.propagateQueuedActions();
            ++i;
        }
        this.tupleSource.remove(this, workingMemories);
    }

    public void updateNewNode(ReteooWorkingMemory workingMemory, PropagationContext context) {
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new TerminalNodeMemory();
    }

    public int hashCode() {
        return this.rule.hashCode();
    }

    public boolean equals(Object object) {
        block9: {
            block8: {
                if (object == this) {
                    return true;
                }
                if (object == null) break block8;
                Class<?> clazz = object.getClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.drools.reteoo.TerminalNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) break block9;
            }
            return false;
        }
        TerminalNode other = (TerminalNode)object;
        return this.rule.equals(other.rule);
    }

    class TerminalNodeMemory
    implements Serializable {
        private AgendaGroupImpl agendaGroup;
        private ActivationGroup activationGroup;

        TerminalNodeMemory() {
        }

        public AgendaGroupImpl getAgendaGroup() {
            return this.agendaGroup;
        }

        public void setAgendaGroup(AgendaGroupImpl agendaGroup) {
            this.agendaGroup = agendaGroup;
        }

        public ActivationGroup getActivationGroup() {
            return this.activationGroup;
        }

        public void setActivationGroup(ActivationGroup activationGroup) {
            this.activationGroup = activationGroup;
        }
    }
}

